/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.CustomLoadingExtensionPointBean;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public final class IntentionActionBean
extends CustomLoadingExtensionPointBean<IntentionAction> {
    private static final Logger LOG = Logger.getInstance(IntentionActionBean.class);
    @Tag
    @RequiredElement
    public String className;
    @Tag
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String category;
    @Tag
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String categoryKey;
    @Tag
    public String bundleName;
    @Tag
    public String descriptionDirectoryName;

    @Override
    @Nullable
    protected String getImplementationClassName() {
        return this.className;
    }

    public String @Nullable [] getCategories() {
        if (this.categoryKey != null) {
            String baseName;
            String string = baseName = this.bundleName != null ? this.bundleName : this.getPluginDescriptor().getResourceBundleBaseName();
            if (baseName == null) {
                LOG.error("No resource bundle specified for " + this.getPluginDescriptor());
                return null;
            }
            ResourceBundle bundle = DynamicBundle.INSTANCE.getResourceBundle(baseName, this.getLoaderForClass());
            String[] keys2 = this.categoryKey.split("/");
            if (keys2.length > 1) {
                return ContainerUtil.map2Array(keys2, String.class, s -> AbstractBundle.message(bundle, s, new Object[0]));
            }
            this.category = AbstractBundle.message(bundle, this.categoryKey, new Object[0]);
        }
        return this.category == null ? null : this.category.split("/");
    }

    public String getDescriptionDirectoryName() {
        return this.descriptionDirectoryName;
    }
}

