/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.AbstractEmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewPopupUpdateProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionListStep
implements ListPopupStep<IntentionActionWithTextCaching>,
SpeedSearchFilter<IntentionActionWithTextCaching> {
    private static final Logger LOG = Logger.getInstance(IntentionListStep.class);
    private final CachedIntentions myCachedIntentions;
    @Nullable
    private final IntentionHintComponent myIntentionHintComponent;
    private Runnable myFinalRunnable;
    private final Project myProject;
    private final PsiFile myFile;
    @Nullable
    private final Editor myEditor;

    public IntentionListStep(@Nullable IntentionHintComponent intentionHintComponent, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull Project project2, CachedIntentions intentions) {
        if (file2 == null) {
            IntentionListStep.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            IntentionListStep.$$$reportNull$$$0(1);
        }
        this.myIntentionHintComponent = intentionHintComponent;
        this.myProject = project2;
        this.myFile = file2;
        this.myEditor = editor;
        this.myCachedIntentions = intentions;
    }

    public String getTitle() {
        return null;
    }

    @Override
    public boolean isSelectable(IntentionActionWithTextCaching action2) {
        return true;
    }

    public PopupStep<?> onChosen(IntentionActionWithTextCaching action2, boolean finalChoice) {
        IntentionAction a = IntentionActionDelegate.unwrap(action2.getAction());
        if (finalChoice && !(a instanceof AbstractEmptyIntentionAction)) {
            this.applyAction(action2);
            return FINAL_CHOICE;
        }
        if (this.hasSubstep(action2)) {
            IntentionListStep.closeIntentionPreviewPopup();
            return this.getSubStep(action2, action2.getToolName());
        }
        return FINAL_CHOICE;
    }

    private static void closeIntentionPreviewPopup() {
        ApplicationManager.getApplication().invokeLater(() -> StackingPopupDispatcher.getInstance().getPopupStream().filter(popup2 -> popup2.getUserData(IntentionPreviewPopupUpdateProcessor.IntentionPreviewPopupKey.class) != null).collect(Collectors.toList()).forEach(popup2 -> popup2.cancel()));
    }

    public Runnable getFinalRunnable() {
        return this.myFinalRunnable;
    }

    private void applyAction(@NotNull IntentionActionWithTextCaching cachedAction) {
        if (cachedAction == null) {
            IntentionListStep.$$$reportNull$$$0(2);
        }
        this.myFinalRunnable = () -> {
            PsiFile file2;
            HintManager.getInstance().hideAllHints();
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myEditor != null && (this.myEditor.isDisposed() || !this.myEditor.getComponent().isShowing() && !ApplicationManager.getApplication().isUnitTestMode())) {
                return;
            }
            if (DumbService.isDumb(this.myProject) && !DumbService.isDumbAware(cachedAction)) {
                DumbService.getInstance(this.myProject).showDumbModeNotification(CodeInsightBundle.message("notification.0.is.not.available.during.indexing", cachedAction.getText()));
                return;
            }
            PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
            PsiFile psiFile = file2 = this.myEditor != null ? PsiUtilBase.getPsiFileInEditor(this.myEditor, this.myProject) : this.myFile;
            if (file2 == null) {
                return;
            }
            ShowIntentionActionsHandler.chooseActionAndInvoke(file2, this.myEditor, cachedAction.getAction(), cachedAction.getText(), this.myProject);
        };
    }

    @NotNull
    IntentionListStep getSubStep(@NotNull IntentionActionWithTextCaching action2, final String title) {
        if (action2 == null) {
            IntentionListStep.$$$reportNull$$$0(3);
        }
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        for (IntentionAction optionIntention : action2.getOptionIntentions()) {
            intentions.intentionsToShow.add(new HighlightInfo.IntentionActionDescriptor(optionIntention, IntentionListStep.getIcon(optionIntention)));
        }
        for (IntentionAction optionFix : action2.getOptionErrorFixes()) {
            intentions.errorFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, IntentionListStep.getIcon(optionFix)));
        }
        for (IntentionAction optionFix : action2.getOptionInspectionFixes()) {
            intentions.inspectionFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, IntentionListStep.getIcon(optionFix)));
        }
        return new IntentionListStep(this.myIntentionHintComponent, this.myEditor, this.myFile, this.myProject, CachedIntentions.create(this.myProject, this.myFile, this.myEditor, intentions)){

            @Override
            public String getTitle() {
                return title;
            }
        };
    }

    private static Icon getIcon(IntentionAction optionIntention) {
        return optionIntention instanceof Iconable ? ((Iconable)((Object)optionIntention)).getIcon(0) : null;
    }

    public Map<IntentionAction, List<IntentionAction>> getActionsWithSubActions() {
        LinkedHashMap<IntentionAction, List<IntentionAction>> result2 = new LinkedHashMap<IntentionAction, List<IntentionAction>>();
        for (IntentionActionWithTextCaching cached : this.getValues()) {
            IntentionAction action2 = cached.getAction();
            if (ShowIntentionActionsHandler.chooseFileForAction(this.myFile, this.myEditor, action2) == null) continue;
            List<IntentionActionWithTextCaching> subActions = this.getSubStep(cached, cached.getToolName()).getValues();
            List options = subActions.stream().map(IntentionActionWithTextCaching::getAction).filter(option2 -> ShowIntentionActionsHandler.chooseFileForAction(this.myFile, this.myEditor, option2) != null).collect(Collectors.toList());
            result2.put(action2, options);
        }
        return result2;
    }

    public boolean hasSubstep(IntentionActionWithTextCaching action2) {
        return action2.getOptionIntentions().size() + action2.getOptionErrorFixes().size() > 0;
    }

    @Override
    @NotNull
    public List<IntentionActionWithTextCaching> getValues() {
        List<IntentionActionWithTextCaching> list2 = this.myCachedIntentions.getAllActions();
        if (list2 == null) {
            IntentionListStep.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    @NotNull
    public String getTextFor(IntentionActionWithTextCaching action2) {
        String text2 = action2.getText();
        if (LOG.isDebugEnabled() && text2.startsWith("<html>")) {
            LOG.info("IntentionAction.getText() returned HTML: action=" + action2.getAction().getClass() + " text=" + text2);
        }
        String string = text2;
        if (string == null) {
            IntentionListStep.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public Icon getIconFor(IntentionActionWithTextCaching value2) {
        return this.myCachedIntentions.getIcon(value2);
    }

    public void canceled() {
        if (this.myIntentionHintComponent != null) {
            this.myIntentionHintComponent.canceled(this);
        }
    }

    @Override
    public int getDefaultOptionIndex() {
        return 0;
    }

    @Override
    public ListSeparator getSeparatorAbove(IntentionActionWithTextCaching value2) {
        List<IntentionActionWithTextCaching> values2 = this.getValues();
        int index = values2.indexOf(value2);
        if (index <= 0) {
            return null;
        }
        IntentionActionWithTextCaching prev = values2.get(index - 1);
        if (this.myCachedIntentions.getGroup(value2) != this.myCachedIntentions.getGroup(prev)) {
            return new ListSeparator();
        }
        return null;
    }

    public boolean isMnemonicsNavigationEnabled() {
        return false;
    }

    public MnemonicNavigationFilter<IntentionActionWithTextCaching> getMnemonicNavigationFilter() {
        return null;
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public boolean isAutoSelectionEnabled() {
        return false;
    }

    public SpeedSearchFilter<IntentionActionWithTextCaching> getSpeedSearchFilter() {
        return this;
    }

    public String getIndexedString(IntentionActionWithTextCaching value2) {
        return this.getTextFor(value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/IntentionListStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionListStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyAction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSubStep";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

