/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerImpl;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class IntentionSettingsTree {
    private JComponent myComponent;
    private CheckboxTree myTree;
    private FilterComponent myFilter;
    private final Map<IntentionActionMetaData, Boolean> myIntentionToCheckStatus = new HashMap<IntentionActionMetaData, Boolean>();
    private JPanel myNorthPanel;

    protected IntentionSettingsTree() {
        this.initTree();
    }

    public JTree getTree() {
        return this.myTree;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private void initTree() {
        this.myTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(true){

            @Override
            public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value2 instanceof CheckedTreeNode)) {
                    return;
                }
                CheckedTreeNode node = (CheckedTreeNode)value2;
                SimpleTextAttributes attributes = node.getUserObject() instanceof IntentionActionMetaData ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                String text2 = IntentionSettingsTree.getNodeText(node);
                Color background = UIUtil.getTreeBackground(selected2, true);
                UIUtil.changeBackGround(this, background);
                if (text2 != null) {
                    SearchUtil.appendFragments(IntentionSettingsTree.this.myFilter != null ? IntentionSettingsTree.this.myFilter.getFilter() : null, text2, attributes.getStyle(), attributes.getFgColor(), background, this.getTextRenderer());
                }
            }
        }, new CheckedTreeNode(null));
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path2 = e.getPath();
                Object userObject = ((DefaultMutableTreeNode)path2.getLastPathComponent()).getUserObject();
                IntentionSettingsTree.this.selectionChanged(userObject);
            }
        });
        this.myFilter = new MyFilterComponent();
        this.myComponent = new JPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myTree);
        this.myNorthPanel = new JPanel(new BorderLayout());
        this.myNorthPanel.add((Component)this.myFilter, "Center");
        this.myNorthPanel.setBorder(JBUI.Borders.emptyBottom(2));
        DefaultActionGroup group = new DefaultActionGroup();
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander(this.myTree);
        group.add(actionManager.createExpandAllAction(treeExpander, this.myTree));
        group.add(actionManager.createCollapseAllAction(treeExpander, this.myTree));
        this.myNorthPanel.add((Component)ActionManager.getInstance().createActionToolbar("IntentionSettingsTree", group, true).getComponent(), "West");
        this.myComponent.add((Component)this.myNorthPanel, "North");
        this.myComponent.add((Component)scrollPane, "Center");
        this.myFilter.reset();
    }

    protected abstract void selectionChanged(Object var1);

    protected abstract List<IntentionActionMetaData> filterModel(String var1, boolean var2);

    public void filter(List<IntentionActionMetaData> intentionsToShow) {
        this.refreshCheckStatus((CheckedTreeNode)this.myTree.getModel().getRoot());
        this.reset(intentionsToShow);
    }

    public void reset() {
        while (((IntentionManagerImpl)IntentionManager.getInstance()).hasActiveRequests()) {
            TimeoutUtil.sleep(100L);
        }
        this.resetCheckStatus();
        this.reset(IntentionManagerSettings.getInstance().getMetaData());
    }

    private void resetCheckStatus() {
        this.myIntentionToCheckStatus.clear();
        IntentionManagerSettings manager = IntentionManagerSettings.getInstance();
        for (IntentionActionMetaData metaData : manager.getMetaData()) {
            this.myIntentionToCheckStatus.put(metaData, manager.isEnabled(metaData));
        }
    }

    private void reset(List<IntentionActionMetaData> intentionsToShow) {
        CheckedTreeNode root = new CheckedTreeNode(null);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
        intentionsToShow = IntentionSettingsTree.sort(intentionsToShow);
        for (IntentionActionMetaData metaData : intentionsToShow) {
            String[] category = metaData.myCategory;
            CheckedTreeNode node = root;
            for (String name : category) {
                CheckedTreeNode child2 = IntentionSettingsTree.findChild(node, name);
                if (child2 == null) {
                    CheckedTreeNode newChild = new CheckedTreeNode(name);
                    treeModel.insertNodeInto(newChild, node, node.getChildCount());
                    child2 = newChild;
                }
                node = child2;
            }
            CheckedTreeNode newChild = new CheckedTreeNode(metaData);
            treeModel.insertNodeInto(newChild, node, node.getChildCount());
        }
        this.resetCheckMark(root);
        treeModel.setRoot(root);
        treeModel.nodeChanged(root);
        TreeUtil.expandAll(this.myTree);
        this.myTree.setSelectionRow(0);
    }

    public void selectIntention(String familyName) {
        CheckedTreeNode child2 = IntentionSettingsTree.findChildRecursively(this.getRoot(), familyName);
        if (child2 != null) {
            TreePath path2 = new TreePath(child2.getPath());
            TreeUtil.selectPath(this.myTree, path2);
        }
    }

    private static List<IntentionActionMetaData> sort(List<IntentionActionMetaData> intentionsToShow) {
        ArrayList<IntentionActionMetaData> copy2 = new ArrayList<IntentionActionMetaData>(intentionsToShow);
        Collections.sort(copy2, (data1, data2) -> {
            String[] category1 = data1.myCategory;
            String[] category2 = data2.myCategory;
            int result2 = ArrayUtil.lexicographicCompare(category1, category2);
            if (result2 != 0) {
                return result2;
            }
            return data1.getFamily().compareTo(data2.getFamily());
        });
        return copy2;
    }

    private CheckedTreeNode getRoot() {
        return (CheckedTreeNode)this.myTree.getModel().getRoot();
    }

    private boolean resetCheckMark(final CheckedTreeNode root) {
        Object userObject = root.getUserObject();
        if (userObject instanceof IntentionActionMetaData) {
            IntentionActionMetaData metaData = (IntentionActionMetaData)userObject;
            Boolean b = this.myIntentionToCheckStatus.get(metaData);
            boolean enabled = b == Boolean.TRUE;
            root.setChecked(enabled);
            return enabled;
        }
        root.setChecked(false);
        IntentionSettingsTree.visitChildren(root, new CheckedNodeVisitor(){

            @Override
            public void visit(CheckedTreeNode node) {
                if (IntentionSettingsTree.this.resetCheckMark(node)) {
                    root.setChecked(true);
                }
            }
        });
        return root.isChecked();
    }

    private static CheckedTreeNode findChild(CheckedTreeNode node, final String name) {
        final Ref found2 = new Ref();
        IntentionSettingsTree.visitChildren(node, new CheckedNodeVisitor(){

            @Override
            public void visit(CheckedTreeNode node) {
                String text2 = IntentionSettingsTree.getNodeText(node);
                if (name.equals(text2)) {
                    found2.set(node);
                }
            }
        });
        return (CheckedTreeNode)found2.get();
    }

    private static CheckedTreeNode findChildRecursively(CheckedTreeNode node, final String name) {
        final Ref found2 = new Ref();
        IntentionSettingsTree.visitChildren(node, new CheckedNodeVisitor(){

            @Override
            public void visit(CheckedTreeNode node) {
                if (found2.get() != null) {
                    return;
                }
                Object userObject = node.getUserObject();
                if (userObject instanceof IntentionActionMetaData) {
                    String text2 = IntentionSettingsTree.getNodeText(node);
                    if (name.equals(text2)) {
                        found2.set(node);
                    }
                } else {
                    CheckedTreeNode child2 = IntentionSettingsTree.findChildRecursively(node, name);
                    if (child2 != null) {
                        found2.set(child2);
                    }
                }
            }
        });
        return (CheckedTreeNode)found2.get();
    }

    private static String getNodeText(CheckedTreeNode node) {
        Object userObject = node.getUserObject();
        String text2 = userObject instanceof String ? (String)userObject : (userObject instanceof IntentionActionMetaData ? ((IntentionActionMetaData)userObject).getFamily() : "???");
        return text2;
    }

    public void apply() {
        CheckedTreeNode root = this.getRoot();
        IntentionSettingsTree.apply(root);
    }

    private void refreshCheckStatus(CheckedTreeNode root) {
        Object userObject = root.getUserObject();
        if (userObject instanceof IntentionActionMetaData) {
            IntentionActionMetaData actionMetaData = (IntentionActionMetaData)userObject;
            this.myIntentionToCheckStatus.put(actionMetaData, root.isChecked());
        } else {
            IntentionSettingsTree.visitChildren(root, new CheckedNodeVisitor(){

                @Override
                public void visit(CheckedTreeNode node) {
                    IntentionSettingsTree.this.refreshCheckStatus(node);
                }
            });
        }
    }

    private static void apply(CheckedTreeNode root) {
        Object userObject = root.getUserObject();
        if (userObject instanceof IntentionActionMetaData) {
            IntentionActionMetaData actionMetaData = (IntentionActionMetaData)userObject;
            IntentionManagerSettings.getInstance().setEnabled(actionMetaData, root.isChecked());
        } else {
            IntentionSettingsTree.visitChildren(root, new CheckedNodeVisitor(){

                @Override
                public void visit(CheckedTreeNode node) {
                    IntentionSettingsTree.apply(node);
                }
            });
        }
    }

    public boolean isModified() {
        return IntentionSettingsTree.isModified(this.getRoot());
    }

    private static boolean isModified(CheckedTreeNode root) {
        Object userObject = root.getUserObject();
        if (userObject instanceof IntentionActionMetaData) {
            IntentionActionMetaData actionMetaData = (IntentionActionMetaData)userObject;
            boolean enabled = IntentionManagerSettings.getInstance().isEnabled(actionMetaData);
            return enabled != root.isChecked();
        }
        final boolean[] modified = new boolean[]{false};
        IntentionSettingsTree.visitChildren(root, new CheckedNodeVisitor(){

            @Override
            public void visit(CheckedTreeNode node) {
                modified[0] = modified[0] | IntentionSettingsTree.isModified(node);
            }
        });
        return modified[0];
    }

    public void dispose() {
        this.myFilter.dispose();
    }

    public void setFilter(String filter2) {
        this.myFilter.setFilter(filter2);
    }

    public String getFilter() {
        return this.myFilter.getFilter();
    }

    private static void visitChildren(CheckedTreeNode node, CheckedNodeVisitor visitor) {
        Enumeration<TreeNode> children2 = node.children();
        while (children2.hasMoreElements()) {
            CheckedTreeNode child2 = (CheckedTreeNode)children2.nextElement();
            visitor.visit(child2);
        }
    }

    public JPanel getToolbarPanel() {
        return this.myNorthPanel;
    }

    private class MyFilterComponent
    extends FilterComponent {
        private final TreeExpansionMonitor<DefaultMutableTreeNode> myExpansionMonitor;

        MyFilterComponent() {
            super("INTENTION_FILTER_HISTORY", 10);
            this.myExpansionMonitor = TreeExpansionMonitor.install(IntentionSettingsTree.this.myTree);
        }

        @Override
        public void filter() {
            String filter2 = this.getFilter();
            if (filter2 != null && filter2.length() > 0 && !this.myExpansionMonitor.isFreeze()) {
                this.myExpansionMonitor.freeze();
            }
            IntentionSettingsTree.this.filter(IntentionSettingsTree.this.filterModel(filter2, true));
            if (IntentionSettingsTree.this.myTree != null) {
                List<TreePath> expandedPaths = TreeUtil.collectExpandedPaths(IntentionSettingsTree.this.myTree);
                ((DefaultTreeModel)IntentionSettingsTree.this.myTree.getModel()).reload();
                TreeUtil.restoreExpandedPaths(IntentionSettingsTree.this.myTree, expandedPaths);
            }
            SwingUtilities.invokeLater(() -> {
                IntentionSettingsTree.this.myTree.setSelectionRow(0);
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(IntentionSettingsTree.this.myTree, true));
            });
            TreeUtil.expandAll(IntentionSettingsTree.this.myTree);
            if (filter2 == null || filter2.length() == 0) {
                TreeUtil.collapseAll(IntentionSettingsTree.this.myTree, 0);
                this.myExpansionMonitor.restore();
            }
        }

        @Override
        protected void onlineFilter() {
            String filter2 = this.getFilter();
            if (filter2 != null && filter2.length() > 0 && !this.myExpansionMonitor.isFreeze()) {
                this.myExpansionMonitor.freeze();
            }
            IntentionSettingsTree.this.filter(IntentionSettingsTree.this.filterModel(filter2, true));
            TreeUtil.expandAll(IntentionSettingsTree.this.myTree);
            if (filter2 == null || filter2.length() == 0) {
                TreeUtil.collapseAll(IntentionSettingsTree.this.myTree, 0);
                this.myExpansionMonitor.restore();
            }
        }
    }

    static interface CheckedNodeVisitor {
        public void visit(CheckedTreeNode var1);
    }
}

