/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class ResourceTextDescriptor
implements TextDescriptor {
    private final ClassLoader myLoader;
    private final String myResourcePath;

    ResourceTextDescriptor(ClassLoader loader, @NotNull String resourcePath) {
        if (resourcePath == null) {
            ResourceTextDescriptor.$$$reportNull$$$0(0);
        }
        this.myLoader = loader;
        this.myResourcePath = resourcePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceTextDescriptor resource = (ResourceTextDescriptor)o;
        return Objects.equals(this.myLoader, resource.myLoader) && Objects.equals(this.myResourcePath, resource.myResourcePath);
    }

    public int hashCode() {
        return Objects.hash(this.myLoader, this.myResourcePath);
    }

    @Override
    @NotNull
    public String getText() throws IOException {
        InputStream stream = this.myLoader.getResourceAsStream(this.myResourcePath);
        if (stream == null) {
            throw new IOException("Resource not found: " + this.myResourcePath);
        }
        String string = ResourceUtil.loadText(stream);
        if (string == null) {
            ResourceTextDescriptor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = StringUtil.trimEnd(this.myResourcePath.substring(this.myResourcePath.lastIndexOf(47) + 1), ".template");
        if (string == null) {
            ResourceTextDescriptor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/ResourceTextDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/ResourceTextDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

