/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.preview;

import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewEditor;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewResult;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewUnsupportedOperationException;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \r2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\rB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewComputable;", "Ljava/util/concurrent/Callable;", "Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewResult;", "project", "Lcom/intellij/openapi/project/Project;", "action", "Lcom/intellij/codeInsight/intention/IntentionAction;", "originalFile", "Lcom/intellij/psi/PsiFile;", "originalEditor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInsight/intention/IntentionAction;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "call", "Companion", "intellij.platform.lang.impl"})
public final class IntentionPreviewComputable
implements Callable<IntentionPreviewResult> {
    private final Project project;
    private final IntentionAction action;
    private final PsiFile originalFile;
    private final Editor originalEditor;
    private static final Logger LOG;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public IntentionPreviewResult call() {
        PsiElement psiElement = this.originalFile.copy();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
        }
        PsiFile psiFileCopy = (PsiFile)psiElement;
        ProgressManager.checkCanceled();
        CaretModel caretModel = this.originalEditor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"originalEditor.caretModel");
        IntentionPreviewEditor editorCopy = new IntentionPreviewEditor(psiFileCopy, caretModel.getOffset());
        try {
            IntentionAction intentionAction = IntentionPreviewComputable.Companion.findCopyIntention(this.project, editorCopy, psiFileCopy, this.action);
            if (intentionAction == null) {
                return null;
            }
            IntentionAction action2 = intentionAction;
            Pair<PsiFile, Editor> pair = ShowIntentionActionsHandler.chooseFileForAction(psiFileCopy, editorCopy, action2);
            if (pair == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull(pair, (String)"ShowIntentionActionsHand\u2026           ?: return null");
            Pair<PsiFile, Editor> fileEditorPair = pair;
            Document document = this.originalEditor.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"originalEditor.document");
            boolean writable = document.isWritable();
            try {
                this.originalEditor.getDocument().setReadOnly(true);
                ProgressManager.checkCanceled();
                action2.invoke(this.project, (Editor)fileEditorPair.second, (PsiFile)fileEditorPair.first);
                ProgressManager.checkCanceled();
                this.originalEditor.getDocument().setReadOnly(!writable);
            }
            catch (Throwable throwable) {
                this.originalEditor.getDocument().setReadOnly(!writable);
                throw throwable;
            }
            ComparisonManager comparisonManager = ComparisonManager.getInstance();
            CharSequence charSequence = this.originalFile.getText();
            Document document2 = editorCopy.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"editorCopy.document");
            List<LineFragment> list2 = comparisonManager.compareLines(charSequence, document2.getText(), ComparisonPolicy.TRIM_WHITESPACES, DumbProgressIndicator.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ComparisonManager.getIns\u2026ogressIndicator.INSTANCE)");
            return new IntentionPreviewResult(psiFileCopy, list2);
        }
        catch (IntentionPreviewUnsupportedOperationException e) {
            return null;
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            LOG.debug("There are exceptions on invocation the intention: '" + this.action.getText() + "' on a copy of the file.", e);
            return null;
        }
    }

    public IntentionPreviewComputable(@NotNull Project project2, @NotNull IntentionAction action2, @NotNull PsiFile originalFile, @NotNull Editor originalEditor) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)action2, (String)"action");
        Intrinsics.checkParameterIsNotNull((Object)originalFile, (String)"originalFile");
        Intrinsics.checkParameterIsNotNull((Object)originalEditor, (String)"originalEditor");
        this.project = project2;
        this.action = action2;
        this.originalFile = originalFile;
        this.originalEditor = originalEditor;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(IntentionPreviewComputable.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Inten\u2026ewComputable::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewComputable$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "findCopyIntention", "Lcom/intellij/codeInsight/intention/IntentionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editorCopy", "Lcom/intellij/openapi/editor/Editor;", "psiFileCopy", "Lcom/intellij/psi/PsiFile;", "originalAction", "getFixes", "Lkotlin/sequences/Sequence;", "Lcom/intellij/codeInsight/intention/impl/IntentionActionWithTextCaching;", "cachedIntentions", "Lcom/intellij/codeInsight/intention/impl/CachedIntentions;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final Sequence<IntentionActionWithTextCaching> getFixes(@NotNull CachedIntentions cachedIntentions) {
            Intrinsics.checkParameterIsNotNull((Object)cachedIntentions, (String)"cachedIntentions");
            Sequence sequence = SequencesKt.sequenceOf((Object[])new IntentionActionWithTextCaching[0]);
            Set<IntentionActionWithTextCaching> set = cachedIntentions.getIntentions();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"cachedIntentions.intentions");
            Sequence sequence2 = SequencesKt.plus((Sequence)sequence, (Iterable)set);
            Set<IntentionActionWithTextCaching> set2 = cachedIntentions.getInspectionFixes();
            Intrinsics.checkExpressionValueIsNotNull(set2, (String)"cachedIntentions.inspectionFixes");
            Sequence sequence3 = SequencesKt.plus((Sequence)sequence2, (Iterable)set2);
            Set<IntentionActionWithTextCaching> set3 = cachedIntentions.getErrorFixes();
            Intrinsics.checkExpressionValueIsNotNull(set3, (String)"cachedIntentions.errorFixes");
            return SequencesKt.plus((Sequence)sequence3, (Iterable)set3);
        }

        private final IntentionAction findCopyIntention(Project project2, Editor editorCopy, PsiFile psiFileCopy, IntentionAction originalAction) {
            Object v2;
            block1: {
                ShowIntentionsPass.IntentionsInfo intentionsInfo = ShowIntentionsPass.getActionsToShow(editorCopy, psiFileCopy, false);
                Intrinsics.checkExpressionValueIsNotNull((Object)intentionsInfo, (String)"ShowIntentionsPass.getAc\u2026Copy, psiFileCopy, false)");
                ShowIntentionsPass.IntentionsInfo actionsToShow = intentionsInfo;
                CachedIntentions cachedIntentions = CachedIntentions.createAndUpdateActions(project2, psiFileCopy, editorCopy, actionsToShow);
                Intrinsics.checkExpressionValueIsNotNull((Object)cachedIntentions, (String)"CachedIntentions.createA\u2026ditorCopy, actionsToShow)");
                CachedIntentions cachedIntentions2 = cachedIntentions;
                Sequence<IntentionActionWithTextCaching> sequence = this.getFixes(cachedIntentions2);
                boolean bl = false;
                Sequence<IntentionActionWithTextCaching> sequence2 = sequence;
                boolean bl2 = false;
                for (Object e : sequence2) {
                    IntentionActionWithTextCaching it = (IntentionActionWithTextCaching)e;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getText(), (Object)originalAction.getText())) continue;
                    v2 = e;
                    break block1;
                }
                v2 = null;
            }
            IntentionActionWithTextCaching intentionActionWithTextCaching = v2;
            return intentionActionWithTextCaching != null ? intentionActionWithTextCaching.getAction() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

