/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ComparingClassifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.ForceableComparable;
import com.intellij.util.ProcessingContext;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingComparingClassifier
extends ComparingClassifier<LookupElement> {
    private final Map<LookupElement, Comparable> myWeights = new IdentityHashMap<LookupElement, Comparable>();
    private final LookupElementWeigher myWeigher;
    private Ref<Comparable> myFirstWeight;
    private boolean myPrimitive = true;
    private int myPrefixChanges = -1;

    public CachingComparingClassifier(Classifier<LookupElement> next, LookupElementWeigher weigher) {
        super(next, weigher.toString(), weigher.isNegated());
        this.myWeigher = weigher;
    }

    @Override
    @Nullable
    public final Comparable getWeight(LookupElement element2, ProcessingContext context) {
        Comparable w = this.myWeights.get(element2);
        if (w == null && this.myWeigher.isPrefixDependent()) {
            w = this.myWeigher.weigh(element2, context.get(CompletionLookupArranger.WEIGHING_CONTEXT));
            this.myWeights.put(element2, w);
        }
        return w;
    }

    @Override
    public void removeElement(@NotNull LookupElement element2, @NotNull ProcessingContext context) {
        if (element2 == null) {
            CachingComparingClassifier.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CachingComparingClassifier.$$$reportNull$$$0(1);
        }
        this.myWeights.remove(element2);
        super.removeElement(element2, context);
    }

    @Override
    @NotNull
    public Iterable<LookupElement> classify(@NotNull Iterable<? extends LookupElement> source, @NotNull ProcessingContext context) {
        if (source == null) {
            CachingComparingClassifier.$$$reportNull$$$0(2);
        }
        if (context == null) {
            CachingComparingClassifier.$$$reportNull$$$0(3);
        }
        if (!this.myWeigher.isPrefixDependent() && this.myPrimitive) {
            Iterable<LookupElement> iterable = this.myNext.classify(source, context);
            if (iterable == null) {
                CachingComparingClassifier.$$$reportNull$$$0(4);
            }
            return iterable;
        }
        this.checkPrefixChanged(context);
        Iterable<LookupElement> iterable = super.classify(source, context);
        if (iterable == null) {
            CachingComparingClassifier.$$$reportNull$$$0(5);
        }
        return iterable;
    }

    private void checkPrefixChanged(ProcessingContext context) {
        int actualPrefixChanges = context.get(CompletionLookupArranger.PREFIX_CHANGES);
        if (this.myWeigher.isPrefixDependent() && this.myPrefixChanges != actualPrefixChanges) {
            this.myPrefixChanges = actualPrefixChanges;
            this.myWeights.clear();
        }
    }

    @Override
    @NotNull
    public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<? extends LookupElement> items, @NotNull ProcessingContext context) {
        if (items == null) {
            CachingComparingClassifier.$$$reportNull$$$0(6);
        }
        if (context == null) {
            CachingComparingClassifier.$$$reportNull$$$0(7);
        }
        this.checkPrefixChanged(context);
        List<Pair<LookupElement, Object>> list2 = super.getSortingWeights(items, context);
        if (list2 == null) {
            CachingComparingClassifier.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    public void addElement(@NotNull LookupElement t, @NotNull ProcessingContext context) {
        Comparable weight2;
        if (t == null) {
            CachingComparingClassifier.$$$reportNull$$$0(9);
        }
        if (context == null) {
            CachingComparingClassifier.$$$reportNull$$$0(10);
        }
        if ((weight2 = this.myWeigher.weigh(t, context.get(CompletionLookupArranger.WEIGHING_CONTEXT))) instanceof ForceableComparable) {
            ((ForceableComparable)((Object)weight2)).force();
        }
        if (!this.myWeigher.isPrefixDependent() && this.myPrimitive) {
            if (this.myFirstWeight == null) {
                this.myFirstWeight = Ref.create(weight2);
            } else if (!Comparing.equal(this.myFirstWeight.get(), weight2)) {
                this.myPrimitive = false;
            }
        }
        this.myWeights.put(t, weight2);
        super.addElement(t, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/CachingComparingClassifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/CachingComparingClassifier";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortingWeights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSortingWeights";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

