/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.TailType;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;

public class EqTailType
extends TailType {
    public static final TailType INSTANCE = new EqTailType();

    protected boolean isSpaceAroundAssignmentOperators(Editor editor, int tailOffset) {
        CodeStyleFacade codeStyleFacade = CodeStyleFacade.getInstance(editor.getProject());
        PsiFile psiFile = PsiEditorUtil.getPsiFile(editor);
        Language language2 = PsiUtilCore.getLanguageAtOffset(psiFile, tailOffset);
        return codeStyleFacade.useSpaceAroundAssignmentOperators(psiFile, language2);
    }

    @Override
    public int processTail(Editor editor, int tailOffset) {
        Document document = editor.getDocument();
        int textLength = document.getTextLength();
        CharSequence chars = document.getCharsSequence();
        if (tailOffset < textLength - 1 && chars.charAt(tailOffset) == ' ' && chars.charAt(tailOffset + 1) == '=') {
            return EqTailType.moveCaret(editor, tailOffset, 2);
        }
        if (tailOffset < textLength && chars.charAt(tailOffset) == '=') {
            return EqTailType.moveCaret(editor, tailOffset, 1);
        }
        if (this.isSpaceAroundAssignmentOperators(editor, tailOffset)) {
            document.insertString(tailOffset, " =");
            tailOffset = EqTailType.moveCaret(editor, tailOffset, 2);
            tailOffset = EqTailType.insertChar(editor, tailOffset, ' ');
        } else {
            document.insertString(tailOffset, "=");
            tailOffset = EqTailType.moveCaret(editor, tailOffset, 1);
        }
        return tailOffset;
    }
}

