/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupElementDecorator<T extends LookupElement>
extends LookupElement {
    private final T myDelegate;

    protected LookupElementDecorator(T delegate) {
        this.myDelegate = delegate;
        ((UserDataHolderBase)this.myDelegate).copyUserDataTo(this);
    }

    public T getDelegate() {
        return this.myDelegate;
    }

    @Override
    public boolean isValid() {
        return ((LookupElement)this.myDelegate).isValid() && super.isValid();
    }

    @Override
    @NotNull
    public String getLookupString() {
        String string = ((LookupElement)this.myDelegate).getLookupString();
        if (string == null) {
            LookupElementDecorator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public Set<String> getAllLookupStrings() {
        return ((LookupElement)this.myDelegate).getAllLookupStrings();
    }

    @Override
    @NotNull
    public Object getObject() {
        Object object = ((LookupElement)this.myDelegate).getObject();
        if (object == null) {
            LookupElementDecorator.$$$reportNull$$$0(1);
        }
        return object;
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            LookupElementDecorator.$$$reportNull$$$0(2);
        }
        ((LookupElement)this.myDelegate).handleInsert(context);
    }

    @Override
    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return ((LookupElement)this.myDelegate).getAutoCompletionPolicy();
    }

    @Override
    public String toString() {
        return ((LookupElement)this.myDelegate).toString();
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        ((LookupElement)this.myDelegate).renderElement(presentation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupElementDecorator that = (LookupElementDecorator)o;
        return this.myDelegate.equals(that.myDelegate);
    }

    public int hashCode() {
        return this.myDelegate.hashCode();
    }

    @NotNull
    public static <T extends LookupElement> LookupElementDecorator<T> withInsertHandler(@NotNull T element2, @NotNull InsertHandler<? super LookupElementDecorator<T>> insertHandler) {
        if (element2 == null) {
            LookupElementDecorator.$$$reportNull$$$0(3);
        }
        if (insertHandler == null) {
            LookupElementDecorator.$$$reportNull$$$0(4);
        }
        return new InsertingDecorator<T>(element2, insertHandler);
    }

    @NotNull
    public static <T extends LookupElement> LookupElementDecorator<T> withRenderer(@NotNull T element2, @NotNull LookupElementRenderer<? super LookupElementDecorator<T>> visagiste) {
        if (element2 == null) {
            LookupElementDecorator.$$$reportNull$$$0(5);
        }
        if (visagiste == null) {
            LookupElementDecorator.$$$reportNull$$$0(6);
        }
        return new VisagisteDecorator<T>(element2, visagiste);
    }

    @Override
    public <T> T as(ClassConditionKey<T> conditionKey) {
        T t = super.as(conditionKey);
        return t == null ? ((LookupElement)this.myDelegate).as(conditionKey) : t;
    }

    @Override
    public <T> T as(Class<T> clazz) {
        T t = super.as(clazz);
        return t == null ? ((LookupElement)this.myDelegate).as(clazz) : t;
    }

    @Override
    public boolean isCaseSensitive() {
        return ((LookupElement)this.myDelegate).isCaseSensitive();
    }

    @Override
    public boolean isWorthShowingInAutoPopup() {
        return ((LookupElement)this.myDelegate).isWorthShowingInAutoPopup();
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return ((LookupElement)this.myDelegate).getPsiElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/LookupElementDecorator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visagiste";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/LookupElementDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withInsertHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VisagisteDecorator<T extends LookupElement>
    extends LookupElementDecorator<T> {
        private final LookupElementRenderer<? super LookupElementDecorator<T>> myVisagiste;

        VisagisteDecorator(T element2, LookupElementRenderer<? super LookupElementDecorator<T>> visagiste) {
            super(element2);
            this.myVisagiste = visagiste;
        }

        @Override
        public void renderElement(LookupElementPresentation presentation) {
            this.myVisagiste.renderElement(this, presentation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VisagisteDecorator that = (VisagisteDecorator)o;
            return this.myVisagiste.getClass().equals(that.myVisagiste.getClass());
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.myVisagiste.getClass().hashCode();
            return result2;
        }
    }

    private static class InsertingDecorator<T extends LookupElement>
    extends LookupElementDecorator<T> {
        private final InsertHandler<? super LookupElementDecorator<T>> myInsertHandler;

        InsertingDecorator(T element2, InsertHandler<? super LookupElementDecorator<T>> insertHandler) {
            super(element2);
            this.myInsertHandler = insertHandler;
        }

        @Override
        public void handleInsert(@NotNull InsertionContext context) {
            if (context == null) {
                InsertingDecorator.$$$reportNull$$$0(0);
            }
            this.myInsertHandler.handleInsert(context, this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InsertingDecorator that = (InsertingDecorator)o;
            return this.myInsertHandler.equals(that.myInsertHandler);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.myInsertHandler.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/lookup/LookupElementDecorator$InsertingDecorator", "handleInsert"));
        }
    }
}

