/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J0\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0007H\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/codeInsight/lookup/LookupUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getCaseCorrectedLookupString", "", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "prefix", "getInjectedDocument", "Lcom/intellij/injected/editor/DocumentWindow;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "insertLookupInDocument", "caretOffset", "document", "Lcom/intellij/openapi/editor/Document;", "lookupString", "insertLookupInDocumentWindowIfNeeded", "intellij.platform.analysis.impl"})
@ApiStatus.Internal
public final class LookupUtil {
    private static final Logger LOG;
    public static final LookupUtil INSTANCE;

    @JvmStatic
    public static final int insertLookupInDocumentWindowIfNeeded(@NotNull Project project2, @NotNull Editor editor, int caretOffset, int prefix, @NotNull String lookupString) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)lookupString, (String)"lookupString");
        DocumentWindow document = INSTANCE.getInjectedDocument(project2, editor, caretOffset);
        if (document == null) {
            Document document2 = editor.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"editor.document");
            return INSTANCE.insertLookupInDocument(caretOffset, document2, prefix, lookupString);
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(document);
        int offset = document.hostToInjected(caretOffset);
        int n2 = offset - prefix;
        int n3 = 0;
        boolean bl = false;
        n2 = Math.max(n2, n3);
        n3 = 0;
        int lookupStart = Math.min(offset, n2);
        int diff = -1;
        if (file2 != null) {
            List<TextRange> list2 = InjectedLanguageManager.getInstance(project2).intersectWithAllEditableFragments(file2, TextRange.create(lookupStart, offset));
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"InjectedLanguageManager.\u2026ate(lookupStart, offset))");
            List<TextRange> ranges2 = list2;
            Collection collection = ranges2;
            boolean bl2 = false;
            if (!collection.isEmpty()) {
                TextRange textRange = ranges2.get(0);
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"ranges[0]");
                diff = textRange.getStartOffset() - lookupStart;
                if (ranges2.size() == 1 && diff == 0) {
                    diff = -1;
                }
            }
        }
        if (diff == -1) {
            Document document3 = editor.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"editor.document");
            n = INSTANCE.insertLookupInDocument(caretOffset, document3, prefix, lookupString);
        } else {
            String string;
            DocumentWindow documentWindow = document;
            LookupUtil lookupUtil = INSTANCE;
            int n4 = offset;
            Document document4 = document;
            int n5 = prefix - diff;
            if (diff == 0) {
                string = lookupString;
            } else {
                String string2 = lookupString;
                int n6 = n5;
                Document document5 = document4;
                int n7 = n4;
                LookupUtil lookupUtil2 = lookupUtil;
                DocumentWindow documentWindow2 = documentWindow;
                bl = false;
                String string3 = string2.substring(diff);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String string4 = string3;
                documentWindow = documentWindow2;
                lookupUtil = lookupUtil2;
                n4 = n7;
                document4 = document5;
                n5 = n6;
                string = string4;
            }
            n = documentWindow.injectedToHost(lookupUtil.insertLookupInDocument(n4, document4, n5, string));
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @NotNull
    public static final String getCaseCorrectedLookupString(@NotNull LookupElement item, @NotNull PrefixMatcher prefixMatcher, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        v0 = item.getLookupString();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"item.lookupString");
        lookupString = v0;
        if (item.isCaseSensitive()) {
            return lookupString;
        }
        length = prefix.length();
        if (length == 0 || !prefixMatcher.prefixMatches(prefix)) {
            return lookupString;
        }
        isAllLower = true;
        isAllUpper = true;
        sameCase = true;
        i = 0;
        while (i < length && (isAllLower || isAllUpper || sameCase)) {
            var11_11 = c = prefix.charAt(i);
            var12_12 = '\u0000';
            isLower = Character.isLowerCase(var11_11);
            var12_12 = c;
            var13_13 = false;
            isUpper = Character.isUpperCase(var12_12);
            if (!isLower && !isUpper) {
                ++i;
                continue;
            }
            isAllLower = isAllLower != false && isLower != false;
            v1 = isAllUpper = isAllUpper != false && isUpper != false;
            if (!sameCase || i >= lookupString.length()) ** GOTO lbl-1000
            var12_12 = lookupString.charAt(i);
            var14_14 = isLower;
            var13_13 = false;
            var15_15 = Character.isLowerCase(var12_12);
            if (var14_14 == var15_15) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            sameCase = v2;
            ++i;
        }
        if (sameCase) {
            return lookupString;
        }
        if (isAllLower) {
            v3 = StringUtil.toLowerCase(lookupString);
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"StringUtil.toLowerCase(lookupString)");
            return v3;
        }
        if (isAllUpper) {
            v4 = StringUtil.toUpperCase(lookupString);
            v5 = v4;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"StringUtil.toUpperCase(lookupString)");
        } else {
            v5 = lookupString;
        }
        return v5;
    }

    private final DocumentWindow getInjectedDocument(Project project2, Editor editor, int offset) {
        PsiFile hostFile = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
        if (hostFile != null) {
            List<DocumentWindow> list2 = InjectedLanguageManager.getInstance(project2).getCachedInjectedDocumentsInRange(hostFile, TextRange.create(offset, offset));
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"InjectedLanguageManager.\u2026e.create(offset, offset))");
            List<DocumentWindow> injected = list2;
            Iterator<DocumentWindow> iterator2 = injected.iterator();
            while (iterator2.hasNext()) {
                DocumentWindow documentWindow;
                DocumentWindow documentWindow2 = documentWindow = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)documentWindow2, (String)"documentWindow");
                if (!documentWindow2.isValid() || !documentWindow.containsRange(offset, offset)) continue;
                return documentWindow;
            }
        }
        return null;
    }

    private final int insertLookupInDocument(int caretOffset, Document document, int prefix, String lookupString) {
        int len;
        int n = caretOffset - prefix;
        int n2 = 0;
        boolean bl = false;
        n = Math.max(n, n2);
        n2 = 0;
        int lookupStart = Math.min(caretOffset, n);
        n2 = lookupStart;
        LOG.assertTrue(0 <= n2 && (len = document.getTextLength()) >= n2, "ls: " + lookupStart + " caret: " + caretOffset + " prefix:" + prefix + " doc: " + len);
        n2 = caretOffset;
        LOG.assertTrue(0 <= n2 && len >= n2, "co: " + caretOffset + " doc: " + len);
        document.replaceString(lookupStart, caretOffset, lookupString);
        return lookupStart + lookupString.length();
    }

    private LookupUtil() {
    }

    static {
        LookupUtil lookupUtil;
        INSTANCE = lookupUtil = new LookupUtil();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LookupUtil.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

