/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import com.intellij.codeInsight.lookup.RealLookupElementPresentation;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupCellRenderer
implements ListCellRenderer<LookupElement> {
    private static final Logger LOG = Logger.getInstance(LookupCellRenderer.class);
    private Icon myEmptyIcon = EmptyIcon.ICON_0;
    private final Font myNormalFont;
    private final Font myBoldFont;
    private final FontMetrics myNormalMetrics;
    private final FontMetrics myBoldMetrics;
    @Deprecated
    public static final Color FOREGROUND_COLOR = JBColor.namedColor("CompletionPopup.foreground", JBColor.foreground());
    @Deprecated
    public static final Color SELECTED_FOREGROUND_COLOR = JBColor.namedColor("CompletionPopup.selectionForeground", new JBColor(JBColor.WHITE, JBColor.foreground()));
    public static final Color BACKGROUND_COLOR = new JBColor(() -> EditorColorsUtil.getGlobalOrDefaultColor(DocumentationComponent.COLOR_KEY));
    private static final Color MATCHED_FOREGROUND_COLOR = JBColor.namedColor("CompletionPopup.matchForeground", JBUI.CurrentTheme.Link.linkColor());
    private static final Color SELECTED_BACKGROUND_COLOR = JBColor.namedColor("CompletionPopup.selectionBackground", new JBColor(12967932, 1129052));
    public static final Color SELECTED_NON_FOCUSED_BACKGROUND_COLOR = JBColor.namedColor("CompletionPopup.selectionInactiveBackground", new JBColor(0xE0E0E0, 5330007));
    private static final Color NON_FOCUSED_MASK_COLOR = JBColor.namedColor("CompletionPopup.nonFocusedMask", Gray._0.withAlpha(0));
    private final LookupImpl myLookup;
    private final SimpleColoredComponent myNameComponent;
    private final SimpleColoredComponent myTailComponent;
    private final SimpleColoredComponent myTypeLabel;
    private final LookupPanel myPanel;
    private final Map<Integer, Boolean> mySelected = new HashMap<Integer, Boolean>();
    private static final String ELLIPSIS = "\u2026";
    private int myMaxWidth = -1;
    private boolean myIsSelected = false;

    public LookupCellRenderer(LookupImpl lookup2) {
        EditorColorsScheme scheme = lookup2.getTopLevelEditor().getColorsScheme();
        this.myNormalFont = scheme.getFont(EditorFontType.PLAIN);
        this.myBoldFont = scheme.getFont(EditorFontType.BOLD);
        this.myLookup = lookup2;
        this.myNameComponent = new MySimpleColoredComponent();
        this.myNameComponent.setIconTextGap(JBUIScale.scale(4));
        this.myNameComponent.setIpad(JBUI.insetsLeft(1));
        this.myNameComponent.setMyBorder(null);
        this.myTailComponent = new MySimpleColoredComponent();
        this.myTailComponent.setIpad(JBUI.emptyInsets());
        this.myTailComponent.setBorder(JBUI.Borders.emptyRight(10));
        this.myTypeLabel = new MySimpleColoredComponent();
        this.myTypeLabel.setIpad(JBUI.emptyInsets());
        this.myTypeLabel.setBorder(JBUI.Borders.emptyRight(10));
        this.myPanel = new LookupPanel();
        this.myPanel.add((Component)this.myNameComponent, "West");
        this.myPanel.add((Component)this.myTailComponent, "Center");
        this.myPanel.add((Component)this.myTypeLabel, "East");
        this.myNormalMetrics = this.myLookup.getTopLevelEditor().getComponent().getFontMetrics(this.myNormalFont);
        this.myBoldMetrics = this.myLookup.getTopLevelEditor().getComponent().getFontMetrics(this.myBoldFont);
    }

    @Override
    public Component getListCellRendererComponent(JList list2, LookupElement item, int index, boolean isSelected, boolean hasFocus) {
        boolean useBoxLayout;
        boolean nonFocusedSelection;
        boolean bl = nonFocusedSelection = isSelected && this.myLookup.getLookupFocusDegree() == LookupFocusDegree.SEMI_FOCUSED;
        if (!this.myLookup.isFocused()) {
            isSelected = false;
        }
        this.myIsSelected = isSelected;
        Color background = nonFocusedSelection ? SELECTED_NON_FOCUSED_BACKGROUND_COLOR : (isSelected ? SELECTED_BACKGROUND_COLOR : BACKGROUND_COLOR);
        int allowedWidth = list2.getWidth() - LookupCellRenderer.calcSpacing(this.myNameComponent, this.myEmptyIcon) - LookupCellRenderer.calcSpacing(this.myTailComponent, null) - LookupCellRenderer.calcSpacing(this.myTypeLabel, null);
        FontMetrics normalMetrics = this.getRealFontMetrics(item, false);
        FontMetrics boldMetrics = this.getRealFontMetrics(item, true);
        RealLookupElementPresentation presentation = new RealLookupElementPresentation(isSelected ? this.getMaxWidth() : allowedWidth, normalMetrics, boldMetrics, this.myLookup);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (item.isValid()) {
                try {
                    item.renderElement(presentation);
                }
                catch (ProcessCanceledException e) {
                    LOG.info(e);
                    presentation.setItemTextForeground(JBColor.RED);
                    presentation.setItemText("Error occurred, see the log in Help | Show Log");
                }
                catch (Error | Exception e) {
                    LOG.error(e);
                }
            } else {
                presentation.setItemTextForeground(JBColor.RED);
                presentation.setItemText("Invalid");
            }
        });
        this.myNameComponent.clear();
        this.myNameComponent.setBackground(background);
        Color itemColor = presentation.getItemTextForeground();
        allowedWidth -= this.setItemTextLabel(item, itemColor, presentation, allowedWidth);
        Font font = this.myLookup.getCustomFont(item, false);
        if (font == null) {
            font = this.myNormalFont;
        }
        this.myTailComponent.setFont(font);
        this.myTypeLabel.setFont(font);
        this.myNameComponent.setIcon(LookupCellRenderer.augmentIcon(this.myLookup.getTopLevelEditor(), presentation.getIcon(), this.myEmptyIcon));
        Color grayedForeground = LookupCellRenderer.getGrayedForeground(isSelected);
        this.myTypeLabel.clear();
        if (allowedWidth > 0) {
            allowedWidth -= this.setTypeTextLabel(item, background, grayedForeground, presentation, isSelected ? this.getMaxWidth() : allowedWidth, isSelected, nonFocusedSelection, normalMetrics);
        } else {
            this.myTypeLabel.setBackground(background);
        }
        this.myTailComponent.clear();
        this.myTailComponent.setBackground(background);
        if (isSelected || allowedWidth >= 0) {
            this.setTailTextLabel(isSelected, presentation, grayedForeground, isSelected ? this.getMaxWidth() : allowedWidth, nonFocusedSelection, normalMetrics);
        }
        if (this.mySelected.containsKey(index) && !isSelected && this.mySelected.get(index).booleanValue()) {
            this.myPanel.setUpdateExtender(true);
        }
        this.mySelected.put(index, isSelected);
        double w = this.myNameComponent.getPreferredSize().getWidth() + this.myTailComponent.getPreferredSize().getWidth() + this.myTypeLabel.getPreferredSize().getWidth();
        boolean bl2 = useBoxLayout = isSelected && w > (double)list2.getWidth() && ((JBList)list2).getExpandableItemsHandler().isEnabled();
        if (useBoxLayout != this.myPanel.getLayout() instanceof BoxLayout) {
            this.myPanel.removeAll();
            if (useBoxLayout) {
                this.myPanel.setLayout(new BoxLayout(this.myPanel, 0));
                this.myPanel.add(this.myNameComponent);
                this.myPanel.add(this.myTailComponent);
                this.myPanel.add(this.myTypeLabel);
            } else {
                this.myPanel.setLayout(new BorderLayout());
                this.myPanel.add((Component)this.myNameComponent, "West");
                this.myPanel.add((Component)this.myTailComponent, "Center");
                this.myPanel.add((Component)this.myTypeLabel, "East");
            }
        }
        AccessibleContextUtil.setCombinedName(this.myPanel, this.myNameComponent, "", this.myTailComponent, " - ", this.myTypeLabel);
        AccessibleContextUtil.setCombinedDescription(this.myPanel, this.myNameComponent, "", this.myTailComponent, " - ", this.myTypeLabel);
        return this.myPanel;
    }

    private static int calcSpacing(@NotNull SimpleColoredComponent component2, @Nullable Icon icon2) {
        Insets insets;
        if (component2 == null) {
            LookupCellRenderer.$$$reportNull$$$0(0);
        }
        Insets iPad = component2.getIpad();
        int width = iPad.left + iPad.right;
        Border myBorder = component2.getMyBorder();
        if (myBorder != null) {
            insets = myBorder.getBorderInsets(component2);
            width += insets.left + insets.right;
        }
        if ((insets = component2.getInsets()) != null) {
            width += insets.left + insets.right;
        }
        if (icon2 != null) {
            width += icon2.getIconWidth() + component2.getIconTextGap();
        }
        return width;
    }

    private int getMaxWidth() {
        if (this.myMaxWidth < 0) {
            Point p = this.myLookup.getComponent().getLocationOnScreen();
            Rectangle rectangle = ScreenUtil.getScreenRectangle(p);
            this.myMaxWidth = rectangle.x + rectangle.width - p.x - 111;
        }
        return this.myMaxWidth;
    }

    private void setTailTextLabel(boolean isSelected, LookupElementPresentation presentation, Color foreground, int allowedWidth, boolean nonFocusedSelection, FontMetrics fontMetrics) {
        int style = LookupCellRenderer.getStyle(false, presentation.isStrikeout(), false, false);
        for (LookupElementPresentation.TextFragment fragment : presentation.getTailFragments()) {
            if (allowedWidth < 0) {
                return;
            }
            String trimmed = this.trimLabelText(fragment.text, allowedWidth, fontMetrics);
            int fragmentStyle = fragment.isItalic() ? style | 2 : style;
            this.myTailComponent.append(trimmed, new SimpleTextAttributes(fragmentStyle, LookupCellRenderer.getTailTextColor(isSelected, fragment, foreground, nonFocusedSelection)));
            allowedWidth -= RealLookupElementPresentation.getStringWidth(trimmed, fontMetrics);
        }
    }

    private String trimLabelText(@Nullable String text2, int maxWidth, FontMetrics metrics) {
        if (text2 == null || StringUtil.isEmpty(text2)) {
            return "";
        }
        int strWidth = RealLookupElementPresentation.getStringWidth(text2, metrics);
        if (strWidth <= maxWidth || this.myIsSelected) {
            return text2;
        }
        if (RealLookupElementPresentation.getStringWidth(ELLIPSIS, metrics) > maxWidth) {
            return "";
        }
        int insIndex = ObjectUtils.binarySearch(0, text2.length(), mid -> {
            String candidate = text2.substring(0, mid) + ELLIPSIS;
            int width = RealLookupElementPresentation.getStringWidth(candidate, metrics);
            return width <= maxWidth ? -1 : 1;
        });
        int i = Math.max(0, -insIndex - 2);
        return text2.substring(0, i) + ELLIPSIS;
    }

    private static Color getTypeTextColor(LookupElement item, Color foreground, LookupElementPresentation presentation, boolean selected2, boolean nonFocusedSelection) {
        if (nonFocusedSelection) {
            return foreground;
        }
        return presentation.isTypeGrayed() ? LookupCellRenderer.getGrayedForeground(selected2) : (item instanceof EmptyLookupItem ? JBColor.foreground() : foreground);
    }

    private static Color getTailTextColor(boolean isSelected, LookupElementPresentation.TextFragment fragment, Color defaultForeground, boolean nonFocusedSelection) {
        Color tailForeground;
        if (nonFocusedSelection) {
            return defaultForeground;
        }
        if (fragment.isGrayed()) {
            return LookupCellRenderer.getGrayedForeground(isSelected);
        }
        if (!isSelected && (tailForeground = fragment.getForegroundColor()) != null) {
            return tailForeground;
        }
        return defaultForeground;
    }

    public static Color getGrayedForeground(boolean isSelected) {
        return UIUtil.getContextHelpForeground();
    }

    private int setItemTextLabel(LookupElement item, Color foreground, LookupElementPresentation presentation, int allowedWidth) {
        boolean bold = presentation.isItemTextBold();
        Font customItemFont = this.myLookup.getCustomFont(item, bold);
        this.myNameComponent.setFont(customItemFont != null ? customItemFont : (bold ? this.myBoldFont : this.myNormalFont));
        int style = LookupCellRenderer.getStyle(bold, presentation.isStrikeout(), presentation.isItemTextUnderlined(), presentation.isItemTextItalic());
        FontMetrics metrics = this.getRealFontMetrics(item, bold);
        String name = this.trimLabelText(presentation.getItemText(), allowedWidth, metrics);
        int used = RealLookupElementPresentation.getStringWidth(name, metrics);
        this.renderItemName(item, foreground, style, name, this.myNameComponent);
        return used;
    }

    private FontMetrics getRealFontMetrics(LookupElement item, boolean bold) {
        Font customFont = this.myLookup.getCustomFont(item, bold);
        if (customFont != null) {
            return this.myLookup.getTopLevelEditor().getComponent().getFontMetrics(customFont);
        }
        return bold ? this.myBoldMetrics : this.myNormalMetrics;
    }

    @SimpleTextAttributes.StyleAttributeConstant
    private static int getStyle(boolean bold, boolean strikeout, boolean underlined, boolean italic) {
        int style;
        int n = style = bold ? 1 : 0;
        if (strikeout) {
            style |= 4;
        }
        if (underlined) {
            style |= 0x10;
        }
        if (italic) {
            style |= 2;
        }
        return style;
    }

    private void renderItemName(LookupElement item, Color foreground, @SimpleTextAttributes.StyleAttributeConstant int style, String name, SimpleColoredComponent nameComponent) {
        FList<TextRange> ranges2;
        String prefix;
        SimpleTextAttributes base = new SimpleTextAttributes(style, foreground);
        String string = prefix = item instanceof EmptyLookupItem ? "" : this.myLookup.itemPattern(item);
        if (prefix.length() > 0 && (ranges2 = LookupCellRenderer.getMatchingFragments(prefix, name)) != null) {
            SimpleTextAttributes highlighted = new SimpleTextAttributes(style, MATCHED_FOREGROUND_COLOR);
            SpeedSearchUtil.appendColoredFragments(nameComponent, name, ranges2, base, highlighted);
            return;
        }
        nameComponent.append(name, base);
    }

    public static FList<TextRange> getMatchingFragments(String prefix, String name) {
        return NameUtil.buildMatcher("*" + prefix).build().matchingFragments(name);
    }

    private int setTypeTextLabel(LookupElement item, Color background, Color foreground, LookupElementPresentation presentation, int allowedWidth, boolean selected2, boolean nonFocusedSelection, FontMetrics normalMetrics) {
        Object o;
        String givenText = presentation.getTypeText();
        String labelText = this.trimLabelText(StringUtil.isEmpty(givenText) ? "" : " " + givenText, allowedWidth, normalMetrics);
        int used = RealLookupElementPresentation.getStringWidth(labelText, normalMetrics);
        Icon icon2 = presentation.getTypeIcon();
        if (icon2 != null) {
            this.myTypeLabel.setIcon(icon2);
            used += icon2.getIconWidth();
        }
        Color sampleBackground = background;
        Object object = o = item.isValid() ? item.getObject() : null;
        if (o instanceof LookupValueWithUIHint && StringUtil.isEmpty(labelText)) {
            Color proposedBackground = ((LookupValueWithUIHint)o).getColorHint();
            if (proposedBackground != null) {
                sampleBackground = proposedBackground;
            }
            this.myTypeLabel.append("  ");
            used += normalMetrics.stringWidth("WW");
        } else {
            this.myTypeLabel.append(labelText);
        }
        this.myTypeLabel.setBackground(sampleBackground);
        this.myTypeLabel.setForeground(LookupCellRenderer.getTypeTextColor(item, foreground, presentation, selected2, nonFocusedSelection));
        this.myTypeLabel.setIconOnTheRight(presentation.isTypeIconRightAligned());
        return used;
    }

    @NotNull
    private static Icon removeVisibilityIfNeeded(@Nullable Editor editor, @NotNull Icon icon2, @NotNull Icon standard) {
        if (icon2 == null) {
            LookupCellRenderer.$$$reportNull$$$0(1);
        }
        if (standard == null) {
            LookupCellRenderer.$$$reportNull$$$0(2);
        }
        if (!Registry.is("ide.completion.show.visibility.icon")) {
            if (icon2 instanceof RowIcon) {
                Icon firstIcon;
                RowIcon rowIcon = (RowIcon)icon2;
                if (rowIcon.getIconCount() >= 1 && (firstIcon = rowIcon.getIcon(0)) != null) {
                    Icon icon3 = Registry.is("editor.scale.completion.icons") ? EditorUtil.scaleIconAccordingEditorFont(firstIcon, editor) : firstIcon;
                    if (icon3 == null) {
                        LookupCellRenderer.$$$reportNull$$$0(3);
                    }
                    return icon3;
                }
            } else if (icon2.getIconWidth() > standard.getIconWidth() || icon2.getIconHeight() > standard.getIconHeight()) {
                icon2 = IconUtil.cropIcon((Icon)icon2, (Rectangle)new Rectangle(standard.getIconWidth(), standard.getIconHeight()));
            }
        }
        Icon icon4 = icon2;
        if (icon4 == null) {
            LookupCellRenderer.$$$reportNull$$$0(4);
        }
        return icon4;
    }

    public static Icon augmentIcon(@Nullable Editor editor, @Nullable Icon icon2, @NotNull Icon standard) {
        if (standard == null) {
            LookupCellRenderer.$$$reportNull$$$0(5);
        }
        if (Registry.is("editor.scale.completion.icons")) {
            standard = EditorUtil.scaleIconAccordingEditorFont(standard, editor);
            icon2 = EditorUtil.scaleIconAccordingEditorFont(icon2, editor);
        }
        if (icon2 == null) {
            return standard;
        }
        if ((icon2 = LookupCellRenderer.removeVisibilityIfNeeded(editor, icon2, standard)).getIconHeight() < standard.getIconHeight() || icon2.getIconWidth() < standard.getIconWidth()) {
            LayeredIcon layeredIcon = new LayeredIcon(2);
            layeredIcon.setIcon(icon2, 0, 0, (standard.getIconHeight() - icon2.getIconHeight()) / 2);
            layeredIcon.setIcon(standard, 1);
            return layeredIcon;
        }
        return icon2;
    }

    @Nullable
    Font getFontAbleToDisplay(LookupElementPresentation p) {
        String sampleString = p.getItemText() + p.getTailText() + p.getTypeText();
        HashSet<Font> fonts = new HashSet<Font>();
        FontPreferences fontPreferences = this.myLookup.getFontPreferences();
        for (int i = 0; i < sampleString.length(); ++i) {
            fonts.add(ComplementaryFontsRegistry.getFontAbleToDisplay((int)sampleString.charAt(i), 0, fontPreferences, null).getFont());
        }
        block1: for (Font font : fonts) {
            if (font.equals(this.myNormalFont)) continue;
            for (int i = 0; i < sampleString.length(); ++i) {
                if (!font.canDisplay(sampleString.charAt(i))) continue block1;
            }
            return font;
        }
        return null;
    }

    int updateMaximumWidth(LookupElementPresentation p, LookupElement item) {
        Icon icon2 = p.getIcon();
        if (icon2 != null && (icon2.getIconWidth() > this.myEmptyIcon.getIconWidth() || icon2.getIconHeight() > this.myEmptyIcon.getIconHeight())) {
            if (icon2 instanceof DeferredIcon) {
                icon2 = ((DeferredIcon)icon2).getBaseIcon();
            }
            icon2 = LookupCellRenderer.removeVisibilityIfNeeded(this.myLookup.getEditor(), icon2, this.myEmptyIcon);
            this.myEmptyIcon = EmptyIcon.create(Math.max(icon2.getIconWidth(), this.myEmptyIcon.getIconWidth()), Math.max(icon2.getIconHeight(), this.myEmptyIcon.getIconHeight()));
            this.myNameComponent.setIpad(JBUI.insetsLeft(6));
        }
        return RealLookupElementPresentation.calculateWidth(p, this.getRealFontMetrics(item, false), this.getRealFontMetrics(item, true)) + LookupCellRenderer.calcSpacing(this.myTailComponent, null) + LookupCellRenderer.calcSpacing(this.myTypeLabel, null);
    }

    public int getTextIndent() {
        return this.myNameComponent.getIpad().left + this.myEmptyIcon.getIconWidth() + this.myNameComponent.getIconTextGap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standard";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/impl/LookupCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupCellRenderer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "removeVisibilityIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcSpacing";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeVisibilityIfNeeded";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "augmentIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LookupPanel
    extends JPanel {
        boolean myUpdateExtender;

        LookupPanel() {
            super(new BorderLayout());
        }

        public void setUpdateExtender(boolean updateExtender) {
            this.myUpdateExtender = updateExtender;
        }

        @Override
        public Dimension getPreferredSize() {
            return UIUtil.updateListRowHeight(super.getPreferredSize());
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (NON_FOCUSED_MASK_COLOR.getAlpha() > 0 && !LookupCellRenderer.this.myLookup.isFocused() && LookupCellRenderer.this.myLookup.isCompletion()) {
                g = g.create();
                try {
                    g.setColor(NON_FOCUSED_MASK_COLOR);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                finally {
                    g.dispose();
                }
            }
        }
    }

    private static class MySimpleColoredComponent
    extends SimpleColoredComponent {
        private MySimpleColoredComponent() {
            this.setFocusBorderAroundIcon(true);
        }
    }
}

