/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.actions.ChooseItemAction;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupTypedHandler
extends TypedActionHandlerBase {
    private static final Logger LOG = Logger.getInstance(LookupTypedHandler.class);

    public LookupTypedHandler(@Nullable TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    @Override
    public void execute(@NotNull Editor originalEditor, char charTyped, @NotNull DataContext dataContext) {
        Editor editor;
        Project project2;
        PsiFile file2;
        if (originalEditor == null) {
            LookupTypedHandler.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            LookupTypedHandler.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = file2 = (project2 = CommonDataKeys.PROJECT.getData(dataContext)) == null ? null : PsiUtilBase.getPsiFileInEditor(originalEditor, project2);
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(originalEditor, charTyped, dataContext);
            }
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed(originalEditor)) {
            return;
        }
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        if (oldPhase instanceof CompletionPhase.CommittingDocuments && oldPhase.indicator != null) {
            oldPhase.indicator.scheduleRestart();
        }
        if ((editor = TypedHandler.injectedEditorIfCharTypedIsSignificant(charTyped, originalEditor, file2)) != originalEditor) {
            file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
        }
        if (originalEditor.isInsertMode() && LookupTypedHandler.beforeCharTyped(charTyped, project2, originalEditor, editor, file2)) {
            return;
        }
        if (this.myOriginalHandler != null) {
            this.myOriginalHandler.execute(originalEditor, charTyped, dataContext);
        }
    }

    private static boolean beforeCharTyped(char charTyped, Project project2, Editor originalEditor, Editor editor, PsiFile file2) {
        LookupElement item;
        LookupImpl lookup2 = (LookupImpl)LookupManager.getActiveLookup(originalEditor);
        if (lookup2 == null) {
            return false;
        }
        if (charTyped == ' ' && ChooseItemAction.hasTemplatePrefix(lookup2, ' ')) {
            return false;
        }
        CharFilter.Result result2 = LookupTypedHandler.getLookupAction(charTyped, lookup2);
        if (lookup2.isLookupDisposed()) {
            return false;
        }
        if (result2 == CharFilter.Result.ADD_TO_PREFIX) {
            CompletionProgressIndicator completion;
            Document document = editor.getDocument();
            long modificationStamp = document.getModificationStamp();
            if (!lookup2.performGuardedChange(() -> {
                lookup2.fireBeforeAppendPrefix(charTyped);
                EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(originalEditor, String.valueOf(charTyped), true);
            })) {
                return true;
            }
            lookup2.appendPrefix(charTyped);
            if (lookup2.isStartCompletionWhenNothingMatches() && lookup2.getItems().isEmpty()) {
                completion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
                if (completion != null) {
                    completion.scheduleRestart();
                } else {
                    AutoPopupController.getInstance(editor.getProject()).scheduleAutoPopup(editor);
                }
            }
            originalEditor.getCaretModel().runForEachCaret(caret -> {
                DataContext context = DataManager.getInstance().getDataContext(originalEditor.getContentComponent());
                AutoHardWrapHandler.getInstance().wrapLineIfNecessary(originalEditor, context, modificationStamp);
            });
            completion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
            if (completion != null) {
                completion.prefixUpdated();
            }
            return true;
        }
        if (result2 == CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP && lookup2.isFocused() && (item = lookup2.getCurrentItem()) != null) {
            if (LookupTypedHandler.completeTillTypedCharOccurrence(charTyped, lookup2, item)) {
                return true;
            }
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByDotEtc");
            lookup2.finishLookupInWritableFile(charTyped, item);
            return true;
        }
        lookup2.hide();
        TypedHandler.autoPopupCompletion(editor, charTyped, project2, file2);
        return false;
    }

    private static boolean completeTillTypedCharOccurrence(char charTyped, LookupImpl lookup2, LookupElement item) {
        String oldPrefix;
        PrefixMatcher matcher = lookup2.itemMatcher(item);
        PrefixMatcher expanded = matcher.cloneWithPrefix((oldPrefix = matcher.getPrefix() + lookup2.getAdditionalPrefix()) + charTyped);
        if (expanded.prefixMatches(item)) {
            for (String s : item.getAllLookupStrings()) {
                if (!matcher.prefixMatches(s)) continue;
                int i = -1;
                while ((i = s.indexOf(charTyped, i + 1)) >= 0) {
                    String newPrefix = s.substring(0, i + 1);
                    if (!expanded.prefixMatches(newPrefix)) continue;
                    lookup2.replacePrefix(oldPrefix, newPrefix);
                    return true;
                }
            }
        }
        return false;
    }

    static CharFilter.Result getLookupAction(char charTyped, LookupImpl lookup2) {
        CharFilter.Result filtersDecision = LookupTypedHandler.getFilterDecision(charTyped, lookup2);
        if (filtersDecision != null) {
            return filtersDecision;
        }
        return CharFilter.Result.HIDE_LOOKUP;
    }

    @Nullable
    private static CharFilter.Result getFilterDecision(char charTyped, LookupImpl lookup2) {
        lookup2.checkValid();
        LookupElement item = lookup2.getCurrentItem();
        int prefixLength = item == null ? lookup2.getAdditionalPrefix().length() : lookup2.itemPattern(item).length();
        for (CharFilter extension : CharFilter.EP_NAME.getExtensionList()) {
            CharFilter.Result result2 = extension.acceptChar(charTyped, prefixLength, lookup2);
            if (result2 != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(extension + " of " + extension.getClass() + " returned " + (Object)((Object)result2));
                }
                return result2;
            }
            if (lookup2.isLookupDisposed()) {
                throw new AssertionError((Object)("Lookup disposed after " + extension));
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "originalEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/lookup/impl/LookupTypedHandler";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

