/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.codeInsight.navigation.actions.GotoTypeDeclarationAction;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public final class CtrlMouseHandler {
    private static final Logger LOG = Logger.getInstance(CtrlMouseHandler.class);
    private final Project myProject;
    private HighlightersSet myHighlighter;
    @JdkConstants.InputEventMask
    private int myStoredModifiers;
    private TooltipProvider myTooltipProvider;
    @Nullable
    private Point myPrevMouseLocation;
    private LightweightHint myHint;
    private final KeyListener myEditorKeyListener;
    private final VisibleAreaListener myVisibleAreaListener;
    private final EditorMouseListener myEditorMouseAdapter;
    private final EditorMouseMotionListener myEditorMouseMotionListener;

    public CtrlMouseHandler(@NotNull Project project2) {
        if (project2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(0);
        }
        this.myEditorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.handleKey(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.handleKey(e);
            }

            private void handleKey(KeyEvent e) {
                int modifiers = e.getModifiers();
                if (modifiers == CtrlMouseHandler.this.myStoredModifiers) {
                    return;
                }
                BrowseMode browseMode = CtrlMouseHandler.getBrowseMode(modifiers);
                if (browseMode == BrowseMode.None) {
                    CtrlMouseHandler.this.disposeHighlighter();
                    CtrlMouseHandler.this.cancelPreviousTooltip();
                } else {
                    TooltipProvider tooltipProvider = CtrlMouseHandler.this.myTooltipProvider;
                    if (tooltipProvider != null) {
                        if (browseMode != tooltipProvider.getBrowseMode()) {
                            CtrlMouseHandler.this.disposeHighlighter();
                        }
                        CtrlMouseHandler.this.myStoredModifiers = modifiers;
                        CtrlMouseHandler.this.cancelPreviousTooltip();
                        CtrlMouseHandler.this.myTooltipProvider = new TooltipProvider(tooltipProvider);
                        CtrlMouseHandler.this.myTooltipProvider.execute(browseMode);
                    }
                }
            }
        };
        this.myVisibleAreaListener = __ -> {
            this.disposeHighlighter();
            this.cancelPreviousTooltip();
        };
        this.myEditorMouseAdapter = new EditorMouseListener(){

            @Override
            public void mouseReleased(@NotNull EditorMouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CtrlMouseHandler.this.disposeHighlighter();
                CtrlMouseHandler.this.cancelPreviousTooltip();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/navigation/CtrlMouseHandler$2", "mouseReleased"));
            }
        };
        this.myEditorMouseMotionListener = new EditorMouseMotionListener(){

            @Override
            public void mouseMoved(@NotNull EditorMouseEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (e.isConsumed() || !CtrlMouseHandler.this.myProject.isInitialized() || CtrlMouseHandler.this.myProject.isDisposed()) {
                    return;
                }
                MouseEvent mouseEvent = e.getMouseEvent();
                Point prevLocation = CtrlMouseHandler.this.myPrevMouseLocation;
                CtrlMouseHandler.this.myPrevMouseLocation = mouseEvent.getLocationOnScreen();
                if (CtrlMouseHandler.this.isMouseOverTooltip(mouseEvent.getLocationOnScreen()) || ScreenUtil.isMovementTowards(prevLocation, mouseEvent.getLocationOnScreen(), CtrlMouseHandler.this.getHintBounds())) {
                    return;
                }
                CtrlMouseHandler.this.cancelPreviousTooltip();
                CtrlMouseHandler.this.myStoredModifiers = mouseEvent.getModifiers();
                BrowseMode browseMode = CtrlMouseHandler.getBrowseMode(CtrlMouseHandler.this.myStoredModifiers);
                if (browseMode == BrowseMode.None || e.getArea() != EditorMouseEventArea.EDITING_AREA) {
                    CtrlMouseHandler.this.disposeHighlighter();
                    return;
                }
                Editor editor = e.getEditor();
                if (!(editor instanceof EditorEx) || editor.getProject() != null && editor.getProject() != CtrlMouseHandler.this.myProject) {
                    return;
                }
                Point point = new Point(mouseEvent.getPoint());
                if (!EditorUtil.isPointOverText(editor, point)) {
                    CtrlMouseHandler.this.disposeHighlighter();
                    return;
                }
                CtrlMouseHandler.this.myTooltipProvider = new TooltipProvider((EditorEx)editor, editor.xyToLogicalPosition(point));
                CtrlMouseHandler.this.myTooltipProvider.execute(browseMode);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/navigation/CtrlMouseHandler$3", "mouseMoved"));
            }
        };
        this.myProject = project2;
        StartupManager.getInstance(project2).registerPostStartupDumbAwareActivity(() -> {
            EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            eventMulticaster.addEditorMouseListener(this.myEditorMouseAdapter, project2);
            eventMulticaster.addEditorMouseMotionListener(this.myEditorMouseMotionListener, project2);
            eventMulticaster.addCaretListener(new CaretListener(){

                @Override
                public void caretPositionChanged(@NotNull CaretEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (CtrlMouseHandler.this.myHint != null) {
                        DocumentationManager.getInstance(CtrlMouseHandler.this.myProject).updateToolwindowContext();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/navigation/CtrlMouseHandler$4", "caretPositionChanged"));
                }
            }, project2);
        });
        project2.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, new FileEditorManagerListener(){

            @Override
            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                CtrlMouseHandler.this.disposeHighlighter();
                CtrlMouseHandler.this.cancelPreviousTooltip();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/navigation/CtrlMouseHandler$5", "selectionChanged"));
            }
        });
    }

    private void cancelPreviousTooltip() {
        if (this.myTooltipProvider != null) {
            this.myTooltipProvider.dispose();
            this.myTooltipProvider = null;
        }
    }

    private boolean isMouseOverTooltip(@NotNull Point mouseLocationOnScreen) {
        Rectangle bounds2;
        if (mouseLocationOnScreen == null) {
            CtrlMouseHandler.$$$reportNull$$$0(1);
        }
        return (bounds2 = this.getHintBounds()) != null && bounds2.contains(mouseLocationOnScreen);
    }

    @Nullable
    private Rectangle getHintBounds() {
        LightweightHint hint = this.myHint;
        if (hint == null) {
            return null;
        }
        JComponent hintComponent = hint.getComponent();
        if (!hintComponent.isShowing()) {
            return null;
        }
        return new Rectangle(hintComponent.getLocationOnScreen(), hintComponent.getSize());
    }

    @NotNull
    private static BrowseMode getBrowseMode(@JdkConstants.InputEventMask int modifiers) {
        if (modifiers != 0) {
            Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
            if (KeymapUtil.matchActionMouseShortcutsModifiers(activeKeymap, modifiers, "GotoDeclaration")) {
                BrowseMode browseMode = BrowseMode.Declaration;
                if (browseMode == null) {
                    CtrlMouseHandler.$$$reportNull$$$0(2);
                }
                return browseMode;
            }
            if (KeymapUtil.matchActionMouseShortcutsModifiers(activeKeymap, modifiers, "GotoTypeDeclaration")) {
                BrowseMode browseMode = BrowseMode.TypeDeclaration;
                if (browseMode == null) {
                    CtrlMouseHandler.$$$reportNull$$$0(3);
                }
                return browseMode;
            }
            if (KeymapUtil.matchActionMouseShortcutsModifiers(activeKeymap, modifiers, "GotoImplementation")) {
                BrowseMode browseMode = BrowseMode.Implementation;
                if (browseMode == null) {
                    CtrlMouseHandler.$$$reportNull$$$0(4);
                }
                return browseMode;
            }
        }
        BrowseMode browseMode = BrowseMode.None;
        if (browseMode == null) {
            CtrlMouseHandler.$$$reportNull$$$0(5);
        }
        return browseMode;
    }

    @Nullable
    public static String getInfo(PsiElement element2, PsiElement atPointer) {
        return CtrlMouseHandler.generateInfo((PsiElement)element2, (PsiElement)atPointer, (boolean)true).text;
    }

    @Nullable
    public static String getInfo(@NotNull Editor editor, BrowseMode browseMode) {
        Project project2;
        if (editor == null) {
            CtrlMouseHandler.$$$reportNull$$$0(6);
        }
        if ((project2 = editor.getProject()) == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        Info info = CtrlMouseHandler.getInfoAt(project2, editor, file2, editor.getCaretModel().getOffset(), browseMode);
        return info == null ? null : info.getInfo().text;
    }

    @NotNull
    private static DocInfo generateInfo(PsiElement element2, PsiElement atPointer, boolean fallbackToBasicInfo) {
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(element2, atPointer);
        String result2 = documentationProvider.getQuickNavigateInfo(element2, atPointer);
        if (result2 == null && fallbackToBasicInfo) {
            result2 = CtrlMouseHandler.doGenerateInfo(element2);
        }
        return result2 == null ? DocInfo.EMPTY : new DocInfo(result2, documentationProvider);
    }

    @Nullable
    private static String doGenerateInfo(@NotNull PsiElement element2) {
        ItemPresentation presentation;
        VirtualFile virtualFile2;
        if (element2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(7);
        }
        if (element2 instanceof PsiFile && (virtualFile2 = ((PsiFile)element2).getVirtualFile()) != null) {
            return virtualFile2.getPresentableUrl();
        }
        String info = CtrlMouseHandler.getQuickNavigateInfo(element2);
        if (info != null) {
            return info;
        }
        if (element2 instanceof NavigationItem && (presentation = ((NavigationItem)((Object)element2)).getPresentation()) != null) {
            return presentation.getPresentableText();
        }
        return null;
    }

    @Nullable
    private static String getQuickNavigateInfo(PsiElement element2) {
        String name = ElementDescriptionUtil.getElementDescription(element2, UsageViewShortNameLocation.INSTANCE);
        if (StringUtil.isEmpty(name)) {
            return null;
        }
        String typeName = ElementDescriptionUtil.getElementDescription(element2, UsageViewTypeLocation.INSTANCE);
        PsiFile file2 = element2.getContainingFile();
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isNotEmpty(typeName)) {
            sb.append(typeName).append(" ");
        }
        sb.append("\"").append(name).append("\"");
        if (file2 != null && file2.isPhysical()) {
            sb.append(" [").append(file2.getName()).append("]");
        }
        return sb.toString();
    }

    private static void showDumbModeNotification(@NotNull Project project2) {
        if (project2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(8);
        }
        DumbService.getInstance(project2).showDumbModeNotification(CodeInsightBundle.message("notification.element.information.is.not.available.during.index.update", new Object[0]));
    }

    @Nullable
    private Info getInfoAt(@NotNull Editor editor, @NotNull PsiFile file2, int offset, @NotNull BrowseMode browseMode) {
        if (editor == null) {
            CtrlMouseHandler.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(10);
        }
        if (browseMode == null) {
            CtrlMouseHandler.$$$reportNull$$$0(11);
        }
        return CtrlMouseHandler.getInfoAt(this.myProject, editor, file2, offset, browseMode);
    }

    @Nullable
    public static Info getInfoAt(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2, int offset, @NotNull BrowseMode browseMode) {
        PsiElement identifier;
        PsiElement elementAtPointer;
        PsiElement element2;
        if (project2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            CtrlMouseHandler.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(14);
        }
        if (browseMode == null) {
            CtrlMouseHandler.$$$reportNull$$$0(15);
        }
        PsiElement targetElement = null;
        if (browseMode == BrowseMode.TypeDeclaration) {
            try {
                targetElement = GotoTypeDeclarationAction.findSymbolType(editor, offset);
            }
            catch (IndexNotReadyException e) {
                CtrlMouseHandler.showDumbModeNotification(project2);
            }
        } else if (browseMode == BrowseMode.Declaration) {
            PsiReference ref = TargetElementUtil.findReference(editor, offset);
            List<Object> resolvedElements = ref == null ? Collections.emptyList() : CtrlMouseHandler.resolve(ref);
            PsiElement resolvedElement = resolvedElements.size() == 1 ? (PsiElement)resolvedElements.get(0) : null;
            PsiElement[] targetElements = GotoDeclarationAction.findTargetElementsNoVS(project2, editor, offset, false);
            PsiElement elementAtPointer2 = file2.findElementAt(TargetElementUtil.adjustOffset(file2, editor.getDocument(), offset));
            if (targetElements != null) {
                if (targetElements.length == 0) {
                    return null;
                }
                if (targetElements.length == 1) {
                    if (targetElements[0] != resolvedElement && elementAtPointer2 != null && targetElements[0].isPhysical()) {
                        return ref != null ? new InfoSingle(ref, targetElements[0]) : new InfoSingle(elementAtPointer2, targetElements[0]);
                    }
                } else {
                    return elementAtPointer2 != null ? new InfoMultiple(elementAtPointer2) : null;
                }
            }
            if (resolvedElements.size() == 1) {
                return new InfoSingle(ref, (PsiElement)resolvedElements.get(0));
            }
            if (resolvedElements.size() > 1) {
                return elementAtPointer2 != null ? new InfoMultiple(elementAtPointer2, ref) : null;
            }
        } else if (browseMode == BrowseMode.Implementation) {
            element2 = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
            PsiElement[] targetElements = new ImplementationSearcher(){

                @Override
                protected PsiElement @NotNull [] searchDefinitions(PsiElement element2, Editor editor) {
                    ArrayList found2 = new ArrayList(2);
                    DefinitionsScopedSearch.search(element2, 6.getSearchScope(element2, editor)).forEach(psiElement -> {
                        found2.add(psiElement);
                        return found2.size() != 2;
                    });
                    PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(found2);
                    if (psiElementArray == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    return psiElementArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/CtrlMouseHandler$6", "searchDefinitions"));
                }
            }.searchImplementations(editor, element2, offset);
            if (targetElements == null) {
                return null;
            }
            if (targetElements.length > 1) {
                PsiElement elementAtPointer3 = file2.findElementAt(offset);
                if (elementAtPointer3 != null) {
                    return new InfoMultiple(elementAtPointer3);
                }
                return null;
            }
            if (targetElements.length == 1) {
                Navigatable descriptor2 = EditSourceUtil.getDescriptor(targetElements[0]);
                if (descriptor2 == null || !descriptor2.canNavigate()) {
                    return null;
                }
                targetElement = targetElements[0];
            }
        }
        if (targetElement != null && targetElement.isPhysical() && (elementAtPointer = file2.findElementAt(offset)) != null) {
            return new InfoSingle(elementAtPointer, targetElement);
        }
        element2 = GotoDeclarationAction.findElementToShowUsagesOf(editor, offset);
        if (element2 instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)element2).getNameIdentifier()) != null && identifier.isValid()) {
            return new Info(identifier){

                @Override
                @NotNull
                public DocInfo getInfo() {
                    String name = UsageViewUtil.getType(element2) + " '" + UsageViewUtil.getShortName(element2) + "'";
                    return new DocInfo("Show usages of " + name, null);
                }

                @Override
                public boolean isValid(@NotNull Document document) {
                    if (document == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return element2.isValid();
                }

                @Override
                public boolean isNavigatable() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/navigation/CtrlMouseHandler$7", "isValid"));
                }
            };
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> resolve(@NotNull PsiReference ref) {
        PsiElement resolvedElement;
        if (ref == null) {
            CtrlMouseHandler.$$$reportNull$$$0(16);
        }
        if ((resolvedElement = ref.resolve()) == null && ref instanceof PsiPolyVariantReference) {
            ResolveResult[] psiElements;
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
            for (ResolveResult resolveResult : psiElements = ((PsiPolyVariantReference)ref).multiResolve(false)) {
                if (resolveResult.getElement() == null) continue;
                result2.add(resolveResult.getElement());
            }
            ArrayList<PsiElement> arrayList = result2;
            if (arrayList == null) {
                CtrlMouseHandler.$$$reportNull$$$0(17);
            }
            return arrayList;
        }
        List<Object> list2 = resolvedElement == null ? Collections.emptyList() : Collections.singletonList(resolvedElement);
        if (list2 == null) {
            CtrlMouseHandler.$$$reportNull$$$0(18);
        }
        return list2;
    }

    private void disposeHighlighter() {
        HighlightersSet highlighter = this.myHighlighter;
        if (highlighter != null) {
            this.myHighlighter = null;
            highlighter.uninstall();
            HintManager.getInstance().hideAllHints();
        }
    }

    private void updateText(@NotNull String updatedText, @NotNull Consumer<? super String> newTextConsumer, @NotNull LightweightHint hint, @NotNull Editor editor) {
        if (updatedText == null) {
            CtrlMouseHandler.$$$reportNull$$$0(19);
        }
        if (newTextConsumer == null) {
            CtrlMouseHandler.$$$reportNull$$$0(20);
        }
        if (hint == null) {
            CtrlMouseHandler.$$$reportNull$$$0(21);
        }
        if (editor == null) {
            CtrlMouseHandler.$$$reportNull$$$0(22);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            JComponent component2 = hint.getComponent();
            Dimension oldSize = component2.getPreferredSize();
            newTextConsumer.consume(updatedText);
            Dimension newSize = component2.getPreferredSize();
            if (newSize.width == oldSize.width) {
                return;
            }
            component2.setPreferredSize(new Dimension(newSize.width, newSize.height));
            if (hint.isRealPopup()) {
                TooltipProvider tooltipProvider = this.myTooltipProvider;
                if (tooltipProvider != null) {
                    hint.hide();
                    tooltipProvider.showHint(new LightweightHint(component2), editor);
                } else {
                    component2.setPreferredSize(new Dimension(newSize.width, oldSize.height));
                    hint.pack();
                }
                return;
            }
            Container topLevelLayeredPaneChild = null;
            boolean adjustBounds = false;
            for (Container current2 = component2.getParent(); current2 != null; current2 = current2.getParent()) {
                if (current2 instanceof JLayeredPane) {
                    adjustBounds = true;
                    break;
                }
                topLevelLayeredPaneChild = current2;
            }
            if (adjustBounds && topLevelLayeredPaneChild != null) {
                Rectangle bounds2 = topLevelLayeredPaneChild.getBounds();
                topLevelLayeredPaneChild.setBounds(bounds2.x, bounds2.y, bounds2.width + newSize.width - oldSize.width, bounds2.height);
            }
        });
    }

    @NotNull
    private HighlightersSet installHighlighterSet(@NotNull Info info, @NotNull EditorEx editor, boolean highlighterOnly) {
        if (info == null) {
            CtrlMouseHandler.$$$reportNull$$$0(23);
        }
        if (editor == null) {
            CtrlMouseHandler.$$$reportNull$$$0(24);
        }
        editor.getContentComponent().addKeyListener(this.myEditorKeyListener);
        editor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        if (info.isNavigatable()) {
            editor.setCustomCursor(CtrlMouseHandler.class, Cursor.getPredefinedCursor(12));
        }
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        if (!highlighterOnly || info.isNavigatable()) {
            TextAttributes attributes = info.isNavigatable() ? EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR) : new TextAttributes(null, HintUtil.getInformationColor(), null, null, 0);
            for (TextRange range2 : info.getRanges()) {
                TextAttributes attr = NavigationUtil.patchAttributesColor(attributes, range2, editor);
                RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(range2.getStartOffset(), range2.getEndOffset(), 5900, attr, HighlighterTargetArea.EXACT_RANGE);
                highlighters.add(highlighter);
            }
        }
        return new HighlightersSet(highlighters, editor, info);
    }

    public boolean isCalculationInProgress() {
        TooltipProvider provider = this.myTooltipProvider;
        if (provider == null) {
            return false;
        }
        CancellablePromise progress2 = provider.myExecutionProgress;
        if (progress2 == null) {
            return false;
        }
        return !progress2.isDone();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseLocationOnScreen";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browseMode";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedText";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTextConsumer";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowseMode";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMouseOverTooltip";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateInfo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showDumbModeNotification";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInfoAt";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "installHighlighterSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class QuickDocHyperlinkListener
    implements HyperlinkListener {
        @NotNull
        private final DocumentationProvider myProvider;
        @NotNull
        private final PsiElement myContext;

        QuickDocHyperlinkListener(@NotNull DocumentationProvider provider, PsiElement context) {
            if (provider == null) {
                QuickDocHyperlinkListener.$$$reportNull$$$0(0);
            }
            if (context == null) {
                QuickDocHyperlinkListener.$$$reportNull$$$0(1);
            }
            this.myProvider = provider;
            this.myContext = context;
        }

        @Override
        public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
            if (e == null) {
                QuickDocHyperlinkListener.$$$reportNull$$$0(2);
            }
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String description = e.getDescription();
            if (StringUtil.isEmpty(description) || !description.startsWith("psi_element://")) {
                return;
            }
            String elementName = e.getDescription().substring("psi_element://".length());
            DumbService.getInstance(CtrlMouseHandler.this.myProject).withAlternativeResolveEnabled(() -> {
                PsiElement targetElement = this.myProvider.getDocumentationElementForLink(PsiManager.getInstance(CtrlMouseHandler.this.myProject), elementName, this.myContext);
                if (targetElement != null) {
                    LightweightHint hint = CtrlMouseHandler.this.myHint;
                    if (hint != null) {
                        hint.hide(true);
                    }
                    DocumentationManager.getInstance(CtrlMouseHandler.this.myProject).showJavaDocInfo(targetElement, this.myContext, null);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$QuickDocHyperlinkListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class DocInfo {
        public static final DocInfo EMPTY = new DocInfo(null, null);
        @Nullable
        public final String text;
        @Nullable
        final DocumentationProvider docProvider;

        DocInfo(@Nullable String text2, @Nullable DocumentationProvider provider) {
            this.text = text2;
            this.docProvider = provider;
        }
    }

    private final class HighlightersSet {
        @NotNull
        private final List<? extends RangeHighlighter> myHighlighters;
        @NotNull
        private final EditorEx myHighlighterView;
        @NotNull
        private final Info myStoredInfo;

        private HighlightersSet(@NotNull List<? extends RangeHighlighter> highlighters, @NotNull EditorEx highlighterView, Info storedInfo) {
            if (highlighters == null) {
                HighlightersSet.$$$reportNull$$$0(0);
            }
            if (highlighterView == null) {
                HighlightersSet.$$$reportNull$$$0(1);
            }
            if (storedInfo == null) {
                HighlightersSet.$$$reportNull$$$0(2);
            }
            this.myHighlighters = highlighters;
            this.myHighlighterView = highlighterView;
            this.myStoredInfo = storedInfo;
        }

        public void uninstall() {
            for (RangeHighlighter rangeHighlighter : this.myHighlighters) {
                rangeHighlighter.dispose();
            }
            this.myHighlighterView.setCustomCursor(CtrlMouseHandler.class, null);
            this.myHighlighterView.getContentComponent().removeKeyListener(CtrlMouseHandler.this.myEditorKeyListener);
            this.myHighlighterView.getScrollingModel().removeVisibleAreaListener(CtrlMouseHandler.this.myVisibleAreaListener);
        }

        @NotNull
        Info getStoredInfo() {
            Info info = this.myStoredInfo;
            if (info == null) {
                HighlightersSet.$$$reportNull$$$0(3);
            }
            return info;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighterView";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storedInfo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$HighlightersSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$HighlightersSet";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStoredInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class TooltipProvider {
        @NotNull
        private final EditorEx myHostEditor;
        private final int myHostOffset;
        private BrowseMode myBrowseMode;
        private boolean myDisposed;
        private CancellablePromise<?> myExecutionProgress;

        TooltipProvider(@NotNull EditorEx hostEditor, LogicalPosition hostPos) {
            if (hostEditor == null) {
                TooltipProvider.$$$reportNull$$$0(0);
            }
            if (hostPos == null) {
                TooltipProvider.$$$reportNull$$$0(1);
            }
            this.myHostEditor = hostEditor;
            this.myHostOffset = hostEditor.logicalPositionToOffset(hostPos);
        }

        TooltipProvider(TooltipProvider source) {
            if (source == null) {
                TooltipProvider.$$$reportNull$$$0(2);
            }
            this.myHostEditor = source.myHostEditor;
            this.myHostOffset = source.myHostOffset;
        }

        void dispose() {
            this.myDisposed = true;
            if (this.myExecutionProgress != null) {
                this.myExecutionProgress.cancel();
            }
        }

        BrowseMode getBrowseMode() {
            return this.myBrowseMode;
        }

        void execute(@NotNull BrowseMode browseMode) {
            if (browseMode == null) {
                TooltipProvider.$$$reportNull$$$0(3);
            }
            this.myBrowseMode = browseMode;
            if (PsiDocumentManager.getInstance(CtrlMouseHandler.this.myProject).getPsiFile(this.myHostEditor.getDocument()) == null) {
                return;
            }
            int selStart = this.myHostEditor.getSelectionModel().getSelectionStart();
            int selEnd = this.myHostEditor.getSelectionModel().getSelectionEnd();
            if (this.myHostOffset >= selStart && this.myHostOffset < selEnd) {
                CtrlMouseHandler.this.disposeHighlighter();
                return;
            }
            this.myExecutionProgress = ReadAction.nonBlocking(() -> this.doExecute()).withDocumentsCommitted(CtrlMouseHandler.this.myProject).expireWhen(() -> this.isTaskOutdated(this.myHostEditor)).finishOnUiThread(ModalityState.defaultModalityState(), Runnable::run).submit(AppExecutorUtil.getAppExecutorService());
        }

        private Runnable createDisposalContinuation() {
            return () -> CtrlMouseHandler.this.disposeHighlighter();
        }

        @NotNull
        private Runnable doExecute() {
            Info info;
            EditorEx editor;
            block8: {
                Runnable runnable2;
                editor = this.getPossiblyInjectedEditor();
                int offset = this.getOffset(editor);
                PsiFile file2 = PsiDocumentManager.getInstance(CtrlMouseHandler.this.myProject).getPsiFile(editor.getDocument());
                if (file2 == null) {
                    Runnable runnable3 = this.createDisposalContinuation();
                    if (runnable3 == null) {
                        TooltipProvider.$$$reportNull$$$0(4);
                    }
                    return runnable3;
                }
                try {
                    info = CtrlMouseHandler.this.getInfoAt(editor, file2, offset, this.myBrowseMode);
                    if (info != null) break block8;
                    runnable2 = this.createDisposalContinuation();
                }
                catch (IndexNotReadyException e) {
                    CtrlMouseHandler.showDumbModeNotification(CtrlMouseHandler.this.myProject);
                    Runnable runnable4 = this.createDisposalContinuation();
                    if (runnable4 == null) {
                        TooltipProvider.$$$reportNull$$$0(6);
                    }
                    return runnable4;
                }
                if (runnable2 == null) {
                    TooltipProvider.$$$reportNull$$$0(5);
                }
                return runnable2;
            }
            DocInfo docInfo = info.getInfo();
            LOG.debug("Obtained info about element under cursor");
            Runnable runnable5 = () -> this.addHighlighterAndShowHint(info, docInfo, editor);
            if (runnable5 == null) {
                TooltipProvider.$$$reportNull$$$0(7);
            }
            return runnable5;
        }

        @NotNull
        private EditorEx getPossiblyInjectedEditor() {
            DocumentEx document = this.myHostEditor.getDocument();
            if (PsiDocumentManager.getInstance(CtrlMouseHandler.this.myProject).isCommitted(document)) {
                PsiFile psiFile = PsiDocumentManager.getInstance(CtrlMouseHandler.this.myProject).getPsiFile(document);
                EditorEx editorEx = (EditorEx)InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)this.myHostEditor, psiFile, this.myHostOffset);
                if (editorEx == null) {
                    TooltipProvider.$$$reportNull$$$0(8);
                }
                return editorEx;
            }
            EditorEx editorEx = this.myHostEditor;
            if (editorEx == null) {
                TooltipProvider.$$$reportNull$$$0(9);
            }
            return editorEx;
        }

        private boolean isTaskOutdated(@NotNull Editor editor) {
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(10);
            }
            return this.myDisposed || CtrlMouseHandler.this.myProject.isDisposed() || editor.isDisposed() || !ApplicationManager.getApplication().isUnitTestMode() && !editor.getComponent().isShowing();
        }

        private int getOffset(@NotNull Editor editor) {
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(11);
            }
            return editor instanceof EditorWindow ? ((EditorWindow)editor).getDocument().hostToInjected(this.myHostOffset) : this.myHostOffset;
        }

        private void addHighlighterAndShowHint(@NotNull Info info, @NotNull DocInfo docInfo, @NotNull EditorEx editor) {
            if (info == null) {
                TooltipProvider.$$$reportNull$$$0(12);
            }
            if (docInfo == null) {
                TooltipProvider.$$$reportNull$$$0(13);
            }
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(14);
            }
            if (this.myDisposed || editor.isDisposed()) {
                return;
            }
            if (CtrlMouseHandler.this.myHighlighter != null) {
                if (!info.isSimilarTo(CtrlMouseHandler.this.myHighlighter.getStoredInfo())) {
                    CtrlMouseHandler.this.disposeHighlighter();
                } else {
                    if (info.isNavigatable()) {
                        editor.setCustomCursor(CtrlMouseHandler.class, Cursor.getPredefinedCursor(12));
                    }
                    return;
                }
            }
            if (!info.isValid(editor.getDocument()) || !info.isNavigatable() && docInfo.text == null) {
                return;
            }
            boolean highlighterOnly = EditorSettingsExternalizable.getInstance().isShowQuickDocOnMouseOverElement() && DocumentationManager.getInstance(CtrlMouseHandler.this.myProject).getDocInfoHint() != null;
            CtrlMouseHandler.this.myHighlighter = CtrlMouseHandler.this.installHighlighterSet(info, editor, highlighterOnly);
            if (highlighterOnly || docInfo.text == null) {
                return;
            }
            QuickDocHyperlinkListener hyperlinkListener = docInfo.docProvider == null ? null : new QuickDocHyperlinkListener(docInfo.docProvider, info.myElementAtPointer);
            Ref newTextConsumerRef = new Ref();
            JComponent component2 = HintUtil.createInformationLabel(docInfo.text, hyperlinkListener, null, newTextConsumerRef);
            component2.setBorder(JBUI.Borders.empty(6, 6, 5, 6));
            LightweightHint hint = new LightweightHint(this.wrapInScrollPaneIfNeeded(component2, editor));
            CtrlMouseHandler.this.myHint = hint;
            hint.addHintListener(__ -> CtrlMouseHandler.this.myHint = null);
            this.showHint(hint, editor);
            Consumer newTextConsumer = (Consumer)newTextConsumerRef.get();
            if (newTextConsumer != null) {
                this.updateOnPsiChanges(hint, info, newTextConsumer, docInfo.text, editor);
            }
        }

        @NotNull
        private JComponent wrapInScrollPaneIfNeeded(@NotNull JComponent component2, @NotNull Editor editor) {
            if (component2 == null) {
                TooltipProvider.$$$reportNull$$$0(15);
            }
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(16);
            }
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                Dimension preferredSize = component2.getPreferredSize();
                Dimension maxSize2 = this.getMaxPopupSize(editor);
                if (preferredSize.width > maxSize2.width || preferredSize.height > maxSize2.height) {
                    JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)component2, true);
                    scrollPane.setPreferredSize(new Dimension(Math.min(preferredSize.width, maxSize2.width), Math.min(preferredSize.height, maxSize2.height)));
                    JScrollPane jScrollPane = scrollPane;
                    if (jScrollPane == null) {
                        TooltipProvider.$$$reportNull$$$0(17);
                    }
                    return jScrollPane;
                }
            }
            JComponent jComponent = component2;
            if (jComponent == null) {
                TooltipProvider.$$$reportNull$$$0(18);
            }
            return jComponent;
        }

        @NotNull
        private Dimension getMaxPopupSize(@NotNull Editor editor) {
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(19);
            }
            Rectangle rectangle = ScreenUtil.getScreenRectangle(editor.getContentComponent());
            return new Dimension((int)(0.9 * (double)Math.max(640, rectangle.width)), (int)(0.33 * (double)Math.max(480, rectangle.height)));
        }

        private void updateOnPsiChanges(@NotNull LightweightHint hint, @NotNull Info info, @NotNull Consumer<? super String> textConsumer, @NotNull String oldText, @NotNull Editor editor) {
            if (hint == null) {
                TooltipProvider.$$$reportNull$$$0(20);
            }
            if (info == null) {
                TooltipProvider.$$$reportNull$$$0(21);
            }
            if (textConsumer == null) {
                TooltipProvider.$$$reportNull$$$0(22);
            }
            if (oldText == null) {
                TooltipProvider.$$$reportNull$$$0(23);
            }
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(24);
            }
            if (!hint.isVisible()) {
                return;
            }
            Disposable hintDisposable = Disposer.newDisposable("CtrlMouseHandler.TooltipProvider.updateOnPsiChanges");
            hint.addHintListener(__ -> Disposer.dispose(hintDisposable));
            CtrlMouseHandler.this.myProject.getMessageBus().connect(hintDisposable).subscribe(PsiModificationTracker.TOPIC, () -> ReadAction.nonBlocking(() -> {
                try {
                    DocInfo newDocInfo = info.getInfo();
                    return () -> {
                        if (newDocInfo.text != null && !oldText.equals(newDocInfo.text)) {
                            CtrlMouseHandler.this.updateText(newDocInfo.text, textConsumer, hint, editor);
                        }
                    };
                }
                catch (IndexNotReadyException e) {
                    CtrlMouseHandler.showDumbModeNotification(CtrlMouseHandler.this.myProject);
                    return this.createDisposalContinuation();
                }
            }).finishOnUiThread(ModalityState.defaultModalityState(), Runnable::run).withDocumentsCommitted(CtrlMouseHandler.this.myProject).expireWith(hintDisposable).expireWhen(() -> !info.isValid(editor.getDocument())).coalesceBy(CtrlMouseHandler.class, hint).submit(AppExecutorUtil.getAppExecutorService()));
        }

        public void showHint(@NotNull LightweightHint hint, @NotNull Editor editor) {
            if (hint == null) {
                TooltipProvider.$$$reportNull$$$0(25);
            }
            if (editor == null) {
                TooltipProvider.$$$reportNull$$$0(26);
            }
            if (ApplicationManager.getApplication().isUnitTestMode() || editor.isDisposed()) {
                return;
            }
            HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
            short constraint = 1;
            LogicalPosition position = editor.offsetToLogicalPosition(this.getOffset(editor));
            Point p = HintManagerImpl.getHintPosition(hint, editor, position, constraint);
            if (p.y - hint.getComponent().getPreferredSize().height < 0) {
                constraint = 2;
                p = HintManagerImpl.getHintPosition(hint, editor, position, constraint);
            }
            hintManager.showEditorHint(hint, editor, p, 42, 0, false, HintManagerImpl.createHintHint(editor, p, hint, constraint).setContentActive(false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 17: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 17: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hostEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hostPos";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "browseMode";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$TooltipProvider";
                    break;
                }
                case 10: 
                case 11: 
                case 14: 
                case 16: 
                case 19: 
                case 24: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 12: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docInfo";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 20: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hint";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textConsumer";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$TooltipProvider";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doExecute";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPossiblyInjectedEditor";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrapInScrollPaneIfNeeded";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 17: 
                case 18: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isTaskOutdated";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getOffset";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "addHighlighterAndShowHint";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapInScrollPaneIfNeeded";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getMaxPopupSize";
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "updateOnPsiChanges";
                    break;
                }
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "showHint";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 17: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InfoMultiple
    extends Info {
        InfoMultiple(@NotNull PsiElement elementAtPointer) {
            if (elementAtPointer == null) {
                InfoMultiple.$$$reportNull$$$0(0);
            }
            super(elementAtPointer);
        }

        InfoMultiple(@NotNull PsiElement elementAtPointer, @NotNull PsiReference ref) {
            if (elementAtPointer == null) {
                InfoMultiple.$$$reportNull$$$0(1);
            }
            if (ref == null) {
                InfoMultiple.$$$reportNull$$$0(2);
            }
            super(elementAtPointer, ReferenceRange.getAbsoluteRanges(ref));
        }

        @Override
        @NotNull
        public DocInfo getInfo() {
            return new DocInfo(CodeInsightBundle.message("multiple.implementations.tooltip", new Object[0]), null);
        }

        @Override
        public boolean isValid(@NotNull Document document) {
            if (document == null) {
                InfoMultiple.$$$reportNull$$$0(3);
            }
            return this.rangesAreCorrect(document);
        }

        @Override
        public boolean isNavigatable() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementAtPointer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$InfoMultiple";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isValid";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InfoSingle
    extends Info {
        @NotNull
        private final PsiElement myTargetElement;

        InfoSingle(@NotNull PsiElement elementAtPointer, @NotNull PsiElement targetElement) {
            if (elementAtPointer == null) {
                InfoSingle.$$$reportNull$$$0(0);
            }
            if (targetElement == null) {
                InfoSingle.$$$reportNull$$$0(1);
            }
            super(elementAtPointer);
            this.myTargetElement = targetElement;
        }

        InfoSingle(@NotNull PsiReference ref, @NotNull PsiElement targetElement) {
            if (ref == null) {
                InfoSingle.$$$reportNull$$$0(2);
            }
            if (targetElement == null) {
                InfoSingle.$$$reportNull$$$0(3);
            }
            super(ref.getElement(), ReferenceRange.getAbsoluteRanges(ref));
            this.myTargetElement = targetElement;
        }

        @Override
        @NotNull
        public DocInfo getInfo() {
            DocInfo docInfo = this.areElementsValid() ? CtrlMouseHandler.generateInfo(this.myTargetElement, this.myElementAtPointer, this.isNavigatable()) : DocInfo.EMPTY;
            if (docInfo == null) {
                InfoSingle.$$$reportNull$$$0(4);
            }
            return docInfo;
        }

        private boolean areElementsValid() {
            return this.myTargetElement.isValid() && this.myElementAtPointer.isValid();
        }

        @Override
        public boolean isValid(@NotNull Document document) {
            if (document == null) {
                InfoSingle.$$$reportNull$$$0(5);
            }
            return this.areElementsValid() && this.rangesAreCorrect(document);
        }

        @Override
        public boolean isNavigatable() {
            return this.myTargetElement != this.myElementAtPointer && this.myTargetElement != this.myElementAtPointer.getParent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementAtPointer";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$InfoSingle";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$InfoSingle";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isValid";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class Info {
        @NotNull
        final PsiElement myElementAtPointer;
        @NotNull
        private final List<TextRange> myRanges;

        public Info(@NotNull PsiElement elementAtPointer, @NotNull List<TextRange> ranges2) {
            if (elementAtPointer == null) {
                Info.$$$reportNull$$$0(0);
            }
            if (ranges2 == null) {
                Info.$$$reportNull$$$0(1);
            }
            this.myElementAtPointer = elementAtPointer;
            this.myRanges = ranges2;
        }

        public Info(@NotNull PsiElement elementAtPointer) {
            if (elementAtPointer == null) {
                Info.$$$reportNull$$$0(2);
            }
            this(elementAtPointer, Info.getReferenceRanges(elementAtPointer));
        }

        @NotNull
        private static List<TextRange> getReferenceRanges(@NotNull PsiElement elementAtPointer) {
            if (elementAtPointer == null) {
                Info.$$$reportNull$$$0(3);
            }
            if (!elementAtPointer.isPhysical()) {
                List<TextRange> list2 = Collections.emptyList();
                if (list2 == null) {
                    Info.$$$reportNull$$$0(4);
                }
                return list2;
            }
            int textOffset = elementAtPointer.getTextOffset();
            TextRange range2 = elementAtPointer.getTextRange();
            if (range2 == null) {
                throw new AssertionError((Object)("Null range for " + elementAtPointer + " of " + elementAtPointer.getClass()));
            }
            if (textOffset < range2.getStartOffset() || textOffset < 0) {
                LOG.error("Invalid text offset " + textOffset + " of element " + elementAtPointer + " of " + elementAtPointer.getClass());
                textOffset = range2.getStartOffset();
            }
            List<TextRange> list3 = Collections.singletonList(new TextRange(textOffset, range2.getEndOffset()));
            if (list3 == null) {
                Info.$$$reportNull$$$0(5);
            }
            return list3;
        }

        boolean isSimilarTo(@NotNull Info that) {
            if (that == null) {
                Info.$$$reportNull$$$0(6);
            }
            return Comparing.equal(this.myElementAtPointer, that.myElementAtPointer) && this.myRanges.equals(that.myRanges);
        }

        @NotNull
        public List<TextRange> getRanges() {
            List<TextRange> list2 = this.myRanges;
            if (list2 == null) {
                Info.$$$reportNull$$$0(7);
            }
            return list2;
        }

        @NotNull
        public abstract DocInfo getInfo();

        public abstract boolean isValid(@NotNull Document var1);

        public abstract boolean isNavigatable();

        boolean rangesAreCorrect(@NotNull Document document) {
            if (document == null) {
                Info.$$$reportNull$$$0(8);
            }
            TextRange docRange = new TextRange(0, document.getTextLength());
            for (TextRange range2 : this.getRanges()) {
                if (docRange.contains(range2)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementAtPointer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranges";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$Info";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "that";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/navigation/CtrlMouseHandler$Info";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceRanges";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferenceRanges";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isSimilarTo";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "rangesAreCorrect";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum BrowseMode {
        None,
        Declaration,
        TypeDeclaration,
        Implementation;

    }
}

