/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.navigation.MethodNavigationOffsetProvider;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class MethodUpDownUtil {
    private MethodUpDownUtil() {
    }

    public static int[] getNavigationOffsets(PsiFile file2, int caretOffset) {
        for (MethodNavigationOffsetProvider provider : MethodNavigationOffsetProvider.EP_NAME.getExtensionList()) {
            int[] offsets2 = provider.getMethodNavigationOffsets(file2, caretOffset);
            if (offsets2 == null || offsets2.length <= 0) continue;
            return offsets2;
        }
        THashSet array = new THashSet();
        MethodUpDownUtil.addNavigationElements(array, file2);
        return MethodUpDownUtil.offsetsFromElements(array);
    }

    public static int[] offsetsFromElements(Collection<? extends PsiElement> array) {
        TIntArrayList offsets2 = new TIntArrayList(array.size());
        for (PsiElement psiElement : array) {
            int offset = psiElement.getTextOffset();
            assert (offset >= 0) : psiElement + " (" + psiElement.getClass() + "); offset: " + offset;
            offsets2.add(offset);
        }
        offsets2.sort();
        return offsets2.toNativeArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNavigationElements(Collection<? super PsiElement> array, PsiFile element2) {
        StructureViewBuilder structureViewBuilder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(element2);
        if (structureViewBuilder instanceof TreeBasedStructureViewBuilder) {
            TreeBasedStructureViewBuilder builder2 = (TreeBasedStructureViewBuilder)structureViewBuilder;
            StructureViewModel model = builder2.createStructureViewModel(null);
            try {
                MethodUpDownUtil.addStructureViewElements(model.getRoot(), array, element2);
            }
            finally {
                Disposer.dispose(model);
            }
        }
    }

    private static void addStructureViewElements(TreeElement parent, Collection<? super PsiElement> array, @NotNull PsiFile file2) {
        if (file2 == null) {
            MethodUpDownUtil.$$$reportNull$$$0(0);
        }
        for (TreeElement treeElement : parent.getChildren()) {
            Object value2 = ((StructureViewTreeElement)treeElement).getValue();
            if (value2 instanceof PsiElement) {
                PsiElement element2 = (PsiElement)value2;
                if (array.contains(element2) || !file2.equals(element2.getContainingFile())) continue;
                array.add(element2);
            }
            MethodUpDownUtil.addStructureViewElements(treeElement, array, file2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/MethodUpDownUtil", "addStructureViewElements"));
    }
}

