/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtilKt;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.navigation.ChooserKt;
import com.intellij.navigation.NavigationTarget;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J!\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/navigation/actions/GotoDeclarationOnlyHandler2;", "Lcom/intellij/codeInsight/CodeInsightActionHandler;", "()V", "gotoTarget", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "target", "Lcom/intellij/navigation/NavigationTarget;", "invoke", "navigateInCurrentEditor", "", "Lcom/intellij/pom/Navigatable;", "notifyCantGoAnywhere", "startInWriteAction", "intellij.platform.lang.impl"})
public final class GotoDeclarationOnlyHandler2
implements CodeInsightActionHandler {
    public static final GotoDeclarationOnlyHandler2 INSTANCE;

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.declaration");
        try {
            collection = (Collection)ActionUtil.underModalProgress(project2, "Resolving Reference...", new Computable<T>(project2, editor, file2){
                final /* synthetic */ Project $project;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ PsiFile $file;

                @NotNull
                public final Collection<NavigationTarget> compute() {
                    return TargetElementUtilKt.findAllTargets(this.$project, this.$editor, this.$file);
                }
                {
                    this.$project = project2;
                    this.$editor = editor;
                    this.$file = psiFile;
                }
            });
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance(project2).showDumbModeNotification("Navigation is not available here during index update");
            return;
        }
        Collection targets2 = collection;
        if (targets2.isEmpty()) {
            this.notifyCantGoAnywhere(project2, editor, file2);
        } else {
            String string = CodeInsightBundle.message("declaration.navigation.title", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CodeInsightBundle.messag\u2026ration.navigation.title\")");
            Collection collection2 = targets2;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"targets");
            ChooserKt.chooseTarget(editor, string, (List<? extends NavigationTarget>)CollectionsKt.toList((Iterable)collection2), (Function1<? super NavigationTarget, Unit>)((Function1)new Function1<NavigationTarget, Unit>(project2, editor, file2){
                final /* synthetic */ Project $project;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ PsiFile $file;

                public final void invoke(@NotNull NavigationTarget it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    GotoDeclarationOnlyHandler2.access$gotoTarget(GotoDeclarationOnlyHandler2.INSTANCE, this.$project, this.$editor, this.$file, it);
                }
                {
                    this.$project = project2;
                    this.$editor = editor;
                    this.$file = psiFile;
                    super(1);
                }
            }));
        }
    }

    private final void notifyCantGoAnywhere(Project project2, Editor editor, PsiFile file2) {
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        if (!GotoDeclarationAction.isKeywordUnderCaret(project2, file2, caretModel.getOffset())) {
            HintManager.getInstance().showErrorHint(editor, "Cannot find declaration to go to");
        }
    }

    private final void gotoTarget(Project project2, Editor editor, PsiFile file2, NavigationTarget target2) {
        Navigatable navigatable = target2.getNavigatable();
        if (navigatable == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)navigatable, (String)"target.navigatable ?: return");
        Navigatable navigatable2 = navigatable;
        if (this.navigateInCurrentEditor(project2, editor, file2, navigatable2)) {
            return;
        }
        if (navigatable2.canNavigate()) {
            navigatable2.navigate(true);
        }
    }

    private final boolean navigateInCurrentEditor(Project project2, Editor editor, PsiFile file2, Navigatable target2) {
        if (!editor.isDisposed() && target2 instanceof OpenFileDescriptor && Intrinsics.areEqual((Object)((OpenFileDescriptor)target2).getFile(), (Object)file2.getVirtualFile())) {
            Project project$iv = null;
            String name$iv = null;
            String groupId$iv = null;
            boolean $i$f$executeCommand = false;
            CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(project2, target2, editor){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ Navigatable $target$inlined;
                final /* synthetic */ Editor $editor$inlined;
                {
                    this.$project$inlined = project2;
                    this.$target$inlined = navigatable;
                    this.$editor$inlined = editor;
                }

                public final void run() {
                    boolean bl = false;
                    IdeDocumentHistory.getInstance(this.$project$inlined).includeCurrentCommandAsNavigation();
                    ((OpenFileDescriptor)this.$target$inlined).navigateIn(this.$editor$inlined);
                }
            }, name$iv, groupId$iv);
            return true;
        }
        return false;
    }

    private GotoDeclarationOnlyHandler2() {
    }

    static {
        GotoDeclarationOnlyHandler2 gotoDeclarationOnlyHandler2;
        INSTANCE = gotoDeclarationOnlyHandler2 = new GotoDeclarationOnlyHandler2();
    }

    public static final /* synthetic */ void access$gotoTarget(GotoDeclarationOnlyHandler2 $this, Project project2, Editor editor, PsiFile file2, NavigationTarget target2) {
        $this.gotoTarget(project2, editor, file2, target2);
    }
}

