/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.preview.ElementPreviewProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImageOrColorPreviewManager
implements Disposable,
EditorMouseMotionListener,
EditorFactoryListener {
    private static final Logger LOG = Logger.getInstance(ImageOrColorPreviewManager.class);
    private static final Key<KeyListener> EDITOR_LISTENER_ADDED = Key.create("previewManagerListenerAdded");
    private final Alarm alarm = new Alarm();
    @Nullable
    private Collection<PsiElement> myElements;

    ImageOrColorPreviewManager() {
    }

    @Override
    public void editorCreated(@NotNull EditorFactoryEvent event) {
        if (event == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(0);
        }
        this.registerListeners(event.getEditor());
    }

    @Override
    public void editorReleased(@NotNull EditorFactoryEvent event) {
        Editor editor;
        if (event == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(1);
        }
        if ((editor = event.getEditor()).isOneLineMode()) {
            return;
        }
        KeyListener keyListener = EDITOR_LISTENER_ADDED.get(editor);
        if (keyListener != null) {
            EDITOR_LISTENER_ADDED.set(editor, null);
            editor.getContentComponent().removeKeyListener(keyListener);
            editor.removeEditorMouseMotionListener(this);
        }
    }

    private void registerListeners(final Editor editor) {
        if (editor.isOneLineMode()) {
            return;
        }
        Project project2 = editor.getProject();
        if (project2 == null || project2.isDisposed()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
        if (psiFile == null || psiFile instanceof PsiCompiledElement || !ImageOrColorPreviewManager.isSupportedFile(psiFile)) {
            return;
        }
        editor.addEditorMouseMotionListener(this);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PointerInfo pointerInfo;
                if (e.getKeyCode() == 16 && !editor.isOneLineMode() && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
                    Point location2 = pointerInfo.getLocation();
                    SwingUtilities.convertPointFromScreen(location2, editor.getContentComponent());
                    ImageOrColorPreviewManager.this.alarm.cancelAllRequests();
                    ImageOrColorPreviewManager.this.alarm.addRequest((Runnable)new PreviewRequest(location2, editor, true), 100);
                }
            }
        };
        editor.getContentComponent().addKeyListener(keyListener);
        EDITOR_LISTENER_ADDED.set(editor, (KeyListener)keyListener);
    }

    private static boolean isSupportedFile(PsiFile psiFile) {
        for (PsiFile file2 : psiFile.getViewProvider().getAllFiles()) {
            for (ElementPreviewProvider provider : ElementPreviewProvider.EP_NAME.getExtensionList()) {
                if (!provider.isSupportedFile(file2)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Collection<PsiElement> getPsiElementsAt(Point point, Editor editor) {
        Document document;
        if (editor.isDisposed()) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                ImageOrColorPreviewManager.$$$reportNull$$$0(2);
            }
            return set;
        }
        Project project2 = editor.getProject();
        if (project2 == null || project2.isDisposed()) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                ImageOrColorPreviewManager.$$$reportNull$$$0(3);
            }
            return set;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
        PsiFile psiFile = documentManager.getPsiFile(document = editor.getDocument());
        if (psiFile == null || psiFile instanceof PsiCompiledElement || !psiFile.isValid()) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                ImageOrColorPreviewManager.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<PsiElement> elements2 = ContainerUtil.createWeakSet();
        int offset = editor.logicalPositionToOffset(editor.xyToLogicalPosition(point));
        if (documentManager.isCommitted(document)) {
            ContainerUtil.addIfNotNull(elements2, InjectedLanguageUtil.findElementAtNoCommit(psiFile, offset));
        }
        for (PsiFile file2 : psiFile.getViewProvider().getAllFiles()) {
            ContainerUtil.addIfNotNull(elements2, file2.findElementAt(offset));
        }
        Set<PsiElement> set = elements2;
        if (set == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    public void dispose() {
        this.alarm.cancelAllRequests();
        this.myElements = null;
    }

    @Override
    public void mouseMoved(@NotNull EditorMouseEvent event) {
        Editor editor;
        if (event == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(6);
        }
        if ((editor = event.getEditor()).isOneLineMode()) {
            return;
        }
        this.alarm.cancelAllRequests();
        Point point = event.getMouseEvent().getPoint();
        Collection<PsiElement> elements2 = this.myElements;
        if (elements2 == null && event.getMouseEvent().isShiftDown()) {
            this.alarm.addRequest((Runnable)new PreviewRequest(point, editor, false), 100);
        } else if (elements2 != null && !ImageOrColorPreviewManager.getPsiElementsAt(point, editor).equals(elements2)) {
            this.myElements = null;
            for (ElementPreviewProvider provider : ElementPreviewProvider.EP_NAME.getExtensionList()) {
                try {
                    for (PsiElement element2 : elements2) {
                        provider.hide(element2, editor);
                    }
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/preview/ImageOrColorPreviewManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/preview/ImageOrColorPreviewManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementsAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "editorCreated";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "editorReleased";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class PreviewRequest
    implements Runnable {
        private final Point point;
        private final Editor editor;
        private final boolean keyTriggered;

        PreviewRequest(Point point, Editor editor, boolean keyTriggered) {
            this.point = point;
            this.editor = editor;
            this.keyTriggered = keyTriggered;
        }

        @Override
        public void run() {
            Collection elements2 = ImageOrColorPreviewManager.getPsiElementsAt(this.point, this.editor);
            if (elements2.equals(ImageOrColorPreviewManager.this.myElements)) {
                return;
            }
            for (PsiElement element2 : elements2) {
                if (element2 == null || !element2.isValid()) {
                    return;
                }
                if (PsiDocumentManager.getInstance(element2.getProject()).isUncommited(this.editor.getDocument()) || DumbService.getInstance(element2.getProject()).isDumb()) {
                    return;
                }
                for (ElementPreviewProvider provider : ElementPreviewProvider.EP_NAME.getExtensions()) {
                    if (!provider.isSupportedFile(element2.getContainingFile())) continue;
                    try {
                        provider.show(element2, this.editor, this.point, this.keyTriggered);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.error(e);
                    }
                }
            }
            ImageOrColorPreviewManager.this.myElements = elements2;
        }
    }
}

