/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.LiveTemplatesConfigurable;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;

public class LiveTemplateLookupActionProvider
implements LookupActionProvider {
    @Override
    public void fillActions(LookupElement element2, final Lookup lookup2, Consumer<LookupElementAction> consumer) {
        if (element2 instanceof LiveTemplateLookupElementImpl) {
            final TemplateImpl template = ((LiveTemplateLookupElementImpl)element2).getTemplate();
            final TemplateImpl templateFromSettings = TemplateSettings.getInstance().getTemplate(template.getKey(), template.getGroupName());
            if (templateFromSettings != null) {
                consumer.consume(new LookupElementAction(PlatformIcons.EDIT, CodeInsightBundle.message("action.text.edit.live.template.settings", new Object[0])){

                    @Override
                    public LookupElementAction.Result performLookupAction() {
                        Project project2 = lookup2.getProject();
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (project2.isDisposed()) {
                                return;
                            }
                            LiveTemplatesConfigurable configurable2 = new LiveTemplatesConfigurable();
                            ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable2, () -> configurable2.getTemplateListPanel().editTemplate(template));
                        });
                        return LookupElementAction.Result.HIDE_LOOKUP;
                    }
                });
                consumer.consume(new LookupElementAction(AllIcons.Actions.Cancel, String.format("Disable '%s' template", template.getKey())){

                    @Override
                    public LookupElementAction.Result performLookupAction() {
                        ApplicationManager.getApplication().invokeLater(() -> templateFromSettings.setDeactivated(true));
                        return LookupElementAction.Result.HIDE_LOOKUP;
                    }
                });
            }
        }
    }
}

