/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.RealLookupElementPresentation;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LiveTemplateLookupElement
extends LookupElement {
    private final String myLookupString;
    public final boolean sudden;
    private final boolean myWorthShowingInAutoPopup;
    private final String myDescription;

    public LiveTemplateLookupElement(@NotNull String lookupString, @Nullable String description, boolean sudden, boolean worthShowingInAutoPopup) {
        if (lookupString == null) {
            LiveTemplateLookupElement.$$$reportNull$$$0(0);
        }
        this.myDescription = description;
        this.sudden = sudden;
        this.myLookupString = lookupString;
        this.myWorthShowingInAutoPopup = worthShowingInAutoPopup;
    }

    @Override
    @NotNull
    public String getLookupString() {
        String string = this.myLookupString;
        if (string == null) {
            LiveTemplateLookupElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected String getItemText() {
        String string = this.myLookupString;
        if (string == null) {
            LiveTemplateLookupElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        char shortcut = this.getTemplateShortcut();
        presentation.setItemText(this.getItemText());
        if (this.sudden) {
            presentation.setItemTextBold(true);
            if (!(presentation instanceof RealLookupElementPresentation) || !((RealLookupElementPresentation)presentation).isLookupSelectionTouched()) {
                if (shortcut == 'D') {
                    shortcut = TemplateSettings.getInstance().getDefaultShortcutChar();
                }
                if (shortcut == 'C') {
                    String shortcutText = KeymapUtil.getFirstKeyboardShortcutText(ActionManager.getInstance().getAction("ExpandLiveTemplateCustom"));
                    if (StringUtil.isNotEmpty(shortcutText)) {
                        presentation.setTypeText("  [" + shortcutText + "] ");
                    }
                } else if (shortcut != 'N') {
                    presentation.setTypeText("  [" + KeyEvent.getKeyText(shortcut) + "] ");
                }
            }
            if (StringUtil.isNotEmpty(this.myDescription)) {
                presentation.setTailText(" (" + this.myDescription + ")", true);
            }
        } else {
            presentation.setTypeText(this.myDescription);
        }
    }

    @Override
    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return AutoCompletionPolicy.NEVER_AUTOCOMPLETE;
    }

    @Override
    public boolean isWorthShowingInAutoPopup() {
        return this.myWorthShowingInAutoPopup;
    }

    public abstract char getTemplateShortcut();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/LiveTemplateLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/LiveTemplateLookupElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

