/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveTemplateRunLogger {
    private static final String GROUP = "live.templates";

    LiveTemplateRunLogger() {
    }

    static void log(@NotNull Project project2, @NotNull TemplateImpl template, @NotNull Language language2) {
        FeatureUsageData data2;
        if (project2 == null) {
            LiveTemplateRunLogger.$$$reportNull$$$0(0);
        }
        if (template == null) {
            LiveTemplateRunLogger.$$$reportNull$$$0(1);
        }
        if (language2 == null) {
            LiveTemplateRunLogger.$$$reportNull$$$0(2);
        }
        if ((data2 = LiveTemplateRunLogger.createTemplateData(template, language2)) != null) {
            FUCounterUsageLogger.getInstance().logEvent(project2, GROUP, "started", data2);
        }
    }

    @Nullable
    static Triple<String, String, PluginInfo> getKeyGroupPluginToLog(@NotNull TemplateImpl template) {
        String groupName;
        String key;
        if (template == null) {
            LiveTemplateRunLogger.$$$reportNull$$$0(3);
        }
        if (LiveTemplateRunLogger.isCreatedProgrammatically(key = template.getKey(), groupName = template.getGroupName())) {
            return null;
        }
        PluginInfo plugin = TemplateSettings.getInstance().findPluginForPredefinedTemplate(template);
        if (plugin == null) {
            key = "user.defined.template";
            groupName = "user.defined.group";
        } else if (!plugin.isSafeToReport()) {
            key = "custom.plugin.template";
            groupName = "custom.plugin.group";
        }
        return new Triple((Object)key, (Object)groupName, (Object)plugin);
    }

    @Nullable
    static FeatureUsageData createTemplateData(@NotNull TemplateImpl template, @NotNull Language language2) {
        Triple<String, String, PluginInfo> keyGroupPluginToLog;
        if (template == null) {
            LiveTemplateRunLogger.$$$reportNull$$$0(4);
        }
        if (language2 == null) {
            LiveTemplateRunLogger.$$$reportNull$$$0(5);
        }
        if ((keyGroupPluginToLog = LiveTemplateRunLogger.getKeyGroupPluginToLog(template)) == null) {
            return null;
        }
        FeatureUsageData data2 = new FeatureUsageData().addLanguage(language2).addData("group", (String)keyGroupPluginToLog.getSecond());
        PluginInfo plugin = (PluginInfo)keyGroupPluginToLog.getThird();
        if (plugin != null) {
            data2.addPluginInfo(plugin);
        }
        data2.addData("key", (String)keyGroupPluginToLog.getFirst());
        data2.addData("changedByUser", TemplateSettings.getInstance().differsFromDefault(template));
        return data2;
    }

    private static boolean isCreatedProgrammatically(String key, String groupName) {
        return StringUtil.isEmpty(key) || StringUtil.isEmpty(groupName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/impl/LiveTemplateRunLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "log";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getKeyGroupPluginToLog";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createTemplateData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class LiveTemplateValidator
    extends CustomWhiteListRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "live_template".equals(ruleId) || "live_template_group".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                LiveTemplateValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                LiveTemplateValidator.$$$reportNull$$$0(1);
            }
            String key = this.getEventDataField(context, "key");
            String group = this.getEventDataField(context, "group");
            if (key == null || group == null || !LiveTemplateValidator.isKeyOrGroup(data2, key, group)) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    LiveTemplateValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            return LiveTemplateValidator.validateKeyGroup(key, group);
        }

        @NotNull
        public static ValidationResultType validateKeyGroup(String key, Object group) {
            block10: {
                ValidationResultType validationResultType;
                if (group == null) {
                    ValidationResultType validationResultType2 = ValidationResultType.REJECTED;
                    if (validationResultType2 == null) {
                        LiveTemplateValidator.$$$reportNull$$$0(3);
                    }
                    return validationResultType2;
                }
                if ("user.defined.template".equals(key) && "user.defined.group".equals(group)) {
                    ValidationResultType validationResultType3 = ValidationResultType.ACCEPTED;
                    if (validationResultType3 == null) {
                        LiveTemplateValidator.$$$reportNull$$$0(4);
                    }
                    return validationResultType3;
                }
                if ("custom.plugin.template".equals(key) && "custom.plugin.group".equals(group)) {
                    ValidationResultType validationResultType4 = ValidationResultType.ACCEPTED;
                    if (validationResultType4 == null) {
                        LiveTemplateValidator.$$$reportNull$$$0(5);
                    }
                    return validationResultType4;
                }
                try {
                    PluginInfo info;
                    TemplateImpl template = TemplateSettings.getInstance().getTemplate(key, group.toString());
                    if (template == null || (info = TemplateSettings.getInstance().findPluginForPredefinedTemplate(template)) == null || !info.isSafeToReport()) break block10;
                    validationResultType = ValidationResultType.ACCEPTED;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (validationResultType == null) {
                    LiveTemplateValidator.$$$reportNull$$$0(6);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                LiveTemplateValidator.$$$reportNull$$$0(7);
            }
            return validationResultType;
        }

        private static boolean isKeyOrGroup(@NotNull String data2, @NotNull String key, @NotNull String group) {
            if (data2 == null) {
                LiveTemplateValidator.$$$reportNull$$$0(8);
            }
            if (key == null) {
                LiveTemplateValidator.$$$reportNull$$$0(9);
            }
            if (group == null) {
                LiveTemplateValidator.$$$reportNull$$$0(10);
            }
            return StringUtil.equals(data2, key) || StringUtil.equals(data2, group);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/impl/LiveTemplateRunLogger$LiveTemplateValidator";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/impl/LiveTemplateRunLogger$LiveTemplateValidator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "validateKeyGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isKeyOrGroup";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

