/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateListPanel;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.SystemProperties;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.util.Collections;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveTemplateTree
extends CheckboxTree
implements DataProvider,
CopyProvider,
PasteProvider {
    private final TemplateListPanel myConfigurable;

    LiveTemplateTree(CheckboxTree.CheckboxTreeCellRenderer renderer, CheckedTreeNode root, TemplateListPanel configurable2) {
        super(renderer, root);
        this.myConfigurable = configurable2;
        if (!GraphicsEnvironment.isHeadless()) {
            this.setDragEnabled(true);
        }
    }

    @Override
    protected void onNodeStateChanged(CheckedTreeNode node) {
        Object obj = node.getUserObject();
        if (obj instanceof TemplateImpl) {
            ((TemplateImpl)obj).setDeactivated(!node.isChecked());
        }
    }

    @Override
    protected void installSpeedSearch() {
        new TreeSpeedSearch(this, o -> {
            Object object = ((DefaultMutableTreeNode)o.getLastPathComponent()).getUserObject();
            if (object instanceof TemplateGroup) {
                return ((TemplateGroup)object).getName();
            }
            if (object instanceof TemplateImpl) {
                TemplateImpl template = (TemplateImpl)object;
                return StringUtil.notNullize(template.getGroupName()) + " " + StringUtil.notNullize(template.getKey()) + " " + StringUtil.notNullize(template.getDescription()) + " " + template.getTemplateText();
            }
            return "";
        }, true).setComparator(new SubstringSpeedSearchComparator());
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            LiveTemplateTree.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    @Override
    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(1);
        }
        Set<TemplateImpl> templates = this.myConfigurable.getSelectedTemplates().keySet();
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        CopyPasteManager.getInstance().setContents(new StringSelection(StringUtil.join(templates, template -> JDOMUtil.writeElement(TemplateSettings.serializeTemplate(template, templateSettings.getDefaultTemplate((TemplateImpl)template), TemplateContext.getIdToType())), SystemProperties.getLineSeparator())));
    }

    @Override
    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(2);
        }
        return !this.myConfigurable.getSelectedTemplates().isEmpty();
    }

    @Override
    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(3);
        }
        return this.isCopyEnabled(dataContext);
    }

    @Override
    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(4);
        }
        if (this.myConfigurable.getSingleSelectedGroup() == null) {
            return false;
        }
        String s = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        return s != null && s.trim().startsWith("<template ");
    }

    @Override
    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(5);
        }
        return this.isPastePossible(dataContext);
    }

    @Override
    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(6);
        }
        TemplateGroup group = this.myConfigurable.getSingleSelectedGroup();
        assert (group != null);
        String buffer = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        assert (buffer != null);
        try {
            for (Element templateElement : JDOMUtil.load("<root>" + buffer + "</root>").getChildren("template")) {
                TemplateImpl template = TemplateSettings.readTemplateFromElement(group.getName(), templateElement, this.getClass().getClassLoader());
                while (group.containsTemplate(template.getKey(), template.getId())) {
                    template.setKey(template.getKey() + "1");
                    if (template.getId() == null) continue;
                    template.setId(template.getId() + "1");
                }
                this.myConfigurable.addTemplate(template);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/impl/LiveTemplateTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "performCopy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyVisible";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isPastePossible";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isPasteEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "performPaste";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SubstringSpeedSearchComparator
    extends SpeedSearchComparator {
        private SubstringSpeedSearchComparator() {
        }

        @Override
        public int matchingDegree(String pattern, String text2) {
            return this.matchingFragments(pattern, text2) != null ? 1 : 0;
        }

        @Override
        @Nullable
        public Iterable<TextRange> matchingFragments(@NotNull String pattern, @NotNull String text2) {
            int index;
            if (pattern == null) {
                SubstringSpeedSearchComparator.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                SubstringSpeedSearchComparator.$$$reportNull$$$0(1);
            }
            return (index = StringUtil.indexOfIgnoreCase(text2, pattern, 0)) >= 0 ? Collections.singleton(TextRange.from(index, pattern.length())) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/impl/LiveTemplateTree$SubstringSpeedSearchComparator";
            objectArray[2] = "matchingFragments";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

