/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class TemplateExpandShortcutPanel
extends JPanel {
    private final JComboBox<String> myExpandByCombo;
    private final HyperlinkLabel myOpenKeymapLabel;

    public TemplateExpandShortcutPanel(@NotNull String label2) {
        if (label2 == null) {
            TemplateExpandShortcutPanel.$$$reportNull$$$0(0);
        }
        super(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridy = 0;
        JLabel jLabel = new JLabel(label2);
        this.add((Component)jLabel, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.insets = JBUI.insetsLeft(4);
        this.myExpandByCombo = new ComboBox<String>();
        this.add(this.myExpandByCombo, gbConstraints);
        jLabel.setLabelFor(this.myExpandByCombo);
        this.myOpenKeymapLabel = new HyperlinkLabel(CodeInsightBundle.message("link.change.context", new Object[0]));
        gbConstraints.gridx = 2;
        this.add((Component)this.myOpenKeymapLabel, gbConstraints);
        gbConstraints.gridx = 3;
        gbConstraints.weightx = 1.0;
        this.add((Component)new JPanel(), gbConstraints);
        this.setBorder(JBUI.Borders.emptyBottom(10));
        this.myExpandByCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TemplateExpandShortcutPanel.this.myOpenKeymapLabel.setVisible(TemplateExpandShortcutPanel.this.myExpandByCombo.getSelectedItem() == TemplateExpandShortcutPanel.getCustom());
            }
        });
        for (String s : ContainerUtil.ar(TemplateExpandShortcutPanel.getSpace(), TemplateExpandShortcutPanel.getTab(), TemplateExpandShortcutPanel.getEnter(), TemplateExpandShortcutPanel.getCustom())) {
            this.myExpandByCombo.addItem(s);
        }
        this.myExpandByCombo.setRenderer(SimpleListCellRenderer.create("", value2 -> {
            if (value2 == TemplateExpandShortcutPanel.getCustom()) {
                Shortcut[] shortcuts = this.getCurrentCustomShortcuts();
                String shortcutText = shortcuts.length == 0 ? "" : KeymapUtil.getShortcutsText(shortcuts);
                return StringUtil.isEmpty(shortcutText) ? ApplicationBundle.message("custom.option", new Object[0]) : "Custom (" + shortcutText + ")";
            }
            return value2;
        }));
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (this.isConfigurableOpenEvent(evt)) {
                    TemplateExpandShortcutPanel.this.resizeComboToFitCustomShortcut();
                }
            }

            private boolean isConfigurableOpenEvent(PropertyChangeEvent evt) {
                return evt.getPropertyName().equals("ancestor") && evt.getNewValue() != null && evt.getOldValue() == null;
            }
        });
        this.myOpenKeymapLabel.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(HyperlinkEvent e) {
                KeymapPanel keymapPanel;
                Settings allSettings = Settings.KEY.getData(DataManager.getInstance().getDataContext(TemplateExpandShortcutPanel.this.myOpenKeymapLabel));
                KeymapPanel keymapPanel2 = keymapPanel = allSettings == null ? new KeymapPanel() : allSettings.find(KeymapPanel.class);
                if (keymapPanel == null) {
                    return;
                }
                Runnable selectAction = () -> keymapPanel.selectAction("ExpandLiveTemplateCustom");
                if (allSettings != null) {
                    allSettings.select(keymapPanel).doWhenDone(selectAction);
                } else {
                    ShowSettingsUtil.getInstance().editConfigurable((Component)TemplateExpandShortcutPanel.this.myOpenKeymapLabel, (Configurable)keymapPanel, selectAction);
                    TemplateExpandShortcutPanel.this.resizeComboToFitCustomShortcut();
                }
            }
        });
    }

    private Shortcut[] getCurrentCustomShortcuts() {
        Shortcut[] shortcuts;
        Settings allSettings = Settings.KEY.getData(DataManager.getInstance().getDataContext(this.myOpenKeymapLabel));
        KeymapPanel keymapPanel = allSettings == null ? null : allSettings.find(KeymapPanel.class);
        Shortcut[] shortcutArray = shortcuts = keymapPanel == null ? null : keymapPanel.getCurrentShortcuts("ExpandLiveTemplateCustom");
        if (shortcuts == null) {
            Shortcut[] shortcutArray2;
            KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut("ExpandLiveTemplateCustom");
            if (shortcut == null) {
                shortcutArray2 = Shortcut.EMPTY_ARRAY;
            } else {
                Shortcut[] shortcutArray3 = new Shortcut[1];
                shortcutArray2 = shortcutArray3;
                shortcutArray3[0] = shortcut;
            }
            shortcuts = shortcutArray2;
        }
        return shortcuts;
    }

    public String getSelectedString() {
        return (String)this.myExpandByCombo.getSelectedItem();
    }

    public void setSelectedChar(char ch) {
        this.myExpandByCombo.setSelectedItem(ch == 'C' ? TemplateExpandShortcutPanel.getCustom() : (ch == '\t' ? TemplateExpandShortcutPanel.getTab() : (ch == '\n' ? TemplateExpandShortcutPanel.getEnter() : TemplateExpandShortcutPanel.getSpace())));
    }

    public char getSelectedChar() {
        Object selectedItem = this.myExpandByCombo.getSelectedItem();
        if (TemplateExpandShortcutPanel.getTab().equals(selectedItem)) {
            return '\t';
        }
        if (TemplateExpandShortcutPanel.getEnter().equals(selectedItem)) {
            return '\n';
        }
        if (TemplateExpandShortcutPanel.getSpace().equals(selectedItem)) {
            return ' ';
        }
        return 'C';
    }

    private void resizeComboToFitCustomShortcut() {
        this.myExpandByCombo.setPrototypeDisplayValue(null);
        this.myExpandByCombo.setPrototypeDisplayValue(TemplateExpandShortcutPanel.getCustom());
        this.myExpandByCombo.revalidate();
        this.myExpandByCombo.repaint();
    }

    private static String getSpace() {
        return CodeInsightBundle.message("template.shortcut.space", new Object[0]);
    }

    private static String getTab() {
        return CodeInsightBundle.message("template.shortcut.tab", new Object[0]);
    }

    private static String getEnter() {
        return CodeInsightBundle.message("template.shortcut.enter", new Object[0]);
    }

    private static String getCustom() {
        return CodeInsightBundle.message("template.shortcut.custom", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/codeInsight/template/impl/TemplateExpandShortcutPanel", "<init>"));
    }
}

