/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.RecalculatableResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TemplateSubstitutor;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.LiveTemplateRunLogger;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateExpressionLookupElement;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.codeInsight.template.impl.TemplatePreprocessor;
import com.intellij.codeInsight.template.impl.TemplateSegments;
import com.intellij.codeInsight.template.macro.TemplateCompletionProcessor;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateState
implements Disposable {
    private static final Logger LOG = Logger.getInstance(TemplateState.class);
    private Project myProject;
    private Editor myEditor;
    private TemplateImpl myTemplate;
    private TemplateImpl myPrevTemplate;
    private TemplateSegments mySegments;
    private Map<String, String> myPredefinedVariableValues;
    private RangeMarker myTemplateRange;
    private final List<RangeHighlighter> myTabStopHighlighters;
    private int myCurrentVariableNumber;
    private int myCurrentSegmentNumber;
    private boolean ourLookupShown;
    private boolean myDocumentChangesTerminateTemplate;
    private boolean myDocumentChanged;
    @Nullable
    private LookupListener myLookupListener;
    private final List<TemplateEditingListener> myListeners;
    private DocumentListener myEditorDocumentListener;
    private final Map myProperties;
    private boolean myTemplateIndented;
    private Document myDocument;
    private boolean myFinished;
    @Nullable
    private PairProcessor<? super String, ? super String> myProcessor;
    private boolean mySelectionCalculated;
    private boolean myStarted;

    TemplateState(@NotNull Project project2, @NotNull Editor editor) {
        if (project2 == null) {
            TemplateState.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TemplateState.$$$reportNull$$$0(1);
        }
        this.myTabStopHighlighters = new ArrayList<RangeHighlighter>();
        this.myCurrentVariableNumber = -1;
        this.myCurrentSegmentNumber = -1;
        this.myDocumentChangesTerminateTemplate = true;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProperties = new HashMap();
        this.myProject = project2;
        this.myEditor = editor;
        this.myDocument = this.myEditor.getDocument();
    }

    private void initListeners() {
        if (this.isDisposed()) {
            return;
        }
        this.myEditorDocumentListener = new DocumentListener(){

            @Override
            public void beforeDocumentChange(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CommandProcessor.getInstance().getCurrentCommand() != null && !UndoManager.getInstance(TemplateState.this.myProject).isUndoOrRedoInProgress()) {
                    TemplateState.this.myDocumentChanged = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateState$1", "beforeDocumentChange"));
            }
        };
        this.myLookupListener = new LookupListener(){

            @Override
            public void itemSelected(@NotNull LookupEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (TemplateState.this.isCaretOutsideCurrentSegment(null)) {
                    if (TemplateState.this.isCaretInsideOrBeforeNextVariable()) {
                        TemplateState.this.nextTab();
                    } else {
                        TemplateState.this.gotoEnd(true);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/impl/TemplateState$2", "itemSelected"));
            }
        };
        LookupManager.getInstance(this.myProject).addPropertyChangeListener(evt -> {
            Lookup lookup2;
            if ("activeLookup".equals(evt.getPropertyName()) && (lookup2 = (Lookup)evt.getNewValue()) != null) {
                lookup2.addLookupListener(this.myLookupListener);
            }
        }, this);
        if (this.myEditor != null) {
            this.installCaretListener(this.myEditor);
        }
        this.myDocument.addDocumentListener(this.myEditorDocumentListener, this);
        this.myProject.getMessageBus().connect(this).subscribe(CommandListener.TOPIC, new CommandListener(){
            boolean started;

            @Override
            public void commandStarted(@NotNull CommandEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!UndoManager.getInstance(TemplateState.this.myProject).isUndoOrRedoInProgress()) {
                    TemplateState.this.myDocumentChangesTerminateTemplate = TemplateState.this.isCaretOutsideCurrentSegment(event.getCommandName());
                    this.started = true;
                }
            }

            @Override
            public void beforeCommandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (this.started && !TemplateState.this.isDisposed() && !UndoManager.getInstance(TemplateState.this.myProject).isUndoOrRedoInProgress()) {
                    LookupImpl lookup2;
                    Runnable runnable2 = () -> TemplateState.this.afterChangedUpdate();
                    LookupImpl lookupImpl = lookup2 = TemplateState.this.myEditor != null ? (LookupImpl)LookupManager.getActiveLookup(TemplateState.this.myEditor) : null;
                    if (lookup2 != null) {
                        lookup2.performGuardedChange(runnable2);
                    } else {
                        runnable2.run();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateState$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeCommandFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void installCaretListener(@NotNull Editor editor) {
        if (editor == null) {
            TemplateState.$$$reportNull$$$0(2);
        }
        CaretListener listener2 = new CaretListener(){

            @Override
            public void caretAdded(@NotNull CaretEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (TemplateState.this.isMultiCaretMode()) {
                    TemplateState.this.finishTemplateEditing();
                }
            }

            @Override
            public void caretRemoved(@NotNull CaretEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (TemplateState.this.isMultiCaretMode()) {
                    TemplateState.this.finishTemplateEditing();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateState$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        editor.getCaretModel().addCaretListener(listener2, this);
    }

    private boolean isCaretInsideOrBeforeNextVariable() {
        if (this.myEditor != null && this.myCurrentVariableNumber >= 0) {
            TextRange nextVarRange;
            int nextVar = this.getNextVariableNumber(this.myCurrentVariableNumber);
            TextRange textRange = nextVarRange = nextVar < 0 ? null : this.getVariableRange(this.myTemplate.getVariableNameAt(nextVar));
            if (nextVarRange == null) {
                return false;
            }
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            if (nextVarRange.containsOffset(caretOffset)) {
                return true;
            }
            TextRange currentVarRange = this.getVariableRange(this.myTemplate.getVariableNameAt(this.myCurrentVariableNumber));
            return currentVarRange != null && currentVarRange.getEndOffset() < caretOffset && caretOffset < nextVarRange.getStartOffset();
        }
        return false;
    }

    private boolean isCaretOutsideCurrentSegment(String commandName) {
        if (this.myEditor != null && this.myCurrentSegmentNumber >= 0) {
            int offset = this.myEditor.getCaretModel().getOffset();
            boolean hasSelection = this.myEditor.getSelectionModel().hasSelection();
            int segmentStart = this.mySegments.getSegmentStart(this.myCurrentSegmentNumber);
            if (offset < segmentStart || !hasSelection && offset == segmentStart && ActionsBundle.actionText("EditorBackSpace").equals(commandName)) {
                return true;
            }
            int segmentEnd = this.mySegments.getSegmentEnd(this.myCurrentSegmentNumber);
            if (offset > segmentEnd || !hasSelection && offset == segmentEnd && ActionsBundle.actionText("EditorDelete").equals(commandName)) {
                return true;
            }
        }
        return false;
    }

    private boolean isMultiCaretMode() {
        return this.myEditor != null && this.myEditor.getCaretModel().getCaretCount() > 1;
    }

    @Override
    public synchronized void dispose() {
        if (this.myLookupListener != null) {
            LookupImpl lookup2;
            LookupImpl lookupImpl = lookup2 = this.myEditor != null ? (LookupImpl)LookupManager.getActiveLookup(this.myEditor) : null;
            if (lookup2 != null) {
                lookup2.removeLookupListener(this.myLookupListener);
            }
            this.myLookupListener = null;
        }
        this.myEditorDocumentListener = null;
        this.myProcessor = null;
        this.releaseAll();
        this.myDocument = null;
    }

    public boolean isToProcessTab() {
        LookupImpl lookup2;
        if (this.isCaretOutsideCurrentSegment(null)) {
            return false;
        }
        if (this.ourLookupShown && (lookup2 = (LookupImpl)LookupManager.getActiveLookup(this.myEditor)) != null && !lookup2.isFocused()) {
            return true;
        }
        return !this.ourLookupShown;
    }

    private void setCurrentVariableNumber(int variableNumber) {
        this.myCurrentVariableNumber = variableNumber;
        boolean isFinished = this.isFinished();
        if (this.myDocument != null) {
            ((DocumentEx)this.myDocument).setStripTrailingSpacesEnabled(isFinished);
        }
        this.myCurrentSegmentNumber = isFinished ? -1 : this.getCurrentSegmentNumber();
    }

    @Nullable
    public TextResult getVariableValue(@NotNull String variableName) {
        String text2;
        if (variableName == null) {
            TemplateState.$$$reportNull$$$0(3);
        }
        if (variableName.equals("SELECTION")) {
            return new TextResult(StringUtil.notNullize(this.getSelectionBeforeTemplate()));
        }
        if (variableName.equals("END")) {
            return new TextResult("");
        }
        if (this.myPredefinedVariableValues != null && (text2 = this.myPredefinedVariableValues.get(variableName)) != null) {
            return new TextResult(text2);
        }
        int segmentNumber = this.myTemplate.getVariableSegmentNumber(variableName);
        if (segmentNumber < 0 || this.mySegments.getSegmentsCount() <= segmentNumber) {
            return null;
        }
        CharSequence text3 = this.myDocument.getImmutableCharSequence();
        int start2 = this.mySegments.getSegmentStart(segmentNumber);
        int end = this.mySegments.getSegmentEnd(segmentNumber);
        int length = text3.length();
        if (start2 > length || end > length) {
            return null;
        }
        return new TextResult(text3.subSequence(start2, end).toString());
    }

    @Nullable
    private String getSelectionBeforeTemplate() {
        return (String)this.getProperties().get(ExpressionContext.SELECTION);
    }

    @Nullable
    public TextRange getCurrentVariableRange() {
        int number = this.getCurrentSegmentNumber();
        if (number == -1) {
            return null;
        }
        return new TextRange(this.mySegments.getSegmentStart(number), this.mySegments.getSegmentEnd(number));
    }

    @Nullable
    public TextRange getVariableRange(String variableName) {
        int segment = this.myTemplate.getVariableSegmentNumber(variableName);
        if (segment < 0) {
            return null;
        }
        return new TextRange(this.mySegments.getSegmentStart(segment), this.mySegments.getSegmentEnd(segment));
    }

    public int getSegmentsCount() {
        return this.mySegments.getSegmentsCount();
    }

    public TextRange getSegmentRange(int segment) {
        return new TextRange(this.mySegments.getSegmentStart(segment), this.mySegments.getSegmentEnd(segment));
    }

    public boolean isFinished() {
        return this.myCurrentVariableNumber < 0;
    }

    private void releaseAll() {
        if (this.mySegments != null) {
            this.mySegments.removeAll();
            this.mySegments = null;
        }
        if (this.myTemplateRange != null) {
            this.myTemplateRange.dispose();
            this.myTemplateRange = null;
        }
        this.myPrevTemplate = this.myTemplate;
        this.myTemplate = null;
        this.myProject = null;
        this.releaseEditor();
    }

    private void releaseEditor() {
        if (this.myEditor != null) {
            for (RangeHighlighter segmentHighlighter : this.myTabStopHighlighters) {
                segmentHighlighter.dispose();
            }
            this.myTabStopHighlighters.clear();
            this.myEditor = null;
        }
    }

    void start(@NotNull TemplateImpl template, @Nullable PairProcessor<? super String, ? super String> processor2, @Nullable Map<String, String> predefinedVarValues) {
        if (template == null) {
            TemplateState.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!this.myStarted, "Already started");
        this.myStarted = true;
        PsiFile file2 = this.getPsiFile();
        this.myTemplate = TemplateState.substituteTemplate(Objects.requireNonNull(file2), this.myEditor.getCaretModel().getOffset(), template);
        this.myProcessor = processor2;
        MyBasicUndoableAction undoableAction = new MyBasicUndoableAction(this, this.myDocument);
        UndoManager.getInstance(this.myProject).undoableActionPerformed(undoableAction);
        Disposer.register(this, undoableAction);
        this.myTemplateIndented = false;
        this.myCurrentVariableNumber = -1;
        this.mySegments = new TemplateSegments(this.myEditor);
        this.myPrevTemplate = this.myTemplate;
        this.myPredefinedVariableValues = predefinedVarValues;
        if (this.myTemplate.isInline()) {
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            this.myTemplateRange = this.myDocument.createRangeMarker(caretOffset, caretOffset + this.myTemplate.getTemplateText().length());
        } else {
            this.preprocessTemplate(file2, this.myEditor.getCaretModel().getOffset(), this.myTemplate.getTemplateText());
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            this.myTemplateRange = this.myDocument.createRangeMarker(caretOffset, caretOffset);
        }
        this.myTemplateRange.setGreedyToLeft(true);
        this.myTemplateRange.setGreedyToRight(true);
        LiveTemplateRunLogger.log(this.myProject, template, file2.getLanguage());
        this.processAllExpressions(this.myTemplate);
    }

    private void fireTemplateCancelled() {
        if (this.myFinished) {
            return;
        }
        this.myFinished = true;
        for (TemplateEditingListener listener2 : this.myListeners) {
            listener2.templateCancelled(this.myTemplate);
        }
    }

    @NotNull
    private static TemplateImpl substituteTemplate(@NotNull PsiFile file2, int caretOffset, @NotNull TemplateImpl template) {
        if (file2 == null) {
            TemplateState.$$$reportNull$$$0(5);
        }
        if (template == null) {
            TemplateState.$$$reportNull$$$0(6);
        }
        for (TemplateSubstitutor substitutor : TemplateSubstitutor.EP_NAME.getExtensionList()) {
            TemplateImpl substituted = substitutor.substituteTemplate(file2, caretOffset, template);
            if (substituted == null) continue;
            template = substituted;
        }
        TemplateImpl templateImpl = template;
        if (templateImpl == null) {
            TemplateState.$$$reportNull$$$0(7);
        }
        return templateImpl;
    }

    private void preprocessTemplate(PsiFile file2, int caretOffset, String textToInsert) {
        for (TemplatePreprocessor preprocessor : TemplatePreprocessor.EP_NAME.getExtensionList()) {
            preprocessor.preprocessTemplate(this.myEditor, file2, caretOffset, textToInsert, this.myTemplate.getTemplateText());
        }
    }

    private void processAllExpressions(@NotNull TemplateImpl template) {
        if (template == null) {
            TemplateState.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (!template.isInline()) {
                this.myDocument.insertString(this.myTemplateRange.getStartOffset(), template.getTemplateText());
            }
            for (int i = 0; i < template.getSegmentsCount(); ++i) {
                int segmentOffset = this.myTemplateRange.getStartOffset() + template.getSegmentOffset(i);
                this.mySegments.addSegment(segmentOffset, segmentOffset);
            }
            LOG.assertTrue(this.myTemplateRange.isValid(), this.getRangesDebugInfo());
            this.calcResults(false);
            LOG.assertTrue(this.myTemplateRange.isValid(), this.getRangesDebugInfo());
            this.calcResults(false);
            LOG.assertTrue(this.myTemplateRange.isValid(), this.getRangesDebugInfo());
            if (this.myEditor instanceof EditorWindow && !((EditorWindow)((Object)this.myEditor)).isValid()) {
                this.finishTemplateEditing();
                return;
            }
            this.doReformat();
            int nextVariableNumber = this.getNextVariableNumber(-1);
            if (nextVariableNumber >= 0) {
                this.fireWaitingForInput();
            }
            if (nextVariableNumber == -1) {
                this.finishTemplateEditing();
            } else {
                this.setCurrentVariableNumber(nextVariableNumber);
                this.initTabStopHighlighters();
                this.initListeners();
                this.focusCurrentExpression();
                this.currentVariableChanged(-1);
                if (this.isMultiCaretMode()) {
                    this.finishTemplateEditing();
                }
            }
        });
    }

    private String getRangesDebugInfo() {
        return this.myTemplateRange + "\ntemplateKey: " + this.myTemplate.getKey() + "\ntemplateText: " + this.myTemplate.getTemplateText() + "\ntemplateString: " + this.myTemplate;
    }

    private void doReformat() {
        Runnable action2 = () -> {
            IntArrayList indices = this.initEmptyVariables();
            this.mySegments.setSegmentsGreedy(false);
            LOG.assertTrue(this.myTemplateRange.isValid(), "template key: " + this.myTemplate.getKey() + "; template text" + this.myTemplate.getTemplateText() + "; variable number: " + this.getCurrentVariableNumber());
            this.reformat();
            this.mySegments.setSegmentsGreedy(true);
            this.restoreEmptyVariables(indices);
        };
        ApplicationManager.getApplication().runWriteAction(action2);
    }

    public void setSegmentsGreedy(boolean greedy) {
        this.mySegments.setSegmentsGreedy(greedy);
    }

    public void setTabStopHighlightersGreedy(boolean greedy) {
        for (RangeHighlighter highlighter : this.myTabStopHighlighters) {
            highlighter.setGreedyToLeft(greedy);
            highlighter.setGreedyToRight(greedy);
        }
    }

    private void shortenReferences() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiFile file2 = this.getPsiFile();
            if (file2 != null) {
                IntArrayList indices = this.initEmptyVariables();
                this.mySegments.setSegmentsGreedy(false);
                for (TemplateOptionalProcessor processor2 : TemplateOptionalProcessor.EP_NAME.getExtensionList()) {
                    processor2.processText(this.myProject, this.myTemplate, this.myDocument, this.myTemplateRange, this.myEditor);
                }
                this.mySegments.setSegmentsGreedy(true);
                this.restoreEmptyVariables(indices);
            }
        });
    }

    private void afterChangedUpdate() {
        if (this.isFinished()) {
            return;
        }
        LOG.assertTrue(this.myTemplate != null, TemplateState.presentTemplate(this.myPrevTemplate));
        if (this.myDocumentChanged) {
            if (this.myDocumentChangesTerminateTemplate || this.mySegments.isInvalid()) {
                int oldIndex = this.myCurrentVariableNumber;
                this.setCurrentVariableNumber(-1);
                this.currentVariableChanged(oldIndex);
                this.fireTemplateCancelled();
            } else {
                this.calcResults(true);
            }
            this.myDocumentChanged = false;
        }
    }

    private static String presentTemplate(@Nullable TemplateImpl template) {
        if (template == null) {
            return "no template";
        }
        String message = StringUtil.notNullize(template.getKey());
        message = message + "\n\nTemplate#name: " + StringUtil.notNullize(template.toString());
        message = message + "\n\nTemplate#string: " + StringUtil.notNullize(template.getString());
        message = message + "\n\nTemplate#text: " + StringUtil.notNullize(template.getTemplateText());
        return message;
    }

    private String getExpressionString(int index) {
        CharSequence text2 = this.myDocument.getCharsSequence();
        if (!this.mySegments.isValid(index)) {
            return "";
        }
        int start2 = this.mySegments.getSegmentStart(index);
        int end = this.mySegments.getSegmentEnd(index);
        return text2.subSequence(start2, end).toString();
    }

    private int getCurrentSegmentNumber() {
        int varNumber = this.myCurrentVariableNumber;
        if (varNumber == -1) {
            return -1;
        }
        String variableName = this.myTemplate.getVariableNameAt(varNumber);
        int segmentNumber = this.myTemplate.getVariableSegmentNumber(variableName);
        if (segmentNumber < 0) {
            Throwable trace = this.myTemplate.getBuildingTemplateTrace();
            LOG.error("No segment for variable: var=" + varNumber + "; name=" + variableName + "; " + TemplateState.presentTemplate(this.myTemplate) + "; offset: " + this.myEditor.getCaretModel().getOffset(), AttachmentFactory.createAttachment(this.myDocument), new Attachment("trace.txt", trace != null ? ExceptionUtil.getThrowableText(trace) : "<empty>"));
        }
        return segmentNumber;
    }

    private void focusCurrentExpression() {
        if (this.isFinished() || this.isDisposed()) {
            return;
        }
        PsiDocumentManager.getInstance(this.myProject).commitDocument(this.myDocument);
        int currentSegmentNumber = this.getCurrentSegmentNumber();
        this.lockSegmentAtTheSameOffsetIfAny();
        if (currentSegmentNumber < 0) {
            return;
        }
        int start2 = this.mySegments.getSegmentStart(currentSegmentNumber);
        int end = this.mySegments.getSegmentEnd(currentSegmentNumber);
        if (end >= 0) {
            this.myEditor.getCaretModel().moveToOffset(end);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            this.myEditor.getSelectionModel().removeSelection();
            this.myEditor.getSelectionModel().setSelection(start2, end);
        }
        DumbService.getInstance(this.myProject).withAlternativeResolveEnabled(() -> {
            Expression expressionNode = this.getCurrentExpression();
            List<TemplateExpressionLookupElement> lookupItems = this.getCurrentExpressionLookupItems();
            PsiFile psiFile = this.getPsiFile();
            if (!lookupItems.isEmpty()) {
                if (((TemplateManagerImpl)TemplateManager.getInstance(this.myProject)).shouldSkipInTests()) {
                    this.insertSingleItem(lookupItems);
                } else {
                    for (LookupElement lookupElement : lookupItems) {
                        assert (lookupElement != null) : expressionNode;
                    }
                    AsyncEditorLoader.performWhenLoaded(this.myEditor, () -> this.runLookup(lookupItems, expressionNode.getAdvertisingText(), expressionNode.getLookupFocusDegree()));
                }
            } else {
                try {
                    Result result2 = expressionNode.calculateResult(this.getCurrentExpressionContext());
                    if (result2 != null) {
                        result2.handleFocused(psiFile, this.myDocument, this.mySegments.getSegmentStart(currentSegmentNumber), this.mySegments.getSegmentEnd(currentSegmentNumber));
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
        });
        this.focusCurrentHighlighter(true);
    }

    @Nullable
    PsiFile getPsiFile() {
        return !this.isDisposed() ? PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myDocument) : null;
    }

    private void insertSingleItem(List<TemplateExpressionLookupElement> lookupItems) {
        TemplateExpressionLookupElement first = lookupItems.get(0);
        EditorModificationUtil.insertStringAtCaret(this.myEditor, first.getLookupString());
        first.handleTemplateInsert(lookupItems, '\u0000');
    }

    @NotNull
    private List<TemplateExpressionLookupElement> getCurrentExpressionLookupItems() {
        LookupElement[] elements2 = null;
        try {
            elements2 = this.getCurrentExpression().calculateLookupItems(this.getCurrentExpressionContext());
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        if (elements2 == null) {
            List<TemplateExpressionLookupElement> list2 = Collections.emptyList();
            if (list2 == null) {
                TemplateState.$$$reportNull$$$0(9);
            }
            return list2;
        }
        ArrayList<TemplateExpressionLookupElement> result2 = new ArrayList<TemplateExpressionLookupElement>();
        for (int i = 0; i < elements2.length; ++i) {
            result2.add(new TemplateExpressionLookupElement(this, elements2[i], i));
        }
        ArrayList<TemplateExpressionLookupElement> arrayList = result2;
        if (arrayList == null) {
            TemplateState.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public ExpressionContext getCurrentExpressionContext() {
        return this.createExpressionContext(this.mySegments.getSegmentStart(this.getCurrentSegmentNumber()));
    }

    public ExpressionContext getExpressionContextForSegment(int segmentNumber) {
        return this.createExpressionContext(this.mySegments.getSegmentStart(segmentNumber));
    }

    @NotNull
    private Expression getCurrentExpression() {
        Expression expression = this.myTemplate.getExpressionAt(this.myCurrentVariableNumber);
        if (expression == null) {
            TemplateState.$$$reportNull$$$0(11);
        }
        return expression;
    }

    private void runLookup(final List<TemplateExpressionLookupElement> lookupItems, @Nullable String advertisingText, @NotNull LookupFocusDegree lookupFocusDegree) {
        if (lookupFocusDegree == null) {
            TemplateState.$$$reportNull$$$0(12);
        }
        if (this.isDisposed()) {
            return;
        }
        LookupManager lookupManager = LookupManager.getInstance(this.myProject);
        final LookupImpl lookup2 = (LookupImpl)lookupManager.showLookup(this.myEditor, lookupItems.toArray(LookupElement.EMPTY_ARRAY));
        if (lookup2 == null) {
            return;
        }
        if (CodeInsightSettings.getInstance().AUTO_POPUP_COMPLETION_LOOKUP && this.myEditor.getUserData(InplaceRefactoring.INPLACE_RENAMER) == null) {
            lookup2.setStartCompletionWhenNothingMatches(true);
        }
        if (advertisingText != null) {
            lookup2.addAdvertisement(advertisingText, null);
        } else {
            ActionManager am = ActionManager.getInstance();
            String enterShortcut = KeymapUtil.getFirstKeyboardShortcutText(am.getAction("EditorChooseLookupItem"));
            String tabShortcut = KeymapUtil.getFirstKeyboardShortcutText(am.getAction("EditorChooseLookupItemReplace"));
            lookup2.addAdvertisement("Press " + enterShortcut + " or " + tabShortcut + " to replace", null);
        }
        lookup2.setLookupFocusDegree(lookupFocusDegree);
        lookup2.refreshUi(true, true);
        this.ourLookupShown = true;
        lookup2.addLookupListener(new LookupListener(){

            @Override
            public void lookupCanceled(@NotNull LookupEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                lookup2.removeLookupListener(this);
                TemplateState.this.ourLookupShown = false;
            }

            @Override
            public void itemSelected(@NotNull LookupEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(1);
                }
                lookup2.removeLookupListener(this);
                if (TemplateState.this.isFinished()) {
                    return;
                }
                TemplateState.this.ourLookupShown = false;
                LookupElement item = event.getItem();
                if (item instanceof TemplateExpressionLookupElement) {
                    ((TemplateExpressionLookupElement)item).handleTemplateInsert(lookupItems, event.getCompletionChar());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateState$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lookupCanceled";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "itemSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void unblockDocument() {
        PsiDocumentManager.getInstance(this.myProject).commitDocument(this.myDocument);
        PsiDocumentManager.getInstance(this.myProject).doPostponedOperationsAndUnblockDocument(this.myDocument);
    }

    void calcResults(boolean isQuick) {
        String variableName;
        TextResult value2;
        if (this.mySegments.isInvalid()) {
            this.gotoEnd(true);
        }
        if (this.myProcessor != null && this.myCurrentVariableNumber >= 0 && (value2 = this.getVariableValue(variableName = this.myTemplate.getVariableNameAt(this.myCurrentVariableNumber))) != null && !value2.getText().isEmpty() && !this.myProcessor.process(variableName, value2.getText())) {
            this.finishTemplateEditing();
            return;
        }
        this.fixOverlappedSegments(this.myCurrentSegmentNumber);
        WriteCommandAction.runWriteCommandAction(this.myProject, null, null, () -> {
            if (this.isDisposed()) {
                return;
            }
            BitSet calcedSegments = new BitSet();
            int maxAttempts = (this.myTemplate.getVariableCount() + 1) * 3;
            do {
                --maxAttempts;
                calcedSegments.clear();
                for (int i = this.myCurrentVariableNumber + 1; i < this.myTemplate.getVariableCount(); ++i) {
                    String variableName = this.myTemplate.getVariableNameAt(i);
                    int segmentNumber = this.myTemplate.getVariableSegmentNumber(variableName);
                    if (segmentNumber < 0) continue;
                    Expression expression = this.myTemplate.getExpressionAt(i);
                    Expression defaultValue = this.myTemplate.getDefaultValueAt(i);
                    String oldValue = this.getVariableValueText(variableName);
                    DumbService.getInstance(this.myProject).withAlternativeResolveEnabled(() -> this.recalcSegment(segmentNumber, isQuick, expression, defaultValue));
                    TextResult value2 = this.getVariableValue(variableName);
                    assert (value2 != null) : "name=" + variableName + "\ntext=" + this.myTemplate.getTemplateText();
                    String newValue = value2.getText();
                    if (newValue.equals(oldValue)) continue;
                    calcedSegments.set(segmentNumber);
                }
                ArrayList<TemplateDocumentChange> changes = new ArrayList<TemplateDocumentChange>();
                boolean selectionCalculated = false;
                for (int i = 0; i < this.myTemplate.getSegmentsCount(); ++i) {
                    if (calcedSegments.get(i)) continue;
                    String variableName = this.myTemplate.getSegmentName(i);
                    if (variableName.equals("SELECTION")) {
                        if (this.mySelectionCalculated) continue;
                        selectionCalculated = true;
                    }
                    if ("END".equals(variableName)) continue;
                    String newValue = this.getVariableValueText(variableName);
                    int start2 = this.mySegments.getSegmentStart(i);
                    int end = this.mySegments.getSegmentEnd(i);
                    changes.add(new TemplateDocumentChange(newValue, start2, end, i));
                }
                this.executeChanges(changes);
                if (!selectionCalculated) continue;
                this.mySelectionCalculated = true;
            } while (!calcedSegments.isEmpty() && maxAttempts >= 0);
        }, new PsiFile[0]);
    }

    private void executeChanges(@NotNull List<TemplateDocumentChange> changes) {
        if (changes == null) {
            TemplateState.$$$reportNull$$$0(13);
        }
        if (this.isDisposed() || changes.isEmpty()) {
            return;
        }
        if (changes.size() > 1) {
            ContainerUtil.sort(changes, (o1, o2) -> {
                int startDiff = o2.startOffset - o1.startOffset;
                return startDiff != 0 ? startDiff : o2.segmentNumber - o1.segmentNumber;
            });
        }
        DocumentUtil.executeInBulk(this.myDocument, true, () -> {
            for (TemplateDocumentChange change : changes) {
                this.replaceString(change.newValue, change.startOffset, change.endOffset, change.segmentNumber);
            }
        });
    }

    private void fixOverlappedSegments(int currentSegment) {
        if (currentSegment >= 0) {
            int currentSegmentStart = this.mySegments.getSegmentStart(currentSegment);
            int currentSegmentEnd = this.mySegments.getSegmentEnd(currentSegment);
            for (int i = 0; i < this.mySegments.getSegmentsCount(); ++i) {
                int endOffset;
                if (i > currentSegment) {
                    int startOffset = this.mySegments.getSegmentStart(i);
                    if (currentSegmentStart > startOffset || startOffset >= currentSegmentEnd) continue;
                    this.mySegments.replaceSegmentAt(i, currentSegmentEnd, Math.max(this.mySegments.getSegmentEnd(i), currentSegmentEnd), true);
                    continue;
                }
                if (i >= currentSegment || currentSegmentStart >= (endOffset = this.mySegments.getSegmentEnd(i)) || endOffset > currentSegmentEnd) continue;
                this.mySegments.replaceSegmentAt(i, Math.min(this.mySegments.getSegmentStart(i), currentSegmentStart), currentSegmentStart, true);
            }
        }
    }

    @NotNull
    private String getVariableValueText(String variableName) {
        TextResult value2 = this.getVariableValue(variableName);
        return value2 != null ? value2.getText() : "";
    }

    private void recalcSegment(int segmentNumber, boolean isQuick, Expression expressionNode, Expression defaultValue) {
        boolean resultIsNullOrEmpty;
        Result result2;
        PsiFile psiFile;
        PsiElement element2;
        boolean commitDocument;
        if (this.isDisposed()) {
            return;
        }
        String oldValue = this.getExpressionString(segmentNumber);
        int start2 = this.mySegments.getSegmentStart(segmentNumber);
        int end = this.mySegments.getSegmentEnd(segmentNumber);
        boolean bl = commitDocument = !isQuick || expressionNode.requiresCommittedPSI();
        if (commitDocument) {
            PsiDocumentManager.getInstance(this.myProject).commitDocument(this.myDocument);
        }
        PsiElement psiElement = element2 = (psiFile = this.getPsiFile()) != null ? psiFile.findElementAt(start2) : null;
        if (element2 != null && commitDocument) {
            PsiUtilCore.ensureValid(element2);
        }
        ExpressionContext context = this.createExpressionContext(start2);
        Result result3 = result2 = isQuick ? expressionNode.calculateQuickResult(context) : expressionNode.calculateResult(context);
        if (isQuick && result2 == null && !oldValue.isEmpty()) {
            return;
        }
        boolean bl2 = resultIsNullOrEmpty = result2 == null || result2.equalsToText("", element2);
        if (resultIsNullOrEmpty && this.myCurrentSegmentNumber >= 0 && (this.mySegments.getSegmentStart(segmentNumber) == this.mySegments.getSegmentEnd(this.myCurrentSegmentNumber) || this.mySegments.getSegmentEnd(segmentNumber) == this.mySegments.getSegmentStart(this.myCurrentSegmentNumber))) {
            return;
        }
        if (defaultValue != null && resultIsNullOrEmpty) {
            result2 = defaultValue.calculateResult(context);
        }
        if (element2 != null && commitDocument) {
            PsiUtilCore.ensureValid(element2);
        }
        if (result2 == null || result2.equalsToText(oldValue, element2)) {
            return;
        }
        this.replaceString(StringUtil.notNullize(result2.toString()), start2, end, segmentNumber);
        if (result2 instanceof RecalculatableResult) {
            IntArrayList indices = this.initEmptyVariables();
            this.shortenReferences();
            PsiDocumentManager.getInstance(this.myProject).commitDocument(this.myDocument);
            ((RecalculatableResult)result2).handleRecalc(psiFile, this.myDocument, this.mySegments.getSegmentStart(segmentNumber), this.mySegments.getSegmentEnd(segmentNumber));
            this.restoreEmptyVariables(indices);
        }
    }

    private void replaceString(String newValue, int start2, int end, int segmentNumber) {
        String oldText;
        TextRange range2 = TextRange.create(start2, end);
        if (!TextRange.from(0, this.myDocument.getCharsSequence().length()).contains(range2)) {
            LOG.error("Diagnostic for EA-54980. Can't extract " + range2 + " range. " + TemplateState.presentTemplate(this.myTemplate), AttachmentFactory.createAttachment(this.myDocument));
        }
        if (!(oldText = range2.subSequence(this.myDocument.getCharsSequence()).toString()).equals(newValue)) {
            this.mySegments.setNeighboursGreedy(segmentNumber, false);
            this.myDocument.replaceString(start2, end, newValue);
            int newEnd = start2 + newValue.length();
            this.mySegments.replaceSegmentAt(segmentNumber, start2, newEnd);
            this.mySegments.setNeighboursGreedy(segmentNumber, true);
            this.fixOverlappedSegments(segmentNumber);
        }
    }

    public int getCurrentVariableNumber() {
        return this.myCurrentVariableNumber;
    }

    public void previousTab() {
        if (this.isFinished()) {
            return;
        }
        this.myDocumentChangesTerminateTemplate = false;
        int oldVar = this.myCurrentVariableNumber;
        int previousVariableNumber = this.getPreviousVariableNumber(oldVar);
        if (previousVariableNumber >= 0) {
            this.focusCurrentHighlighter(false);
            this.calcResults(false);
            this.doReformat();
            this.setCurrentVariableNumber(previousVariableNumber);
            this.focusCurrentExpression();
            this.currentVariableChanged(oldVar);
        }
    }

    public void nextTab() {
        if (this.isFinished()) {
            return;
        }
        this.unblockDocument();
        this.myDocumentChangesTerminateTemplate = false;
        int oldVar = this.myCurrentVariableNumber;
        int nextVariableNumber = this.getNextVariableNumber(oldVar);
        if (nextVariableNumber == -1) {
            this.calcResults(false);
            ApplicationManager.getApplication().runWriteAction(() -> this.reformat());
            this.finishTemplateEditing();
            return;
        }
        this.focusCurrentHighlighter(false);
        this.calcResults(false);
        this.doReformat();
        this.setCurrentVariableNumber(nextVariableNumber);
        this.focusCurrentExpression();
        this.currentVariableChanged(oldVar);
    }

    public void considerNextTabOnLookupItemSelected(LookupElement item) {
        TextRange range2;
        if (this.isFinished()) {
            return;
        }
        if (item != null) {
            ExpressionContext context = this.getCurrentExpressionContext();
            for (TemplateCompletionProcessor processor2 : TemplateCompletionProcessor.EP_NAME.getExtensionList()) {
                if (processor2.nextTabOnItemSelected(context, item)) continue;
                return;
            }
        }
        if ((range2 = this.getCurrentVariableRange()) != null && range2.getLength() > 0) {
            int caret = this.myEditor.getCaretModel().getOffset();
            if (caret == range2.getEndOffset() || this.isCaretInsideOrBeforeNextVariable()) {
                this.nextTab();
            } else if (caret > range2.getEndOffset()) {
                this.gotoEnd(true);
            }
        }
    }

    private void lockSegmentAtTheSameOffsetIfAny() {
        this.mySegments.lockSegmentAtTheSameOffsetIfAny(this.getCurrentSegmentNumber());
    }

    private ExpressionContext createExpressionContext(final int start2) {
        return new ExpressionContext(){

            @Override
            public Project getProject() {
                return TemplateState.this.myProject;
            }

            @Override
            public Editor getEditor() {
                return TemplateState.this.myEditor;
            }

            @Override
            public int getStartOffset() {
                return start2;
            }

            @Override
            public int getTemplateStartOffset() {
                if (TemplateState.this.myTemplateRange == null) {
                    return -1;
                }
                return TemplateState.this.myTemplateRange.getStartOffset();
            }

            @Override
            public int getTemplateEndOffset() {
                if (TemplateState.this.myTemplateRange == null) {
                    return -1;
                }
                return TemplateState.this.myTemplateRange.getEndOffset();
            }

            @Override
            public <T> T getProperty(Key<T> key) {
                return (T)TemplateState.this.myProperties.get(key);
            }

            @Override
            @Nullable
            public PsiElement getPsiElementAtStartOffset() {
                Project project2 = this.getProject();
                int templateStartOffset = this.getTemplateStartOffset();
                int offset = templateStartOffset > 0 ? this.getTemplateStartOffset() - 1 : this.getTemplateStartOffset();
                PsiDocumentManager.getInstance(project2).commitAllDocuments();
                Editor editor = this.getEditor();
                if (editor == null) {
                    return null;
                }
                PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
                return file2 == null ? null : file2.findElementAt(offset);
            }
        };
    }

    public void gotoEnd(boolean brokenOff) {
        if (this.isDisposed()) {
            return;
        }
        LookupManager.getInstance(this.myProject).hideActiveLookup();
        if (!this.mySegments.isInvalid()) {
            this.calcResults(false);
        }
        if (!brokenOff) {
            this.doReformat();
        }
        this.setFinalEditorState(brokenOff);
        this.cleanupTemplateState(brokenOff);
    }

    public void gotoEnd() {
        this.gotoEnd(true);
    }

    private void finishTemplateEditing() {
        if (this.isDisposed()) {
            return;
        }
        LookupManager.getInstance(this.myProject).hideActiveLookup();
        this.setFinalEditorState(false);
        this.cleanupTemplateState(false);
    }

    private void setFinalEditorState(boolean brokenOff) {
        if (this.isDisposed()) {
            return;
        }
        this.myEditor.getSelectionModel().removeSelection();
        if (brokenOff && !((TemplateManagerImpl)TemplateManager.getInstance(this.myProject)).shouldSkipInTests()) {
            return;
        }
        int selectionSegment = this.myTemplate.getVariableSegmentNumber("SELECTION");
        int endSegmentNumber = selectionSegment >= 0 && this.getSelectionBeforeTemplate() == null ? selectionSegment : this.myTemplate.getEndSegmentNumber();
        int offset = -1;
        if (endSegmentNumber >= 0) {
            offset = this.mySegments.getSegmentStart(endSegmentNumber);
        } else if (!this.myTemplate.isSelectionTemplate() && !this.myTemplate.isInline()) {
            offset = this.myTemplateRange.getEndOffset();
        }
        if (this.isMultiCaretMode() && this.getCurrentVariableNumber() > -1) {
            offset = -1;
        }
        if (offset >= 0) {
            this.myEditor.getCaretModel().moveToOffset(offset);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        int selStart = this.myTemplate.getSelectionStartSegmentNumber();
        int selEnd = this.myTemplate.getSelectionEndSegmentNumber();
        if (selStart >= 0 && selEnd >= 0) {
            this.myEditor.getSelectionModel().setSelection(this.mySegments.getSegmentStart(selStart), this.mySegments.getSegmentStart(selEnd));
        }
    }

    boolean isDisposed() {
        return this.myDocument == null;
    }

    private void cleanupTemplateState(boolean brokenOff) {
        Editor editor = this.myEditor;
        this.fireBeforeTemplateFinished(brokenOff);
        if (!this.isDisposed()) {
            int oldVar = this.myCurrentVariableNumber;
            this.setCurrentVariableNumber(-1);
            this.currentVariableChanged(oldVar);
            TemplateManagerImpl.clearTemplateState(editor);
            this.fireTemplateFinished(brokenOff);
        }
        this.myListeners.clear();
        Disposer.dispose(this);
    }

    private int getNextVariableNumber(int currentVariableNumber) {
        for (int i = currentVariableNumber + 1; i < this.myTemplate.getVariableCount(); ++i) {
            if (!this.checkIfTabStop(i)) continue;
            return i;
        }
        return -1;
    }

    private int getPreviousVariableNumber(int currentVariableNumber) {
        for (int i = currentVariableNumber - 1; i >= 0; --i) {
            if (!this.checkIfTabStop(i)) continue;
            return i;
        }
        return -1;
    }

    private boolean checkIfTabStop(int currentVariableNumber) {
        Expression expression = this.myTemplate.getExpressionAt(currentVariableNumber);
        if (this.myCurrentVariableNumber == -1 && this.myTemplate.skipOnStart(currentVariableNumber)) {
            return false;
        }
        String variableName = this.myTemplate.getVariableNameAt(currentVariableNumber);
        if ((this.myPredefinedVariableValues == null || !this.myPredefinedVariableValues.containsKey(variableName)) && this.myTemplate.isAlwaysStopAt(currentVariableNumber)) {
            return true;
        }
        int segmentNumber = this.myTemplate.getVariableSegmentNumber(variableName);
        if (segmentNumber < 0) {
            return false;
        }
        int start2 = this.mySegments.getSegmentStart(segmentNumber);
        ExpressionContext context = this.createExpressionContext(start2);
        Result result2 = expression.calculateResult(context);
        if (result2 == null) {
            return true;
        }
        LookupElement[] items = expression.calculateLookupItems(context);
        return items != null && items.length > 1;
    }

    private IntArrayList initEmptyVariables() {
        int endSegmentNumber = this.myTemplate.getEndSegmentNumber();
        int selStart = this.myTemplate.getSelectionStartSegmentNumber();
        int selEnd = this.myTemplate.getSelectionEndSegmentNumber();
        IntArrayList indices = new IntArrayList();
        ArrayList<TemplateDocumentChange> changes = new ArrayList<TemplateDocumentChange>();
        block0: for (int i = 0; i < this.myTemplate.getSegmentsCount(); ++i) {
            int length = this.mySegments.getSegmentEnd(i) - this.mySegments.getSegmentStart(i);
            if (length != 0 || i == endSegmentNumber || i == selStart || i == selEnd) continue;
            String name = this.myTemplate.getSegmentName(i);
            for (int j = 0; j < this.myTemplate.getVariableCount(); ++j) {
                if (!this.myTemplate.getVariableNameAt(j).equals(name)) continue;
                Expression e = this.myTemplate.getExpressionAt(j);
                String marker = "a";
                if (e instanceof MacroCallNode) {
                    marker = ((MacroCallNode)e).getMacro().getDefaultValue();
                }
                changes.add(new TemplateDocumentChange(marker, this.mySegments.getSegmentStart(i), this.mySegments.getSegmentEnd(i), i));
                indices.add(i);
                continue block0;
            }
        }
        this.executeChanges(changes);
        return indices;
    }

    private void restoreEmptyVariables(IntArrayList indices) {
        ArrayList<TextRange> rangesToRemove = new ArrayList<TextRange>();
        for (int i = 0; i < indices.size(); ++i) {
            int index = indices.get(i);
            rangesToRemove.add(TextRange.create(this.mySegments.getSegmentStart(index), this.mySegments.getSegmentEnd(index)));
        }
        Collections.sort(rangesToRemove, (o1, o2) -> {
            int startDiff = o2.getStartOffset() - o1.getStartOffset();
            return startDiff != 0 ? startDiff : o2.getEndOffset() - o1.getEndOffset();
        });
        DocumentUtil.executeInBulk(this.myDocument, true, () -> {
            if (this.isDisposed()) {
                return;
            }
            for (TextRange range2 : rangesToRemove) {
                this.myDocument.deleteString(range2.getStartOffset(), range2.getEndOffset());
            }
        });
    }

    private void initTabStopHighlighters() {
        HashSet<String> vars = new HashSet<String>();
        for (int i = 0; i < this.myTemplate.getVariableCount(); ++i) {
            int segmentNumber;
            String variableName = this.myTemplate.getVariableNameAt(i);
            if (!vars.add(variableName) || (segmentNumber = this.myTemplate.getVariableSegmentNumber(variableName)) < 0) continue;
            RangeHighlighter segmentHighlighter = this.getSegmentHighlighter(segmentNumber, false, false);
            this.myTabStopHighlighters.add(segmentHighlighter);
        }
        int endSegmentNumber = this.myTemplate.getEndSegmentNumber();
        if (endSegmentNumber >= 0) {
            RangeHighlighter segmentHighlighter = this.getSegmentHighlighter(endSegmentNumber, false, true);
            this.myTabStopHighlighters.add(segmentHighlighter);
        }
    }

    private RangeHighlighter getSegmentHighlighter(int segmentNumber, boolean isSelected, boolean isEnd) {
        TextAttributes lvAttr = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.LIVE_TEMPLATE_ATTRIBUTES);
        TextAttributes attributes = isSelected ? lvAttr : new TextAttributes();
        TextAttributes endAttributes = new TextAttributes();
        int start2 = this.mySegments.getSegmentStart(segmentNumber);
        int end = this.mySegments.getSegmentEnd(segmentNumber);
        RangeHighlighter segmentHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(start2, end, 6001, isEnd ? endAttributes : attributes, HighlighterTargetArea.EXACT_RANGE);
        segmentHighlighter.setGreedyToLeft(true);
        segmentHighlighter.setGreedyToRight(true);
        return segmentHighlighter;
    }

    private void focusCurrentHighlighter(boolean toSelect2) {
        if (this.isFinished()) {
            return;
        }
        if (this.myCurrentVariableNumber >= this.myTabStopHighlighters.size()) {
            return;
        }
        RangeHighlighter segmentHighlighter = this.myTabStopHighlighters.get(this.myCurrentVariableNumber);
        if (segmentHighlighter != null) {
            int segmentNumber = this.getCurrentSegmentNumber();
            RangeHighlighter newSegmentHighlighter = this.getSegmentHighlighter(segmentNumber, toSelect2, false);
            segmentHighlighter.dispose();
            this.myTabStopHighlighters.set(this.myCurrentVariableNumber, newSegmentHighlighter);
        }
    }

    private void reformat() {
        PsiFile file2 = this.getPsiFile();
        if (file2 != null) {
            CodeStyleManager style = CodeStyleManager.getInstance(this.myProject);
            for (TemplateOptionalProcessor processor2 : DumbService.getDumbAwareExtensions(this.myProject, TemplateOptionalProcessor.EP_NAME)) {
                try {
                    processor2.processText(this.myProject, this.myTemplate, this.myDocument, this.myTemplateRange, this.myEditor);
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e);
                }
            }
            PsiDocumentManager.getInstance(this.myProject).doPostponedOperationsAndUnblockDocument(this.myDocument);
            if (this.myTemplate.isToIndent() && !this.myTemplateIndented) {
                LOG.assertTrue(this.myTemplateRange.isValid(), TemplateState.presentTemplate(this.myTemplate));
                this.smartIndent(this.myTemplateRange.getStartOffset(), this.myTemplateRange.getEndOffset());
                this.myTemplateIndented = true;
            }
            if (this.myTemplate.isToReformat()) {
                try {
                    PsiElement whiteSpaceElement;
                    TextRange range2;
                    int endSegmentNumber = this.myTemplate.getEndSegmentNumber();
                    PsiDocumentManager.getInstance(this.myProject).commitDocument(this.myDocument);
                    RangeMarker dummyAdjustLineMarkerRange = null;
                    int endVarOffset = -1;
                    if (endSegmentNumber >= 0 && (range2 = CodeStyleManagerImpl.insertNewLineIndentMarker(file2, this.myDocument, endVarOffset = this.mySegments.getSegmentStart(endSegmentNumber))) != null) {
                        dummyAdjustLineMarkerRange = this.myDocument.createRangeMarker(range2);
                    }
                    int reformatStartOffset = this.myTemplateRange.getStartOffset();
                    int reformatEndOffset = this.myTemplateRange.getEndOffset();
                    if (dummyAdjustLineMarkerRange == null && endVarOffset >= 0 && (whiteSpaceElement = CodeStyleManagerImpl.findWhiteSpaceNode(file2, endVarOffset)) != null) {
                        TextRange whiteSpaceRange = whiteSpaceElement.getTextRange();
                        if (whiteSpaceElement.getContainingFile() != null) {
                            whiteSpaceRange = InjectedLanguageManager.getInstance(file2.getProject()).injectedToHost(whiteSpaceElement, whiteSpaceRange);
                        }
                        reformatStartOffset = Math.min(reformatStartOffset, whiteSpaceRange.getStartOffset());
                        reformatEndOffset = Math.max(reformatEndOffset, whiteSpaceRange.getEndOffset());
                    }
                    style.reformatText(file2, reformatStartOffset, reformatEndOffset);
                    this.unblockDocument();
                    if (dummyAdjustLineMarkerRange != null && dummyAdjustLineMarkerRange.isValid()) {
                        this.mySegments.replaceSegmentAt(endSegmentNumber, dummyAdjustLineMarkerRange.getStartOffset(), dummyAdjustLineMarkerRange.getEndOffset());
                        this.myDocument.deleteString(dummyAdjustLineMarkerRange.getStartOffset(), dummyAdjustLineMarkerRange.getEndOffset());
                        PsiDocumentManager.getInstance(this.myProject).commitDocument(this.myDocument);
                    }
                    if (endSegmentNumber >= 0) {
                        int offset = this.mySegments.getSegmentStart(endSegmentNumber);
                        int lineStart = this.myDocument.getLineStartOffset(this.myDocument.getLineNumber(offset));
                        if (this.myDocument.getCharsSequence().subSequence(lineStart, offset).toString().trim().isEmpty()) {
                            int adjustedOffset = style.adjustLineIndent(file2, offset);
                            this.mySegments.replaceSegmentAt(endSegmentNumber, adjustedOffset, adjustedOffset);
                        }
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e);
                }
            }
        }
    }

    private void smartIndent(int startOffset, int endOffset) {
        char ch;
        int indentLineNum;
        int startLineNum = this.myDocument.getLineNumber(startOffset);
        int endLineNum = this.myDocument.getLineNumber(endOffset);
        if (endLineNum == startLineNum) {
            return;
        }
        int selectionIndent = -1;
        int selectionStartLine = -1;
        int selectionEndLine = -1;
        int selectionSegment = this.myTemplate.getVariableSegmentNumber("SELECTION");
        if (selectionSegment >= 0) {
            selectionIndent = 0;
            String templateText = this.myTemplate.getTemplateText();
            for (int selectionStart = this.myTemplate.getSegmentOffset(selectionSegment); selectionStart > 0 && templateText.charAt(selectionStart - 1) == ' '; --selectionStart) {
                ++selectionIndent;
            }
            selectionStartLine = this.myDocument.getLineNumber(this.mySegments.getSegmentStart(selectionSegment));
            selectionEndLine = this.myDocument.getLineNumber(this.mySegments.getSegmentEnd(selectionSegment));
        }
        int lineLength = 0;
        for (indentLineNum = startLineNum; indentLineNum >= 0 && (lineLength = this.myDocument.getLineEndOffset(indentLineNum) - this.myDocument.getLineStartOffset(indentLineNum)) <= 0; --indentLineNum) {
        }
        if (indentLineNum < 0) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        CharSequence text2 = this.myDocument.getCharsSequence();
        for (int i = 0; i < lineLength && ((ch = text2.charAt(this.myDocument.getLineStartOffset(indentLineNum) + i)) == ' ' || ch == '\t'); ++i) {
            buffer.append(ch);
        }
        if (buffer.length() == 0 && selectionIndent <= 0 || startLineNum >= endLineNum) {
            return;
        }
        String stringToInsert = buffer.toString();
        int finalSelectionStartLine = selectionStartLine;
        int finalSelectionEndLine = selectionEndLine;
        int finalSelectionIndent = selectionIndent;
        DocumentUtil.executeInBulk(this.myDocument, true, () -> {
            for (int i = startLineNum + 1; i <= endLineNum; ++i) {
                if (i > finalSelectionStartLine && i <= finalSelectionEndLine) {
                    this.myDocument.insertString(this.myDocument.getLineStartOffset(i), StringUtil.repeatSymbol(' ', finalSelectionIndent));
                    continue;
                }
                this.myDocument.insertString(this.myDocument.getLineStartOffset(i), stringToInsert);
            }
        });
    }

    public void addTemplateStateListener(TemplateEditingListener listener2) {
        this.myListeners.add(listener2);
    }

    private void fireTemplateFinished(boolean brokenOff) {
        if (this.myFinished) {
            return;
        }
        this.myFinished = true;
        for (TemplateEditingListener listener2 : this.myListeners) {
            listener2.templateFinished(ObjectUtils.chooseNotNull(this.myTemplate, this.myPrevTemplate), brokenOff);
        }
    }

    private void fireBeforeTemplateFinished(boolean brokenOff) {
        for (TemplateEditingListener listener2 : this.myListeners) {
            listener2.beforeTemplateFinished(this, this.myTemplate, brokenOff);
        }
    }

    private void fireWaitingForInput() {
        for (TemplateEditingListener listener2 : this.myListeners) {
            listener2.waitingForInput(this.myTemplate);
        }
    }

    private void currentVariableChanged(int oldIndex) {
        for (TemplateEditingListener listener2 : this.myListeners) {
            listener2.currentVariableChanged(this, this.myTemplate, oldIndex, this.myCurrentVariableNumber);
        }
        if (this.myCurrentSegmentNumber < 0) {
            if (this.myCurrentVariableNumber >= 0) {
                LOG.error("A variable with no segment: " + this.myCurrentVariableNumber + "; " + TemplateState.presentTemplate(this.myTemplate));
            }
            Disposer.dispose(this);
        }
    }

    public Map getProperties() {
        return this.myProperties;
    }

    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateState";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupFocusDegree";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteTemplate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExpressionLookupItems";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installCaretListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariableValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "substituteTemplate";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processAllExpressions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runLookup";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyBasicUndoableAction
    extends BasicUndoableAction
    implements Disposable {
        @Nullable
        private TemplateState myTemplateState;

        private MyBasicUndoableAction(@NotNull TemplateState templateState, @Nullable Document document) {
            DocumentReference[] documentReferenceArray;
            if (templateState == null) {
                MyBasicUndoableAction.$$$reportNull$$$0(0);
            }
            if (document != null) {
                DocumentReference[] documentReferenceArray2 = new DocumentReference[1];
                documentReferenceArray = documentReferenceArray2;
                documentReferenceArray2[0] = DocumentReferenceManager.getInstance().create(document);
            } else {
                documentReferenceArray = null;
            }
            super(documentReferenceArray);
            this.myTemplateState = templateState;
        }

        @Override
        public void undo() {
            if (this.myTemplateState != null) {
                this.myTemplateState.fireTemplateCancelled();
                LookupManager.getInstance(this.myTemplateState.myProject).hideActiveLookup();
                int oldVar = this.myTemplateState.getCurrentVariableNumber();
                this.myTemplateState.setCurrentVariableNumber(-1);
                this.myTemplateState.currentVariableChanged(oldVar);
            }
        }

        @Override
        public void redo() {
        }

        @Override
        public void dispose() {
            this.myTemplateState = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateState", "com/intellij/codeInsight/template/impl/TemplateState$MyBasicUndoableAction", "<init>"));
        }
    }

    private static class TemplateDocumentChange {
        public final String newValue;
        public final int startOffset;
        public final int endOffset;
        public final int segmentNumber;

        private TemplateDocumentChange(String newValue, int startOffset, int endOffset, int segmentNumber) {
            this.newValue = newValue;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.segmentNumber = segmentNumber;
        }
    }
}

