/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.InvokeActionResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseCompleteMacro
extends Macro {
    private final String myName;
    private final boolean myCheckCompletionChar;

    protected BaseCompleteMacro(@NonNls String name) {
        this(name, true);
    }

    protected BaseCompleteMacro(@NonNls String name, boolean checkCompletionChar) {
        this.myName = name;
        this.myCheckCompletionChar = checkCompletionChar;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getPresentableName() {
        return this.myName + "()";
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        return "a";
    }

    @Override
    public final Result calculateResult(Expression @NotNull [] params, ExpressionContext context) {
        if (params == null) {
            BaseCompleteMacro.$$$reportNull$$$0(0);
        }
        return new InvokeActionResult(() -> this.invokeCompletion(context));
    }

    private void invokeCompletion(ExpressionContext context) {
        Project project2 = context.getProject();
        Editor editor = context.getEditor();
        PsiFile psiFile = editor != null ? PsiUtilBase.getPsiFileInEditor(editor, project2) : null;
        Runnable runnable2 = () -> {
            if (project2.isDisposed() || editor == null || editor.isDisposed() || psiFile == null || !psiFile.isValid()) {
                return;
            }
            if (CompletionServiceImpl.getCompletionService().getCurrentCompletion() != null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                this.invokeCompletionHandler(project2, editor);
                LookupEx lookup2 = LookupManager.getInstance(project2).getActiveLookup();
                if (lookup2 != null) {
                    lookup2.addLookupListener(new MyLookupListener(context, this.myCheckCompletionChar));
                }
            }, "", null);
        };
        ApplicationManager.getApplication().invokeLater(runnable2);
    }

    protected abstract void invokeCompletionHandler(Project var1, Editor var2);

    public static void waitForNextTab() {
        UIUtil.dispatchAllInvocationEvents();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/BaseCompleteMacro", "calculateResult"));
    }

    private static class MyLookupListener
    implements LookupListener {
        private final ExpressionContext myContext;
        private final boolean myCheckCompletionChar;

        MyLookupListener(@NotNull ExpressionContext context, boolean checkCompletionChar) {
            if (context == null) {
                MyLookupListener.$$$reportNull$$$0(0);
            }
            this.myContext = context;
            this.myCheckCompletionChar = checkCompletionChar;
        }

        @Override
        public void itemSelected(@NotNull LookupEvent event) {
            LookupElement item;
            if (event == null) {
                MyLookupListener.$$$reportNull$$$0(1);
            }
            if ((item = event.getItem()) == null) {
                return;
            }
            char c = event.getCompletionChar();
            if (this.myCheckCompletionChar && !LookupEvent.isSpecialCompletionChar(c)) {
                return;
            }
            Project project2 = this.myContext.getProject();
            if (project2 == null) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction(project2, () -> {
                TemplateState templateState;
                Editor editor = this.myContext.getEditor();
                if (editor != null && (templateState = TemplateManagerImpl.getTemplateState(editor)) != null) {
                    templateState.considerNextTabOnLookupItemSelected(item);
                }
            }), ModalityState.current(), project2.getDisposed());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/template/macro/BaseCompleteMacro$MyLookupListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "itemSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

