/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.macro.SimpleMacro;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Clock;
import com.intellij.util.text.DateFormatUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CurrentDateMacro
extends SimpleMacro {
    private static final Logger LOG = Logger.getInstance(CurrentDateMacro.class);

    protected CurrentDateMacro() {
        super("date");
    }

    @Override
    protected String evaluateSimpleMacro(Expression[] params, ExpressionContext context) {
        return CurrentDateMacro.formatUserDefined(params, context, true);
    }

    static String formatUserDefined(Expression[] params, ExpressionContext context, boolean date) {
        Result format;
        long time = Clock.getTime();
        if (params.length == 1 && (format = params[0].calculateResult(context)) != null) {
            String pattern = format.toString();
            try {
                return new SimpleDateFormat(pattern).format(new Date(time));
            }
            catch (Exception e) {
                return "Problem when formatting date/time for pattern \"" + pattern + "\": " + e.getMessage();
            }
        }
        return date ? DateFormatUtil.formatDate(time) : DateFormatUtil.formatTime(time);
    }
}

