/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.intention.impl.config.ActionUsagePanel;
import com.intellij.codeInsight.intention.impl.config.BeforeAfterMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionDescriptionPanel;
import com.intellij.codeInsight.intention.impl.config.PlainTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateMetaData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HintHint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PostfixDescriptionPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance(IntentionDescriptionPanel.class);
    private JPanel myPanel;
    private JPanel myAfterPanel;
    private JPanel myBeforePanel;
    private JEditorPane myDescriptionBrowser;
    private JBLabel myDescriptionLabel;
    private JBLabel myBeforeLabel;
    private JBLabel myAfterLabel;

    PostfixDescriptionPanel() {
        this.$$$setupUI$$$();
        this.myDescriptionBrowser.setMargin(JBUI.insets(5));
        this.initializeExamplePanel(this.myAfterPanel);
        this.initializeExamplePanel(this.myBeforePanel);
        this.myDescriptionLabel.setBorder(JBUI.Borders.emptyBottom(3));
        this.myBeforeLabel.setBorder(JBUI.Borders.empty(7, 0, 3, 0));
        this.myAfterLabel.setBorder(JBUI.Borders.empty(7, 0, 3, 0));
    }

    public void reset(@NotNull BeforeAfterMetaData actionMetaData) {
        if (actionMetaData == null) {
            PostfixDescriptionPanel.$$$reportNull$$$0(0);
        }
        boolean isEmpty = actionMetaData == PostfixTemplateMetaData.EMPTY_METADATA;
        this.readHtml(actionMetaData, isEmpty);
        PostfixDescriptionPanel.showUsages(this.myBeforePanel, isEmpty ? new PlainTextDescriptor(CodeInsightBundle.message("templates.postfix.settings.category.before", new Object[0]), "before.txt.template") : ArrayUtil.getFirstElement(actionMetaData.getExampleUsagesBefore()));
        PostfixDescriptionPanel.showUsages(this.myAfterPanel, isEmpty ? new PlainTextDescriptor(CodeInsightBundle.message("templates.postfix.settings.category.after", new Object[0]), "after.txt.template") : ArrayUtil.getFirstElement(actionMetaData.getExampleUsagesAfter()));
    }

    private void readHtml(@NotNull BeforeAfterMetaData actionMetaData, boolean isEmpty) {
        if (actionMetaData == null) {
            PostfixDescriptionPanel.$$$reportNull$$$0(1);
        }
        HintHint hintHint = new HintHint(this.myDescriptionBrowser, new Point(0, 0));
        hintHint.setFont(StartupUiUtil.getLabelFont());
        String description = isEmpty ? CodeInsightBundle.message("templates.postfix.settings.category.text", new Object[0]) : PostfixDescriptionPanel.getDescription(actionMetaData.getDescription());
        try {
            this.myDescriptionBrowser.read(new StringReader(HintUtil.prepareHintText(description, hintHint)), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static String getDescription(TextDescriptor url) {
        String string;
        try {
            string = url.getText();
        }
        catch (IOException e) {
            LOG.error(e);
            return "";
        }
        if (string == null) {
            PostfixDescriptionPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void showUsages(@NotNull JPanel panel2, @Nullable TextDescriptor exampleUsage) {
        if (panel2 == null) {
            PostfixDescriptionPanel.$$$reportNull$$$0(3);
        }
        String text2 = "";
        FileType fileType = PlainTextFileType.INSTANCE;
        if (exampleUsage != null) {
            try {
                text2 = exampleUsage.getText();
                String name = exampleUsage.getFileName();
                FileTypeManagerEx fileTypeManager = FileTypeManagerEx.getInstanceEx();
                String extension = fileTypeManager.getExtension(name);
                fileType = fileTypeManager.getFileTypeByExtension(extension);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
        ((ActionUsagePanel)panel2.getComponent(0)).reset(text2, fileType);
        panel2.repaint();
    }

    private void initializeExamplePanel(@NotNull JPanel panel2) {
        if (panel2 == null) {
            PostfixDescriptionPanel.$$$reportNull$$$0(4);
        }
        panel2.setLayout(new BorderLayout());
        ActionUsagePanel actionUsagePanel = new ActionUsagePanel();
        panel2.add(actionUsagePanel);
        Disposer.register(this, actionUsagePanel);
    }

    synchronized JPanel getComponent() {
        return this.myPanel;
    }

    @Override
    public void dispose() {
    }

    public void resetHeights(int preferredWidth) {
        double height = (this.myDescriptionBrowser.getSize().getHeight() + this.myBeforePanel.getSize().getHeight() + this.myAfterPanel.getSize().getHeight()) / 3.0;
        if (height == 0.0) {
            return;
        }
        Dimension newd = new Dimension(preferredWidth, (int)height);
        this.myDescriptionBrowser.setSize(newd);
        this.myDescriptionBrowser.setPreferredSize(newd);
        this.myDescriptionBrowser.setMaximumSize(newd);
        this.myDescriptionBrowser.setMinimumSize(newd);
        this.myBeforePanel.setSize(newd);
        this.myBeforePanel.setPreferredSize(newd);
        this.myBeforePanel.setMaximumSize(newd);
        this.myBeforePanel.setMinimumSize(newd);
        this.myAfterPanel.setSize(newd);
        this.myAfterPanel.setPreferredSize(newd);
        this.myAfterPanel.setMaximumSize(newd);
        this.myAfterPanel.setMinimumSize(newd);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JEditorPane jEditorPane;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAfterPanel = jPanel2 = new JPanel();
        jPanel4.add((Component)jPanel2, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 60), null, null));
        this.myBeforePanel = jPanel = new JPanel();
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 60), null, null));
        this.myBeforeLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$(jBLabel3, DynamicBundle.getBundle("messages/CodeInsightBundle", PostfixDescriptionPanel.class).getString("settings.postfix.completion.before"));
        jPanel4.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myAfterLabel = jBLabel2 = new JBLabel();
        jBLabel2.setAlignmentY(0.2f);
        this.$$$loadLabelText$$$(jBLabel2, DynamicBundle.getBundle("messages/CodeInsightBundle", PostfixDescriptionPanel.class).getString("settings.postfix.completion.after"));
        jPanel4.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myDescriptionBrowser = jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jBScrollPane.setViewportView(jEditorPane);
        this.myDescriptionLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$(jBLabel, DynamicBundle.getBundle("messages/CodeInsightBundle", PostfixDescriptionPanel.class).getString("settings.postfix.completion.description"));
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionMetaData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixDescriptionPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixDescriptionPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readHtml";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initializeExamplePanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

