/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.settings.PostfixEditTemplateDialog;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateCheckedTreeNode;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.template.postfix.templates.editable.DefaultPostfixTemplateEditor;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixChangedBuiltinTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateEditor;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixTemplatesCheckboxTree
extends CheckboxTree
implements Disposable {
    private static final Factory<Set<PostfixTemplateCheckedTreeNode>> myNodesComparator = () -> new TreeSet((o1, o2) -> {
        PostfixTemplate template1 = o1.getTemplate();
        PostfixTemplate template2 = o2.getTemplate();
        int compare = Comparing.compare(template1.getPresentableName(), template2.getPresentableName());
        return compare != 0 ? compare : Comparing.compare(template1.getId(), template2.getId());
    });
    @NotNull
    private final CheckedTreeNode myRoot;
    @NotNull
    private final DefaultTreeModel myModel = (DefaultTreeModel)this.getModel();

    public PostfixTemplatesCheckboxTree() {
        super(PostfixTemplatesCheckboxTree.getRenderer(), new CheckedTreeNode(null));
        this.myRoot = (CheckedTreeNode)this.myModel.getRoot();
        TreeSelectionListener selectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                PostfixTemplatesCheckboxTree.this.selectionChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree$1", "valueChanged"));
            }
        };
        this.getSelectionModel().addTreeSelectionListener(selectionListener);
        Disposer.register(this, () -> this.getSelectionModel().removeTreeSelectionListener(selectionListener));
        DoubleClickListener doubleClickListener = new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(MouseEvent event) {
                TreePath location2 = PostfixTemplatesCheckboxTree.this.getClosestPathForLocation(event.getX(), event.getY());
                return location2 != null && PostfixTemplatesCheckboxTree.this.doubleClick(location2.getLastPathComponent());
            }
        };
        doubleClickListener.installOn(this);
        Disposer.register(this, () -> doubleClickListener.uninstall(this));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    @Override
    protected void onDoubleClick(CheckedTreeNode node) {
        this.doubleClick(node);
    }

    private boolean doubleClick(@Nullable Object node) {
        if (node instanceof PostfixTemplateCheckedTreeNode && PostfixTemplatesCheckboxTree.isEditable(((PostfixTemplateCheckedTreeNode)node).getTemplate())) {
            this.editTemplate((PostfixTemplateCheckedTreeNode)node);
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        UIUtil.dispose(this);
    }

    @NotNull
    private static CheckboxTree.CheckboxTreeCellRenderer getRenderer() {
        return new CheckboxTree.CheckboxTreeCellRenderer(){

            @Override
            public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                String example;
                SimpleTextAttributes attributes;
                if (!(value2 instanceof CheckedTreeNode)) {
                    return;
                }
                CheckedTreeNode node = (CheckedTreeNode)value2;
                Color background = UIUtil.getTreeBackground(selected2, true);
                PostfixTemplateCheckedTreeNode templateNode = ObjectUtils.tryCast(node, PostfixTemplateCheckedTreeNode.class);
                if (templateNode != null) {
                    JBColor fgColor = templateNode.isChanged() || templateNode.isNew() ? JBColor.BLUE : null;
                    attributes = new SimpleTextAttributes(0, (Color)fgColor);
                } else {
                    attributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                }
                this.getTextRenderer().append(StringUtil.notNullize(value2.toString()), new SimpleTextAttributes(background, attributes.getFgColor(), (Color)JBColor.RED, attributes.getStyle()));
                if (templateNode != null && StringUtil.isNotEmpty(example = templateNode.getTemplate().getExample())) {
                    this.getTextRenderer().append("  " + example, new SimpleTextAttributes(128, (Color)JBColor.GRAY), false);
                }
            }
        };
    }

    protected void selectionChanged() {
    }

    public void initTree(@NotNull MultiMap<PostfixTemplateProvider, PostfixTemplate> providerToTemplates) {
        if (providerToTemplates == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(0);
        }
        this.myRoot.removeAllChildren();
        HashMap languageToNodes = new HashMap();
        for (Map.Entry<PostfixTemplateProvider, Collection<PostfixTemplate>> entry : providerToTemplates.entrySet()) {
            PostfixTemplateProvider provider = entry.getKey();
            String languageId = PostfixTemplatesCheckboxTree.getProvidersToLanguages().get(provider);
            Set<PostfixTemplateCheckedTreeNode> nodes = ContainerUtil.getOrCreate(languageToNodes, languageId, myNodesComparator);
            for (PostfixTemplate template : entry.getValue()) {
                nodes.add(new PostfixTemplateCheckedTreeNode(template, provider, false));
            }
        }
        for (Map.Entry<PostfixTemplateProvider, Collection<PostfixTemplate>> entry : languageToNodes.entrySet()) {
            DefaultMutableTreeNode languageNode = this.findOrCreateLanguageNode((String)((Object)entry.getKey()));
            for (PostfixTemplateCheckedTreeNode node : (Set)entry.getValue()) {
                languageNode.add(new PostfixTemplateCheckedTreeNode(node.getTemplate(), node.getTemplateProvider(), false));
            }
        }
        this.myModel.nodeStructureChanged(this.myRoot);
        TreeUtil.expandAll(this);
    }

    @Nullable
    public PostfixTemplate getSelectedTemplate() {
        TreePath path2 = this.getSelectionModel().getSelectionPath();
        return PostfixTemplatesCheckboxTree.getTemplateFromPath(path2);
    }

    @Nullable
    private static PostfixTemplate getTemplateFromPath(@Nullable TreePath path2) {
        if (path2 == null || !(path2.getLastPathComponent() instanceof PostfixTemplateCheckedTreeNode)) {
            return null;
        }
        return ((PostfixTemplateCheckedTreeNode)path2.getLastPathComponent()).getTemplate();
    }

    @NotNull
    public MultiMap<PostfixTemplateProvider, PostfixTemplate> getEditableTemplates() {
        MultiMap<PostfixTemplateProvider, PostfixTemplate> result2 = MultiMap.createSet();
        this.visitTemplateNodes(node -> {
            PostfixTemplate template = node.getTemplate();
            PostfixTemplateProvider provider = node.getTemplateProvider();
            if (PostfixTemplatesCheckboxTree.isEditable(template) && (!template.isBuiltin() || template instanceof PostfixChangedBuiltinTemplate)) {
                result2.putValue(provider, template);
            }
        });
        MultiMap<PostfixTemplateProvider, PostfixTemplate> multiMap = result2;
        if (multiMap == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    @NotNull
    public Map<String, Set<String>> getDisabledTemplatesState() {
        HashMap<String, Set<String>> result2 = new HashMap<String, Set<String>>();
        this.visitTemplateNodes(template -> {
            if (!template.isChecked()) {
                Set<String> templatesForProvider = ContainerUtil.getOrCreate(result2, template.getTemplateProvider().getId(), PostfixTemplatesSettings.SET_FACTORY);
                templatesForProvider.add(template.getTemplate().getId());
            }
        });
        HashMap<String, Set<String>> hashMap = result2;
        if (hashMap == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    public void setDisabledTemplatesState(@NotNull Map<String, Set<String>> providerToDisabledTemplates) {
        if (providerToDisabledTemplates == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(3);
        }
        TreeState treeState = TreeState.createOn((JTree)this, this.myRoot);
        this.visitTemplateNodes(template -> {
            Set disabledTemplates = (Set)providerToDisabledTemplates.get(template.getTemplateProvider().getId());
            String key = template.getTemplate().getId();
            if (disabledTemplates != null && disabledTemplates.contains(key)) {
                template.setChecked(false);
                return;
            }
            template.setChecked(true);
        });
        this.myModel.nodeStructureChanged(this.myRoot);
        treeState.applyTo(this);
        TreeUtil.expandAll(this);
    }

    public void selectTemplate(@NotNull PostfixTemplate postfixTemplate, @NotNull PostfixTemplateProvider provider) {
        if (postfixTemplate == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(4);
        }
        if (provider == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(5);
        }
        this.visitTemplateNodes(template -> {
            if (provider.getId().equals(template.getTemplateProvider().getId()) && postfixTemplate.getKey().equals(template.getTemplate().getKey())) {
                TreeUtil.selectInTree(template, true, this, true);
            }
        });
    }

    private void visitTemplateNodes(@NotNull Consumer<? super PostfixTemplateCheckedTreeNode> consumer) {
        if (consumer == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(6);
        }
        Enumeration<TreeNode> languages = this.myRoot.children();
        while (languages.hasMoreElements()) {
            CheckedTreeNode langNode = (CheckedTreeNode)languages.nextElement();
            Enumeration<TreeNode> templates = langNode.children();
            while (templates.hasMoreElements()) {
                TreeNode template = templates.nextElement();
                if (!(template instanceof PostfixTemplateCheckedTreeNode)) continue;
                consumer.consume((PostfixTemplateCheckedTreeNode)template);
            }
        }
    }

    public void addTemplate(@NotNull AnActionButton button2) {
        if (button2 == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(7);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        for (final Map.Entry<PostfixTemplateProvider, String> entry : PostfixTemplatesCheckboxTree.getProvidersToLanguages().entrySet()) {
            final PostfixTemplateProvider provider = entry.getKey();
            final String providerName = provider.getPresentableName();
            if (StringUtil.isEmpty(providerName)) continue;
            group.add(new DumbAwareAction(providerName){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    PostfixEditTemplateDialog dialog2;
                    PostfixTemplateEditor editor;
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if ((editor = provider.createEditor(null)) != null && (dialog2 = new PostfixEditTemplateDialog(PostfixTemplatesCheckboxTree.this, editor, providerName, null)).showAndGet()) {
                        String templateKey = dialog2.getTemplateName();
                        String templateId = PostfixTemplatesUtils.generateTemplateId(templateKey, provider);
                        PostfixTemplate createdTemplate = editor.createTemplate(templateId, templateKey);
                        PostfixTemplateCheckedTreeNode createdNode = new PostfixTemplateCheckedTreeNode(createdTemplate, provider, true);
                        DefaultMutableTreeNode languageNode = PostfixTemplatesCheckboxTree.this.findOrCreateLanguageNode((String)entry.getValue());
                        languageNode.add(createdNode);
                        PostfixTemplatesCheckboxTree.this.myModel.nodeStructureChanged(languageNode);
                        TreeUtil.selectNode(PostfixTemplatesCheckboxTree.this, createdNode);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree$4", "actionPerformed"));
                }
            });
        }
        DataContext context = DataManager.getInstance().getDataContext(button2.getContextComponent());
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true, null);
        popup2.show(Objects.requireNonNull(button2.getPreferredPopupPoint()));
    }

    public boolean canEditSelectedTemplate() {
        TreePath[] selectionPaths = this.getSelectionModel().getSelectionPaths();
        return (selectionPaths == null || selectionPaths.length <= 1) && PostfixTemplatesCheckboxTree.isEditable(this.getSelectedTemplate());
    }

    public void editSelectedTemplate() {
        TreePath path2 = this.getSelectionModel().getSelectionPath();
        Object lastPathComponent = path2.getLastPathComponent();
        if (lastPathComponent instanceof PostfixTemplateCheckedTreeNode) {
            this.editTemplate((PostfixTemplateCheckedTreeNode)lastPathComponent);
        }
    }

    private void editTemplate(@NotNull PostfixTemplateCheckedTreeNode lastPathComponent) {
        if (lastPathComponent == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(8);
        }
        PostfixTemplate template = lastPathComponent.getTemplate();
        PostfixTemplateProvider provider = lastPathComponent.getTemplateProvider();
        if (PostfixTemplatesCheckboxTree.isEditable(template)) {
            String providerName;
            PostfixEditTemplateDialog dialog2;
            PostfixTemplate templateToEdit = template instanceof PostfixChangedBuiltinTemplate ? ((PostfixChangedBuiltinTemplate)template).getDelegate() : template;
            PostfixTemplateEditor editor = provider.createEditor(templateToEdit);
            if (editor == null) {
                editor = new DefaultPostfixTemplateEditor(provider, templateToEdit);
            }
            if ((dialog2 = new PostfixEditTemplateDialog(this, editor, providerName = StringUtil.notNullize(provider.getPresentableName()), templateToEdit)).showAndGet()) {
                PostfixTemplate newTemplate = editor.createTemplate(template.getId(), dialog2.getTemplateName());
                if (newTemplate.equals(template)) {
                    return;
                }
                if (template.isBuiltin()) {
                    PostfixTemplate builtin = template instanceof PostfixChangedBuiltinTemplate ? ((PostfixChangedBuiltinTemplate)template).getBuiltinTemplate() : templateToEdit;
                    lastPathComponent.setTemplate(new PostfixChangedBuiltinTemplate(newTemplate, builtin));
                } else {
                    lastPathComponent.setTemplate(newTemplate);
                }
                this.myModel.nodeStructureChanged(lastPathComponent);
                this.selectionChanged();
            }
        }
    }

    public boolean canDuplicateSelectedTemplate() {
        TreePath[] selectionPaths = this.getSelectionModel().getSelectionPaths();
        if (selectionPaths != null && selectionPaths.length > 1) {
            return false;
        }
        PostfixTemplate selectedTemplate = this.getSelectedTemplate();
        if (!PostfixTemplatesCheckboxTree.isEditable(selectedTemplate)) {
            return false;
        }
        PostfixTemplateProvider provider = selectedTemplate.getProvider();
        if (provider == null) {
            return false;
        }
        PostfixTemplateEditor editor = provider.createEditor(selectedTemplate);
        if (editor != null) {
            Disposer.dispose(editor);
            return true;
        }
        return false;
    }

    public void duplicateSelectedTemplate() {
        TreePath path2 = this.getSelectionModel().getSelectionPath();
        Object lastPathComponent = path2.getLastPathComponent();
        if (lastPathComponent instanceof PostfixTemplateCheckedTreeNode) {
            PostfixTemplate template = ((PostfixTemplateCheckedTreeNode)lastPathComponent).getTemplate();
            PostfixTemplateProvider provider = ((PostfixTemplateCheckedTreeNode)lastPathComponent).getTemplateProvider();
            String languageId = PostfixTemplatesCheckboxTree.getProvidersToLanguages().get(provider);
            if (PostfixTemplatesCheckboxTree.isEditable(template) && languageId != null) {
                PostfixTemplate templateToEdit = template instanceof PostfixChangedBuiltinTemplate ? ((PostfixChangedBuiltinTemplate)template).getDelegate() : template;
                PostfixTemplateEditor editor = provider.createEditor(templateToEdit);
                if (editor == null) {
                    return;
                }
                String providerName = StringUtil.notNullize(provider.getPresentableName());
                PostfixEditTemplateDialog dialog2 = new PostfixEditTemplateDialog(this, editor, providerName, templateToEdit);
                if (dialog2.showAndGet()) {
                    String templateKey = dialog2.getTemplateName();
                    PostfixTemplate newTemplate = editor.createTemplate(PostfixTemplatesUtils.generateTemplateId(templateKey, provider), templateKey);
                    PostfixTemplateCheckedTreeNode createdNode = new PostfixTemplateCheckedTreeNode(newTemplate, provider, true);
                    DefaultMutableTreeNode languageNode = this.findOrCreateLanguageNode(languageId);
                    languageNode.insert(createdNode, languageNode.getIndex((PostfixTemplateCheckedTreeNode)lastPathComponent) + 1);
                    this.myModel.nodeStructureChanged(languageNode);
                    TreeUtil.selectNode(this, createdNode);
                }
            }
        }
    }

    public boolean canRemoveSelectedTemplates() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath path2 : paths) {
            PostfixTemplate template = PostfixTemplatesCheckboxTree.getTemplateFromPath(path2);
            if (!PostfixTemplatesCheckboxTree.isEditable(template) || template.isBuiltin() && !(template instanceof PostfixChangedBuiltinTemplate)) continue;
            return true;
        }
        return false;
    }

    public void removeSelectedTemplates() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (TreePath path2 : paths) {
            PostfixTemplateCheckedTreeNode lastPathComponent = ObjectUtils.tryCast(path2.getLastPathComponent(), PostfixTemplateCheckedTreeNode.class);
            if (lastPathComponent == null) continue;
            PostfixTemplate template = lastPathComponent.getTemplate();
            if (template instanceof PostfixChangedBuiltinTemplate) {
                lastPathComponent.setTemplate(((PostfixChangedBuiltinTemplate)template).getBuiltinTemplate());
                this.myModel.nodeStructureChanged(lastPathComponent);
                continue;
            }
            if (!PostfixTemplatesCheckboxTree.isEditable(template) || template.isBuiltin()) continue;
            TreeUtil.removeLastPathComponent(this, path2);
        }
    }

    private static boolean isEditable(@Nullable PostfixTemplate template) {
        return template != null && template.isEditable() && template.getKey().startsWith(".");
    }

    @NotNull
    private DefaultMutableTreeNode findOrCreateLanguageNode(String languageId) {
        DefaultMutableTreeNode find = TreeUtil.findNode(this.myRoot, n -> n instanceof LangTreeNode && languageId.equals(((LangTreeNode)n).getLanguageId()));
        if (find != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = find;
            if (defaultMutableTreeNode == null) {
                PostfixTemplatesCheckboxTree.$$$reportNull$$$0(9);
            }
            return defaultMutableTreeNode;
        }
        Language language2 = Language.findLanguageByID(languageId);
        String languageName = language2 != null ? language2.getDisplayName() : languageId;
        LangTreeNode languageNode = new LangTreeNode(languageName, languageId);
        this.myRoot.add(languageNode);
        LangTreeNode langTreeNode = languageNode;
        if (langTreeNode == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(10);
        }
        return langTreeNode;
    }

    @NotNull
    private static Map<PostfixTemplateProvider, String> getProvidersToLanguages() {
        HashMap<PostfixTemplateProvider, String> myProviderToLanguage = new HashMap<PostfixTemplateProvider, String>();
        for (LanguageExtensionPoint extension : LanguagePostfixTemplate.EP_NAME.getExtensionList()) {
            PostfixTemplateProvider provider = (PostfixTemplateProvider)extension.getInstance();
            myProviderToLanguage.put(provider, extension.getKey());
        }
        HashMap<PostfixTemplateProvider, String> hashMap = myProviderToLanguage;
        if (hashMap == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerToTemplates";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerToDisabledTemplates";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixTemplate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastPathComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableTemplates";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledTemplatesState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateLanguageNode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersToLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initTree";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledTemplatesState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitTemplateNodes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addTemplate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "editTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LangTreeNode
    extends CheckedTreeNode {
        @NotNull
        private final String myLanguageId;

        LangTreeNode(@NotNull String languageName, @NotNull String languageId) {
            if (languageName == null) {
                LangTreeNode.$$$reportNull$$$0(0);
            }
            if (languageId == null) {
                LangTreeNode.$$$reportNull$$$0(1);
            }
            super(languageName);
            this.myLanguageId = languageId;
        }

        @NotNull
        public String getLanguageId() {
            String string = this.myLanguageId;
            if (string == null) {
                LangTreeNode.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree$LangTreeNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree$LangTreeNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguageId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

