/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixTemplateLogger {
    private static final String USAGE_GROUP = "completion.postfix";
    private static final String CUSTOM = "custom";
    private static final String NO_PROVIDER = "no.provider";
    private static final String TEMPLATE_FIELD = "template";
    private static final String PROVIDER_FIELD = "provider";

    static void log(@NotNull PostfixTemplate template, @NotNull PsiElement context) {
        if (template == null) {
            PostfixTemplateLogger.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PostfixTemplateLogger.$$$reportNull$$$0(1);
        }
        Project project2 = context.getProject();
        FeatureUsageData data2 = new FeatureUsageData().addLanguage(context.getLanguage());
        if (template.isBuiltin()) {
            PostfixTemplateProvider provider = template.getProvider();
            String providerId = provider != null ? provider.getId() : NO_PROVIDER;
            data2.addData(PROVIDER_FIELD, providerId).addData(TEMPLATE_FIELD, template.getId());
        } else {
            data2.addData(PROVIDER_FIELD, CUSTOM).addData(TEMPLATE_FIELD, CUSTOM);
        }
        FUCounterUsageLogger.getInstance().logEvent(project2, USAGE_GROUP, "expanded", data2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = TEMPLATE_FIELD;
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateLogger";
        objectArray[2] = "log";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PostfixTemplateValidator
    extends CustomWhiteListRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "completion_template".equals(ruleId) || "completion_provider_template".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(1);
            }
            if (StringUtil.equals(data2, PostfixTemplateLogger.CUSTOM) || StringUtil.equals(data2, PostfixTemplateLogger.NO_PROVIDER)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            Language lang2 = this.getLanguage(context);
            if (lang2 == null) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            String provider = this.getEventDataField(context, PostfixTemplateLogger.PROVIDER_FIELD);
            String template = this.getEventDataField(context, PostfixTemplateLogger.TEMPLATE_FIELD);
            if (provider == null || template == null || !PostfixTemplateValidator.isProviderOrTemplate(data2, provider, template)) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(4);
                }
                return validationResultType;
            }
            Pair<PostfixTemplate, PostfixTemplateProvider> result2 = PostfixTemplateValidator.findPostfixTemplate(lang2, provider, template);
            if (result2.getFirst() != null && result2.getSecond() != null) {
                PluginInfo templateInfo = PluginInfoDetectorKt.getPluginInfo(result2.getFirst().getClass());
                PluginInfo providerInfo = PluginInfoDetectorKt.getPluginInfo(result2.getSecond().getClass());
                context.setPluginInfo(templateInfo);
                ValidationResultType validationResultType = templateInfo.isDevelopedByJetBrains() && providerInfo.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(5);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(6);
            }
            return validationResultType;
        }

        private static boolean isProviderOrTemplate(@NotNull String data2, @NotNull String provider, @NotNull String template) {
            if (data2 == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(7);
            }
            if (provider == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(8);
            }
            if (template == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(9);
            }
            return StringUtil.equals(data2, provider) || StringUtil.equals(data2, template);
        }

        @NotNull
        private static Pair<PostfixTemplate, PostfixTemplateProvider> findPostfixTemplate(@NotNull Language lang2, @NotNull String providerId, @NotNull String templateId) {
            if (lang2 == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(10);
            }
            if (providerId == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(11);
            }
            if (templateId == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(12);
            }
            if (!StringUtil.equals(providerId, PostfixTemplateLogger.NO_PROVIDER)) {
                PostfixTemplateProvider provider = PostfixTemplateValidator.findProviderById(providerId, lang2);
                PostfixTemplate template = provider != null ? PostfixTemplateValidator.findTemplateById(provider, templateId) : null;
                Pair<PostfixTemplate, PostfixTemplateProvider> pair = provider != null && template != null ? Pair.create(template, provider) : Pair.empty();
                if (pair == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(13);
                }
                return pair;
            }
            for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(lang2)) {
                PostfixTemplate template = PostfixTemplateValidator.findTemplateById(provider, templateId);
                if (template == null) continue;
                Pair<PostfixTemplate, PostfixTemplateProvider> pair = Pair.create(template, provider);
                if (pair == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(14);
                }
                return pair;
            }
            Pair<PostfixTemplate, PostfixTemplateProvider> pair = Pair.empty();
            if (pair == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(15);
            }
            return pair;
        }

        @Nullable
        private static PostfixTemplateProvider findProviderById(@NotNull String id2, @NotNull Language lang2) {
            if (id2 == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(16);
            }
            if (lang2 == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(17);
            }
            for (PostfixTemplateProvider provider : LanguagePostfixTemplate.LANG_EP.allForLanguage(lang2)) {
                if (!StringUtil.equals(provider.getId(), id2)) continue;
                return provider;
            }
            return null;
        }

        @Nullable
        private static PostfixTemplate findTemplateById(@NotNull PostfixTemplateProvider provider, @NotNull String id2) {
            if (provider == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(18);
            }
            if (id2 == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(19);
            }
            for (PostfixTemplate template : provider.getTemplates()) {
                if (!StringUtil.equals(template.getId(), id2)) continue;
                return template;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 13: 
                case 14: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 13: 
                case 14: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateLogger$PostfixTemplateValidator";
                    break;
                }
                case 8: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = PostfixTemplateLogger.PROVIDER_FIELD;
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = PostfixTemplateLogger.TEMPLATE_FIELD;
                    break;
                }
                case 10: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lang";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "providerId";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateId";
                    break;
                }
                case 16: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateLogger$PostfixTemplateValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findPostfixTemplate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isProviderOrTemplate";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findPostfixTemplate";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "findProviderById";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "findTemplateById";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 13: 
                case 14: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

