/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.XmlSuppressionProvider;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultXmlSuppressionProvider
extends XmlSuppressionProvider
implements InspectionSuppressor {
    public static final String SUPPRESS_MARK = "suppress";

    @Override
    public boolean isProviderAvailable(@NotNull PsiFile file2) {
        if (file2 == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    public boolean isSuppressedFor(@NotNull PsiElement element2, @NotNull String inspectionId) {
        if (element2 == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(1);
        }
        if (inspectionId == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(2);
        }
        XmlTag tag2 = element2 instanceof XmlFile ? ((XmlFile)element2).getRootTag() : PsiTreeUtil.getContextOfType(element2, XmlTag.class, false);
        return tag2 != null && this.findSuppression(tag2, inspectionId, element2) != null;
    }

    @Override
    public void suppressForFile(@NotNull PsiElement element2, @NotNull String inspectionId) {
        PsiElement anchor2;
        PsiFile file2;
        if (element2 == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(3);
        }
        if (inspectionId == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(4);
        }
        if (!((file2 = element2.getContainingFile()) instanceof XmlFile)) {
            return;
        }
        XmlDocument document = ((XmlFile)file2).getDocument();
        PsiElement psiElement = anchor2 = document != null ? document.getRootTag() : file2.findElementAt(0);
        assert (anchor2 != null);
        this.suppress(file2, this.findFileSuppression(anchor2, null, element2), inspectionId, anchor2.getTextRange().getStartOffset());
    }

    @Override
    public void suppressForTag(@NotNull PsiElement element2, @NotNull String inspectionId) {
        if (element2 == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(5);
        }
        if (inspectionId == null) {
            DefaultXmlSuppressionProvider.$$$reportNull$$$0(6);
        }
        XmlTag tag2 = PsiTreeUtil.getParentOfType(element2, XmlTag.class);
        assert (tag2 != null);
        this.suppress(element2.getContainingFile(), this.findSuppressionLeaf(tag2, null, 0), inspectionId, tag2.getTextRange().getStartOffset());
    }

    @Nullable
    protected PsiElement findSuppression(PsiElement anchor2, String id2, PsiElement originalElement) {
        PsiElement element2 = this.findSuppressionLeaf(anchor2, id2, 0);
        if (element2 != null) {
            return element2;
        }
        return this.findFileSuppression(anchor2, id2, originalElement);
    }

    @Nullable
    protected PsiElement findFileSuppression(PsiElement anchor2, String id2, PsiElement originalElement) {
        PsiFile file2 = anchor2.getContainingFile();
        if (file2 instanceof XmlFile) {
            XmlDocument document = ((XmlFile)file2).getDocument();
            XmlTag rootTag = document != null ? document.getRootTag() : null;
            PsiElement leaf = rootTag != null ? rootTag.getPrevSibling() : file2.findElementAt(0);
            return this.findSuppressionLeaf(leaf, id2, 0);
        }
        return null;
    }

    @Nullable
    protected PsiElement findSuppressionLeaf(PsiElement leaf, @Nullable String id2, int offset) {
        while (leaf != null && leaf.getTextOffset() >= offset) {
            String text2;
            if ((leaf instanceof PsiComment || leaf instanceof XmlProlog || leaf instanceof XmlText) && this.isSuppressedFor(text2 = leaf.getText(), id2)) {
                return leaf;
            }
            if (!((leaf = leaf.getPrevSibling()) instanceof XmlTag)) continue;
            return null;
        }
        return null;
    }

    private boolean isSuppressedFor(@NonNls String text2, @Nullable String id2) {
        if (!text2.contains(this.getPrefix())) {
            return false;
        }
        if (id2 == null) {
            return true;
        }
        HashSet<String> parts = new HashSet<String>(StringUtil.getWordsIn(text2));
        return parts.contains(id2) || parts.contains("ALL");
    }

    protected void suppress(PsiFile file2, PsiElement suppressionElement, String inspectionId, int offset) {
        Project project2 = file2.getProject();
        Document doc = PsiDocumentManager.getInstance(project2).getDocument(file2);
        assert (doc != null);
        if (suppressionElement != null) {
            TextRange textRange = suppressionElement.getTextRange();
            String text2 = suppressionElement.getText();
            String suppressionText = this.getSuppressionText(inspectionId, text2);
            doc.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), suppressionText);
        } else {
            String suppressionText = this.getSuppressionText(inspectionId, null);
            doc.insertString(offset, suppressionText);
            CodeStyleManager.getInstance(project2).adjustLineIndent(doc, offset + suppressionText.length());
            UndoUtil.markPsiFileForUndo(file2);
        }
    }

    protected String getSuppressionText(String inspectionId, @Nullable String originalText) {
        if (originalText == null) {
            return this.getPrefix() + inspectionId + this.getSuffix() + "\n";
        }
        if (inspectionId.equals("ALL")) {
            int pos = originalText.indexOf(this.getPrefix());
            return originalText.substring(0, pos) + this.getPrefix() + inspectionId + this.getSuffix() + "\n";
        }
        return StringUtil.replace(originalText, this.getSuffix(), ", " + inspectionId + this.getSuffix());
    }

    @NonNls
    protected String getPrefix() {
        return "<!--suppress ";
    }

    @NonNls
    protected String getSuffix() {
        return " -->";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/DefaultXmlSuppressionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isProviderAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuppressedFor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "suppressForFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "suppressForTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

