/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class InspectionDiff {
    private static HashMap<String, ArrayList<Element>> ourFileToProblem;
    @NonNls
    private static final String FILE_ELEMENT = "file";
    @NonNls
    private static final String CLASS_ELEMENT = "class";
    @NonNls
    private static final String FIELD_ELEMENT = "field";
    @NonNls
    private static final String METHOD_ELEMENT = "method";
    @NonNls
    private static final String CONSTRUCTOR_ELEMENT = "constructor";
    @NonNls
    private static final String INTERFACE_ELEMENT = "interface";
    @NonNls
    private static final String PROBLEM_CLASS_ELEMENT = "problem_class";
    @NonNls
    private static final String DESCRIPTION_ELEMENT = "description";

    public static void main(String[] args) {
        if (args.length != 3 && args.length != 2) {
            System.out.println(InspectionsBundle.message("inspection.diff.format.error", new Object[0]));
        }
        String oldPath = args[0];
        String newPath = args[1];
        String outPath = args.length == 3 ? args[2] : null;
        File oldResults = new File(oldPath);
        File newResults = new File(newPath);
        if (oldResults.isDirectory() && newResults.isDirectory()) {
            File[] results;
            File[] old = oldResults.listFiles();
            for (File result2 : results = newResults.listFiles()) {
                String inspectionName = result2.getName();
                boolean found2 = false;
                for (File oldFile : old) {
                    if (!oldFile.getName().equals(inspectionName)) continue;
                    InspectionDiff.writeInspectionDiff(oldFile.getPath(), result2.getPath(), outPath);
                    found2 = true;
                    break;
                }
                if (found2) continue;
                InspectionDiff.writeInspectionDiff(null, result2.getPath(), outPath);
            }
        }
    }

    private static void writeInspectionDiff(String oldPath, String newPath, String outPath) {
        try {
            BufferedInputStream oldStream = oldPath != null ? new BufferedInputStream(new FileInputStream(oldPath)) : null;
            BufferedInputStream newStream = new BufferedInputStream(new FileInputStream(newPath));
            Element oldDoc = oldStream != null ? JDOMUtil.load(oldStream) : null;
            Element newDoc = JDOMUtil.load(newStream);
            FilterOutputStream outStream = System.out;
            if (outPath != null) {
                outStream = new BufferedOutputStream(new FileOutputStream(outPath + File.separator + new File(newPath).getName()));
            }
            Document delta = InspectionDiff.createDelta(oldDoc, newDoc);
            JDOMUtil.writeDocument(delta, outStream, "\n");
            if (outStream != System.out) {
                ((OutputStream)outStream).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Document createDelta(@Nullable Element oldRoot, Element newRoot) {
        ourFileToProblem = new HashMap();
        List<Element> newProblems = newRoot.getChildren("problem");
        Iterator<Element> iterator2 = newProblems.iterator();
        while (iterator2.hasNext()) {
            Element o;
            Element newProblem = o = iterator2.next();
            InspectionDiff.addProblem(newProblem);
        }
        if (oldRoot != null) {
            for (Element oldProblem : oldRoot.getChildren("problem")) {
                if (InspectionDiff.removeIfEquals(oldProblem)) continue;
                InspectionDiff.addProblem(oldProblem);
            }
        }
        Element root = new Element("problems");
        Document delta = new Document(root);
        for (ArrayList<Element> fileList : ourFileToProblem.values()) {
            if (fileList == null) continue;
            for (Element element2 : fileList) {
                root.addContent(element2.clone());
            }
        }
        return delta;
    }

    private static boolean removeIfEquals(Element problem) {
        String fileName = problem.getChildText(FILE_ELEMENT);
        ArrayList<Element> problemList = ourFileToProblem.get(fileName);
        if (problemList != null) {
            Element[] problems;
            for (Element toCheck : problems = problemList.toArray(new Element[0])) {
                if (!InspectionDiff.equals(problem, toCheck)) continue;
                return problemList.remove(toCheck);
            }
        }
        return false;
    }

    private static void addProblem(Element problem) {
        String fileName = problem.getChildText(FILE_ELEMENT);
        ArrayList<Element> problemList = ourFileToProblem.get(fileName);
        if (problemList == null) {
            problemList = new ArrayList();
            ourFileToProblem.put(fileName, problemList);
        }
        problemList.add(problem);
    }

    private static boolean equals(Element oldProblem, Element newProblem) {
        if (!Comparing.equal(oldProblem.getChildText(CLASS_ELEMENT), newProblem.getChildText(CLASS_ELEMENT))) {
            return false;
        }
        if (!Comparing.equal(oldProblem.getChildText(FIELD_ELEMENT), newProblem.getChildText(FIELD_ELEMENT))) {
            return false;
        }
        if (!Comparing.equal(oldProblem.getChildText(METHOD_ELEMENT), newProblem.getChildText(METHOD_ELEMENT))) {
            return false;
        }
        if (!Comparing.equal(oldProblem.getChildText(CONSTRUCTOR_ELEMENT), newProblem.getChildText(CONSTRUCTOR_ELEMENT))) {
            return false;
        }
        if (!Comparing.equal(oldProblem.getChildText(INTERFACE_ELEMENT), newProblem.getChildText(INTERFACE_ELEMENT))) {
            return false;
        }
        if (!Comparing.equal(oldProblem.getChildText(PROBLEM_CLASS_ELEMENT), newProblem.getChildText(PROBLEM_CLASS_ELEMENT))) {
            return false;
        }
        return Comparing.equal(oldProblem.getChildText(DESCRIPTION_ELEMENT), newProblem.getChildText(DESCRIPTION_ELEMENT));
    }
}

