/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionEP
extends LanguageExtensionPoint<InspectionProfileEntry>
implements InspectionProfileEntry.DefaultNameProvider {
    private static final Logger LOG = Logger.getInstance(InspectionEP.class);
    public static final ExtensionPointName<InspectionEP> GLOBAL_INSPECTION = ExtensionPointName.create("com.intellij.globalInspection");
    @Attribute(value="shortName")
    public String shortName;
    @Attribute(value="key")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String key;
    @Attribute(value="bundle")
    public String bundle;
    @Attribute(value="displayName")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String displayName;
    @Attribute(value="groupKey")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String groupKey;
    @Attribute(value="groupBundle")
    public String groupBundle;
    @Attribute(value="groupName")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String groupDisplayName;
    @Attribute(value="groupPath")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String groupPath;
    @Attribute(value="enabledByDefault")
    public boolean enabledByDefault;
    @Attribute(value="applyToDialects")
    public boolean applyToDialects = true;
    @Attribute(value="cleanupTool")
    public boolean cleanupTool;
    @Attribute(value="level")
    public String level;
    @Attribute(value="hasStaticDescription")
    public boolean hasStaticDescription;
    @Attribute(value="presentation")
    public String presentation;
    @Attribute(value="isInternal")
    public boolean isInternal;

    @NonNls
    @NotNull
    public String getShortName() {
        if (this.implementationClass == null) {
            throw new IllegalArgumentException(this.toString());
        }
        String string = this.shortName != null ? this.shortName : InspectionProfileEntry.getShortName(StringUtil.getShortName(this.implementationClass));
        if (string == null) {
            InspectionEP.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.getLocalizedString(this.bundle, this.key);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public String getGroupDisplayName() {
        return this.groupDisplayName != null ? this.groupDisplayName : this.getLocalizedString(this.groupBundle, this.groupKey);
    }

    @Override
    @Nullable
    public String getGroupKey() {
        return this.groupKey;
    }

    public String @Nullable [] getGroupPath() {
        String name = this.getGroupDisplayName();
        if (name == null) {
            return null;
        }
        if (this.groupPath == null) {
            return new String[]{name.isEmpty() ? InspectionProfileEntry.getGeneralGroupName() : name};
        }
        return ArrayUtil.append(this.groupPath.split(","), name);
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        if (this.level == null) {
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
            if (highlightDisplayLevel == null) {
                InspectionEP.$$$reportNull$$$0(1);
            }
            return highlightDisplayLevel;
        }
        HighlightDisplayLevel displayLevel = HighlightDisplayLevel.find(this.level);
        if (displayLevel == null) {
            LOG.error(new PluginException("Can't find highlight display level: " + this.level + "; registered for: " + this.implementationClass + "; and short name: " + this.shortName, this.getPluginDescriptor().getPluginId()));
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
            if (highlightDisplayLevel == null) {
                InspectionEP.$$$reportNull$$$0(2);
            }
            return highlightDisplayLevel;
        }
        HighlightDisplayLevel highlightDisplayLevel = displayLevel;
        if (highlightDisplayLevel == null) {
            InspectionEP.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    @Nullable
    private String getLocalizedString(@Nullable String bundleName, String key) {
        String baseName;
        String string = bundleName != null ? bundleName : (baseName = this.bundle == null ? this.getPluginDescriptor().getResourceBundleBaseName() : this.bundle);
        if (baseName == null || key == null) {
            if (bundleName != null) {
                LOG.warn(this.implementationClass);
            }
            return null;
        }
        ResourceBundle resourceBundle = DynamicBundle.INSTANCE.getResourceBundle(baseName, this.getLoaderForClass());
        return AbstractBundle.message(resourceBundle, key, new Object[0]);
    }

    @NotNull
    public InspectionProfileEntry instantiateTool() {
        InspectionProfileEntry entry = (InspectionProfileEntry)this.createInstance(ApplicationManager.getApplication());
        entry.myNameProvider = this;
        InspectionProfileEntry inspectionProfileEntry = entry;
        if (inspectionProfileEntry == null) {
            InspectionEP.$$$reportNull$$$0(4);
        }
        return inspectionProfileEntry;
    }

    @Override
    public String getDefaultShortName() {
        return this.getShortName();
    }

    @Override
    public String getDefaultDisplayName() {
        return this.getDisplayName();
    }

    @Override
    public String getDefaultGroupDisplayName() {
        return this.getGroupDisplayName();
    }

    public String toString() {
        return "InspectionEP{shortName='" + this.shortName + '\'' + ", key='" + this.key + '\'' + ", bundle='" + this.bundle + '\'' + ", displayName='" + this.displayName + '\'' + ", groupKey='" + this.groupKey + '\'' + ", groupBundle='" + this.groupBundle + '\'' + ", groupDisplayName='" + this.groupDisplayName + '\'' + ", groupPath='" + this.groupPath + '\'' + ", enabledByDefault=" + this.enabledByDefault + ", applyToDialects=" + this.applyToDialects + ", cleanupTool=" + this.cleanupTool + ", level='" + this.level + '\'' + ", hasStaticDescription=" + this.hasStaticDescription + ", presentation='" + this.presentation + '\'' + ", isInternal=" + this.isInternal + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/InspectionEP";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateTool";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

