/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.NonAsciiCharactersInspectionForm;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.io.IOUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonAsciiCharactersInspection
extends LocalInspectionTool {
    public boolean CHECK_FOR_NOT_ASCII_IDENTIFIER_NAME = true;
    public boolean CHECK_FOR_NOT_ASCII_STRING_LITERAL;
    public boolean CHECK_FOR_NOT_ASCII_COMMENT;
    public boolean CHECK_FOR_DIFFERENT_LANGUAGES_IN_IDENTIFIER_NAME = true;
    public boolean CHECK_FOR_FILES_CONTAINING_BOM;

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message("group.names.internationalization.issues", new Object[0]);
        if (string == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NonNls
    @NotNull
    public String getShortName() {
        return "NonAsciiCharacters";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(2);
        }
        if (!NonAsciiCharactersInspection.isFileWorthIt(session2.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                NonAsciiCharactersInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        return new PsiElementVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element2) {
                PsiElement identifier;
                PsiElement parent;
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_IDENTIFIER_NAME || NonAsciiCharactersInspection.this.CHECK_FOR_DIFFERENT_LANGUAGES_IN_IDENTIFIER_NAME) && (parent = element2.getParent()) instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)parent).getNameIdentifier()) != null) {
                    String text2 = element2.getText();
                    if (identifier == element2 || text2.equals(identifier.getText())) {
                        if (NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_IDENTIFIER_NAME) {
                            NonAsciiCharactersInspection.checkAscii(element2, text2, holder, "an identifier");
                        }
                        if (NonAsciiCharactersInspection.this.CHECK_FOR_DIFFERENT_LANGUAGES_IN_IDENTIFIER_NAME) {
                            NonAsciiCharactersInspection.checkSameLanguage(element2, text2, holder);
                        }
                    }
                }
                if (NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_COMMENT && element2 instanceof PsiComment) {
                    NonAsciiCharactersInspection.checkAsciiRange(element2, element2.getText(), holder, "a comment");
                }
                if (NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_STRING_LITERAL && element2 instanceof PsiLiteralValue) {
                    NonAsciiCharactersInspection.checkAsciiRange(element2, element2.getText(), holder, "a string literal");
                }
            }

            @Override
            public void visitFile(@NotNull PsiFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitFile(file2);
                if (NonAsciiCharactersInspection.this.CHECK_FOR_FILES_CONTAINING_BOM) {
                    byte[] bom;
                    VirtualFile virtualFile2 = file2.getVirtualFile();
                    byte[] byArray = bom = virtualFile2 == null ? null : virtualFile2.getBOM();
                    if (bom != null) {
                        String hex = IntStream.range(0, bom.length).map(i -> bom[i]).mapToObj(b -> StringUtil.toUpperCase(Integer.toString(b & 0xFF, 16))).collect(Collectors.joining());
                        Charset charsetFromBOM = CharsetToolkit.guessFromBOM(bom);
                        holder.registerProblem((PsiElement)file2, "File contains BOM: '" + hex + "'" + (charsetFromBOM == null ? "" : " (charset '" + charsetFromBOM.displayName() + "' signature)"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/NonAsciiCharactersInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isFileWorthIt(PsiFile file2) {
        if (InjectedLanguageManager.getInstance(file2.getProject()).isInjectedFragment(file2)) {
            return false;
        }
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return false;
        }
        CharSequence text2 = file2.getViewProvider().getContents();
        Charset charset = LoadTextUtil.extractCharsetFromFileContent(file2.getProject(), virtualFile2, text2);
        return !(charset instanceof Native2AsciiCharset);
    }

    private static void checkSameLanguage(PsiElement element2, String text2, ProblemsHolder holder) {
        Set scripts = text2.codePoints().mapToObj(Character.UnicodeScript::of).filter(script -> !script.equals((Object)Character.UnicodeScript.COMMON)).collect(Collectors.toSet());
        if (scripts.size() > 1) {
            ArrayList list2 = new ArrayList(scripts);
            Collections.sort(list2);
            holder.registerProblem(element2, "Identifier contains symbols from different languages: " + list2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static void checkAscii(PsiElement element2, String text2, ProblemsHolder holder, String where) {
        if (!IOUtil.isAscii(text2)) {
            holder.registerProblem(element2, "Non-ASCII characters in " + where, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static void checkAsciiRange(PsiElement element2, String text2, ProblemsHolder holder, String where) {
        int errorCount = 0;
        int start2 = -1;
        for (int i = 0; i <= text2.length(); ++i) {
            char c;
            char c2 = c = i >= text2.length() ? (char)'\u0000' : text2.charAt(i);
            if (i == text2.length() || c < '\u0080') {
                if (start2 == -1) continue;
                TextRange range2 = new TextRange(start2, i);
                String message = "Non-ASCII characters in " + where;
                holder.registerProblem(element2, range2, message, new LocalQuickFix[0]);
                start2 = -1;
                if (errorCount++ <= 200) continue;
                break;
            }
            if (start2 != -1) continue;
            start2 = i;
        }
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new NonAsciiCharactersInspectionForm((NonAsciiCharactersInspection)this).myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/NonAsciiCharactersInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/NonAsciiCharactersInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

