/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RedundantSuppressionDetector {
    @Nullable
    public String getSuppressionIds(@NotNull PsiElement var1);

    @Nullable
    public LocalQuickFix createRemoveRedundantSuppressionFix(@NotNull String var1);

    public boolean isSuppressionFor(@NotNull PsiElement var1, @NotNull PsiElement var2, @NotNull String var3);

    default public TextRange getHighlightingRange(PsiElement elementWithSuppression, String toolId) {
        String suppressionElementText = elementWithSuppression.getText();
        int idx = StringUtil.indexOfIgnoreCase(suppressionElementText, toolId, 0);
        return idx > 0 ? new TextRange(idx, idx + toolId.length()) : new TextRange(0, suppressionElementText.length());
    }
}

