/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoIndexPatternProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TodoCommentInspection
extends LocalInspectionTool {
    @Override
    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        List<TextRange> ranges2;
        if (file2 == null) {
            TodoCommentInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            TodoCommentInspection.$$$reportNull$$$0(1);
        }
        if ((ranges2 = TodoCommentInspection.getTodoRanges(file2)).isEmpty()) {
            return null;
        }
        SmartList<ProblemDescriptor> result2 = new SmartList<ProblemDescriptor>();
        int lastEndOffset = -1;
        for (TextRange todoRange : ranges2) {
            PsiElement element2;
            int todoStart = todoRange.getStartOffset();
            int todoEnd = todoRange.getEndOffset();
            if (todoStart < lastEndOffset) continue;
            for (element2 = file2.findElementAt(todoStart); element2 != null && element2.getTextRange().getEndOffset() < todoEnd; element2 = element2.getParent()) {
            }
            if (element2 == null) continue;
            int elementStart = element2.getTextRange().getStartOffset();
            TextRange range2 = new TextRange(todoStart - elementStart, todoEnd - elementStart);
            result2.add(manager.createProblemDescriptor(element2, range2, InspectionsBundle.message("todo.comment.problem.descriptor", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
            lastEndOffset = todoEnd;
        }
        return result2.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static List<TextRange> getTodoRanges(@NotNull PsiFile file2) {
        if (file2 == null) {
            TodoCommentInspection.$$$reportNull$$$0(2);
        }
        TodoIndexPatternProvider todoIndexPatternProvider = TodoIndexPatternProvider.getInstance();
        assert (todoIndexPatternProvider != null);
        Collection<IndexPatternOccurrence> occurrences = IndexPatternSearch.search(file2, todoIndexPatternProvider, TodoConfiguration.getInstance().isMultiLine()).findAll();
        return occurrences.stream().map(occurrence -> {
            TextRange mainRange = occurrence.getTextRange();
            List<TextRange> additionalRanges = occurrence.getAdditionalTextRanges();
            return additionalRanges.isEmpty() ? mainRange : new TextRange(mainRange.getStartOffset(), additionalRanges.get(additionalRanges.size() - 1).getEndOffset());
        }).sorted((a, b) -> Comparing.compare(a.getStartOffset(), b.getStartOffset())).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/TodoCommentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTodoRanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

