/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.FileFilterPanel;
import com.intellij.codeInspection.actions.GotoInspectionModel;
import com.intellij.codeInspection.actions.InspectionElement;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInspectionAction
extends GotoActionBase
implements DataProvider {
    private static final Logger LOGGER = Logger.getInstance(RunInspectionAction.class);
    private final String myPredefinedText;

    public RunInspectionAction() {
        this((String)null);
    }

    public RunInspectionAction(String predefinedText) {
        this.myPredefinedText = predefinedText;
        this.getTemplatePresentation().setText(IdeBundle.messagePointer("goto.inspection.action.text", new Object[0]));
    }

    @Override
    protected void gotoActionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            RunInspectionAction.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        final PsiElement psiElement = e.getData(CommonDataKeys.PSI_ELEMENT);
        final PsiFile psiFile = e.getData(CommonDataKeys.PSI_FILE);
        final VirtualFile virtualFile2 = e.getData(CommonDataKeys.VIRTUAL_FILE);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.inspection");
        GotoInspectionModel model = new GotoInspectionModel(project2);
        this.showNavigationPopup(e, model, new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            protected ChooseByNameFilter<Object> createFilter(@NotNull ChooseByNamePopup popup2) {
                if (popup2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                popup2.setSearchInAnyPlace(true);
                return super.createFilter(popup2);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup2, Object element2) {
                ApplicationManager.getApplication().invokeLater(() -> RunInspectionAction.runInspection(project2, ((InspectionElement)element2).getToolWrapper().getShortName(), virtualFile2, psiElement, psiFile));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/codeInspection/actions/RunInspectionAction$1", "createFilter"));
            }
        }, false);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            RunInspectionAction.$$$reportNull$$$0(1);
        }
        return PlatformDataKeys.PREDEFINED_TEXT.is(dataId) ? this.myPredefinedText : null;
    }

    public static void runInspection(final @NotNull Project project2, @NotNull String shortName, @Nullable VirtualFile virtualFile2, PsiElement psiElement, PsiFile psiFile) {
        if (project2 == null) {
            RunInspectionAction.$$$reportNull$$$0(2);
        }
        if (shortName == null) {
            RunInspectionAction.$$$reportNull$$$0(3);
        }
        PsiElement element2 = psiFile == null ? psiElement : psiFile;
        InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance(project2).getCurrentProfile();
        final InspectionToolWrapper toolWrapper = element2 != null ? currentProfile.getInspectionTool(shortName, element2) : currentProfile.getInspectionTool(shortName, project2);
        LOGGER.assertTrue(toolWrapper != null, "Missed inspection: " + shortName);
        final InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance(project2);
        Module module2 = virtualFile2 != null ? ModuleUtilCore.findModuleForFile(virtualFile2, project2) : null;
        AnalysisScope analysisScope = null;
        if (psiFile != null) {
            analysisScope = new AnalysisScope(psiFile);
        } else {
            PsiDirectory psiDirectory;
            if (virtualFile2 != null && virtualFile2.isDirectory() && (psiDirectory = PsiManager.getInstance(project2).findDirectory(virtualFile2)) != null) {
                analysisScope = new AnalysisScope(psiDirectory);
            }
            if (analysisScope == null && virtualFile2 != null) {
                analysisScope = new AnalysisScope(project2, Collections.singletonList(virtualFile2));
            }
            if (analysisScope == null) {
                analysisScope = new AnalysisScope(project2);
            }
        }
        AnalysisUIOptions options = AnalysisUIOptions.getInstance(project2);
        final FileFilterPanel fileFilterPanel = new FileFilterPanel();
        fileFilterPanel.init(options);
        final AnalysisScope initialAnalysisScope = analysisScope;
        List<ModelScopeItem> items = BaseAnalysisActionDialog.standardItems(project2, analysisScope, module2, psiElement);
        BaseAnalysisActionDialog dialog2 = new BaseAnalysisActionDialog("Run '" + toolWrapper.getDisplayName() + "'", CodeInsightBundle.message("analysis.scope.title", InspectionsBundle.message("inspection.action.noun", new Object[0])), project2, items, options, true){
            private InspectionToolWrapper myUpdatedSettingsToolWrapper;

            @Override
            @Nullable
            protected JComponent getAdditionalActionSettings(Project project22) {
                JPanel fileFilter = fileFilterPanel.getPanel();
                if (((InspectionProfileEntry)toolWrapper.getTool()).createOptionsPanel() != null) {
                    JPanel additionPanel = new JPanel();
                    additionPanel.setLayout(new GridBagLayout());
                    additionPanel.add((Component)fileFilter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, JBUI.emptyInsets(), 0, 0));
                    this.myUpdatedSettingsToolWrapper = RunInspectionAction.copyToolWithSettings(toolWrapper);
                    additionPanel.add((Component)new TitledSeparator(IdeBundle.message("goto.inspection.action.choose.inherit.settings.from", new Object[0])), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 1, JBUI.emptyInsets(), 0, 0));
                    JComponent optionsPanel = ((InspectionProfileEntry)this.myUpdatedSettingsToolWrapper.getTool()).createOptionsPanel();
                    LOGGER.assertTrue(optionsPanel != null);
                    GridBagConstraints constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, JBUI.emptyInsets(), 0, 0);
                    if (UIUtil.hasScrollPane(optionsPanel)) {
                        additionPanel.add((Component)optionsPanel, constraints);
                    } else {
                        additionPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)optionsPanel, 0), constraints);
                    }
                    return additionPanel;
                }
                return fileFilter;
            }

            @Override
            @NotNull
            public AnalysisScope getScope(@NotNull AnalysisScope defaultScope) {
                if (defaultScope == null) {
                    2.$$$reportNull$$$0(0);
                }
                AnalysisScope scope = super.getScope(defaultScope);
                GlobalSearchScope filterScope = fileFilterPanel.getSearchScope();
                if (filterScope == null) {
                    AnalysisScope analysisScope = scope;
                    if (analysisScope == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return analysisScope;
                }
                scope.setFilter(filterScope);
                AnalysisScope analysisScope = scope;
                if (analysisScope == null) {
                    2.$$$reportNull$$$0(2);
                }
                return analysisScope;
            }

            private AnalysisScope getScope() {
                return this.getScope(initialAnalysisScope);
            }

            private InspectionToolWrapper getToolWrapper() {
                return this.myUpdatedSettingsToolWrapper == null ? toolWrapper : this.myUpdatedSettingsToolWrapper;
            }

            @Override
            protected Action @NotNull [] createActions() {
                ArrayList<Action> actions = new ArrayList<Action>();
                boolean hasFixAll = toolWrapper.getTool() instanceof CleanupLocalInspectionTool;
                actions.add(new AbstractAction(hasFixAll ? CodeInsightBundle.message("action.analyze.verb", new Object[0]) : CommonBundle.getOkButtonText()){
                    {
                        super(x0);
                        this.putValue("DefaultAction", Boolean.TRUE);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AnalysisScope scope = this.getScope();
                        InspectionToolWrapper wrapper2 = this.getToolWrapper();
                        DumbService.getInstance(project2).smartInvokeLater(() -> RunInspectionIntention.rerunInspection(wrapper2, managerEx, scope, null));
                        this.close(0);
                    }
                });
                if (hasFixAll) {
                    actions.add(new AbstractAction(IdeBundle.message("goto.inspection.action.fix.all", new Object[0])){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            InspectionToolWrapper wrapper2 = this.getToolWrapper();
                            InspectionProfileImpl cleanupToolProfile = RunInspectionIntention.createProfile(wrapper2, managerEx, null);
                            managerEx.createNewGlobalContext().codeCleanup(this.getScope(), cleanupToolProfile, "Cleanup by " + wrapper2.getDisplayName(), null, false);
                            this.close(0);
                        }
                    });
                }
                actions.add(this.getCancelAction());
                if (SystemInfo.isMac) {
                    Collections.reverse(actions);
                }
                Action[] actionArray = actions.toArray(new Action[0]);
                if (actionArray == null) {
                    2.$$$reportNull$$$0(3);
                }
                return actionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "defaultScope";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/actions/RunInspectionAction$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/actions/RunInspectionAction$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getScope";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getScope";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        dialog2.showAndGet();
    }

    private static InspectionToolWrapper copyToolWithSettings(@NotNull InspectionToolWrapper tool) {
        if (tool == null) {
            RunInspectionAction.$$$reportNull$$$0(4);
        }
        Element options = new Element("copy");
        ((InspectionProfileEntry)tool.getTool()).writeSettings(options);
        InspectionToolWrapper copiedTool = tool.createCopy();
        ((InspectionProfileEntry)copiedTool.getTool()).readSettings(options);
        return copiedTool;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/actions/RunInspectionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "gotoActionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "copyToolWithSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

