/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.InspectionProfileConvertor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.configurationStore.BundledSchemeEP;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileLoadUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileProcessor;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.messages.MessageBus;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="InspectionProfileManager", storages={@Storage(value="editor.xml")}, additionalExportFile="inspection")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0002\b\n\b\u0017\u0018\u0000 /2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001/B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001aH\u0016J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\nJ\b\u0010!\u001a\u00020\u001aH\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010\u001a2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\nH\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0&H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0004H\u0016J\u0006\u0010(\u001a\u00020\u0011J\u0010\u0010)\u001a\u0004\u0018\u00010\u001a2\u0006\u0010*\u001a\u00020\u0015J\u0010\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0004H\u0016J\u0012\u0010-\u001a\u00020\u00112\b\u0010.\u001a\u0004\u0018\u00010\u0015H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u0015\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00060"}, d2={"Lcom/intellij/codeInspection/ex/ApplicationInspectionProfileManager;", "Lcom/intellij/profile/codeInspection/BaseInspectionProfileManager;", "Lcom/intellij/profile/codeInspection/InspectionProfileManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "schemeManagerFactory", "Lcom/intellij/openapi/options/SchemeManagerFactory;", "(Lcom/intellij/openapi/options/SchemeManagerFactory;)V", "LOAD_PROFILES", "", "converter", "Lcom/intellij/codeInsight/daemon/InspectionProfileConvertor;", "getConverter", "()Lcom/intellij/codeInsight/daemon/InspectionProfileConvertor;", "profilesAreInitialized", "Lcom/intellij/openapi/util/AtomicNotNullLazyValue;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "rootProfileName", "", "getRootProfileName", "()Ljava/lang/String;", "schemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "getSchemeManager", "()Lcom/intellij/openapi/options/SchemeManager;", "fireProfileChanged", "profile", "forceInitProfiles", "flag", "getCurrentProfile", "getProfile", "name", "returnRootProfileIfNamedIsAbsent", "getProfiles", "", "getState", "initProfiles", "loadProfile", "path", "loadState", "state", "setRootProfile", "profileName", "Companion", "intellij.platform.lang.impl"})
public class ApplicationInspectionProfileManager
extends BaseInspectionProfileManager
implements InspectionProfileManager,
PersistentStateComponent<Element> {
    @NotNull
    private final SchemeManager<InspectionProfileImpl> schemeManager;
    private final AtomicNotNullLazyValue<Unit> profilesAreInitialized;
    private volatile boolean LOAD_PROFILES;
    private static final ExtensionPointName<BundledSchemeEP> BUNDLED_EP_NAME;
    public static final Companion Companion;

    @Override
    @NotNull
    protected SchemeManager<InspectionProfileImpl> getSchemeManager() {
        return this.schemeManager;
    }

    @NotNull
    public InspectionProfileConvertor getConverter() {
        return new InspectionProfileConvertor(this);
    }

    @NotNull
    public final String getRootProfileName() {
        String string = this.getSchemeManager().getCurrentSchemeName();
        if (string == null) {
            string = "Default";
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<InspectionProfileImpl> getProfiles() {
        this.initProfiles();
        List<InspectionProfileImpl> list2 = Collections.unmodifiableList(this.getSchemeManager().getAllSchemes());
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.unmodifiable\u2026schemeManager.allSchemes)");
        return list2;
    }

    public final void forceInitProfiles(boolean flag) {
        this.LOAD_PROFILES = flag;
        this.profilesAreInitialized.getValue();
    }

    public final void initProfiles() {
        if (this.LOAD_PROFILES) {
            this.profilesAreInitialized.getValue();
        }
    }

    @Nullable
    public final InspectionProfileImpl loadProfile(@NotNull String path2) throws IOException, JDOMException {
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        Path file2 = Paths.get(path2, new String[0]);
        if (Files.isRegularFile(file2, new LinkOption[0])) {
            try {
                return InspectionProfileLoadUtil.load(file2, InspectionToolRegistrar.getInstance(), this);
            }
            catch (IOException e) {
                throw (Throwable)e;
            }
            catch (JDOMException e) {
                throw (Throwable)e;
            }
            catch (Exception ignored) {
                ApplicationManager.getApplication().invokeLater(new Runnable(file2){
                    final /* synthetic */ Path $file;

                    public final void run() {
                        Messages.showErrorDialog(InspectionsBundle.message("inspection.error.loading.message", 0, this.$file), InspectionsBundle.message("inspection.errors.occurred.dialog.title", new Object[0]));
                    }
                    {
                        this.$file = path2;
                    }
                }, ModalityState.NON_MODAL);
            }
        }
        return this.getProfile(path2, false);
    }

    @Override
    @Nullable
    public Element getState() {
        Element state = new Element("state");
        this.getSeverityRegistrar().writeExternal(state);
        return state;
    }

    @Override
    public void loadState(@NotNull Element state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.getSeverityRegistrar().readExternal(state);
    }

    @Override
    public void setRootProfile(@Nullable String profileName) {
        this.getSchemeManager().setCurrentSchemeName(profileName);
    }

    @Override
    @Nullable
    public InspectionProfileImpl getProfile(@NotNull String name, boolean returnRootProfileIfNamedIsAbsent) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        InspectionProfileImpl found2 = this.getSchemeManager().findSchemeByName(name);
        if (found2 != null) {
            return found2;
        }
        return returnRootProfileIfNamedIsAbsent ? this.getCurrentProfile() : null;
    }

    @Override
    @NotNull
    public InspectionProfileImpl getCurrentProfile() {
        this.initProfiles();
        InspectionProfileImpl current2 = this.getSchemeManager().getActiveScheme();
        if (current2 != null) {
            return current2;
        }
        InspectionProfileImpl result2 = this.getSchemeManager().findSchemeByName("Default");
        if (result2 == null) {
            InspectionProfileImpl profile = new InspectionProfileImpl("Default");
            this.addProfile(profile);
            return profile;
        }
        return result2;
    }

    @Override
    public void fireProfileChanged(@NotNull InspectionProfileImpl profile) {
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        boolean $i$f$processOpenedProjects = false;
        Project[] projectArray = ProjectManager.getInstanceIfCreated();
        if (projectArray == null || (projectArray = projectArray.getOpenProjects()) == null) {
        } else {
            Project[] projectArray2 = projectArray;
            int n = projectArray2.length;
            for (int i = 0; i < n; ++i) {
                Project project$iv;
                Project project2 = project$iv = projectArray2[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                if (project2.isDisposed() || !project$iv.isInitialized()) continue;
                Project project3 = project$iv;
                boolean bl = false;
                ProjectInspectionProfileManager.Companion.getInstance(project3).fireProfileChanged(profile);
            }
        }
    }

    @NonInjectable
    public ApplicationInspectionProfileManager(@NotNull SchemeManagerFactory schemeManagerFactory) {
        Intrinsics.checkParameterIsNotNull((Object)schemeManagerFactory, (String)"schemeManagerFactory");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBus messageBus = application.getMessageBus();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBus, (String)"ApplicationManager.getApplication().messageBus");
        super(messageBus);
        this.schemeManager = SchemeManagerFactory.create$default(schemeManagerFactory, "inspection", new InspectionProfileProcessor(this){
            final /* synthetic */ ApplicationInspectionProfileManager this$0;

            @NotNull
            public String getSchemeKey(@NotNull Function<String, String> attributeProvider, @NotNull String fileNameWithoutExtension) {
                Intrinsics.checkParameterIsNotNull(attributeProvider, (String)"attributeProvider");
                Intrinsics.checkParameterIsNotNull((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
                return fileNameWithoutExtension;
            }

            @NotNull
            public InspectionProfileImpl createScheme(@NotNull SchemeDataHolder<? super InspectionProfileImpl> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider, boolean isBundled) {
                Intrinsics.checkParameterIsNotNull(dataHolder, (String)"dataHolder");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull(attributeProvider, (String)"attributeProvider");
                return new InspectionProfileImpl(name, InspectionToolRegistrar.getInstance(), this.this$0, dataHolder);
            }

            public void onSchemeAdded(@NotNull InspectionProfileImpl scheme) {
                Intrinsics.checkParameterIsNotNull((Object)scheme, (String)"scheme");
                this.this$0.fireProfileChanged(scheme);
            }
            {
                this.this$0 = $outer;
            }
        }, null, null, 12, null);
        AtomicNotNullLazyValue atomicNotNullLazyValue = AtomicNotNullLazyValue.createValue(new NotNullFactory<T>(this){
            final /* synthetic */ ApplicationInspectionProfileManager this$0;

            public final void create() {
                Application app;
                Application application = app = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                if (!application.isUnitTestMode() && !app.isHeadlessEnvironment()) {
                    for (BundledSchemeEP ep : ApplicationInspectionProfileManager.access$getBUNDLED_EP_NAME$cp().getIterable()) {
                        SchemeManager<InspectionProfileImpl> schemeManager2 = this.this$0.getSchemeManager();
                        StringBuilder stringBuilder = new StringBuilder();
                        String string = ep.getPath();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        String string2 = stringBuilder.append(string).append(".xml").toString();
                        BundledSchemeEP bundledSchemeEP = ep;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bundledSchemeEP, (String)"ep");
                        schemeManager2.loadBundledScheme(string2, bundledSchemeEP);
                    }
                }
                this.this$0.getSchemeManager().loadSchemes();
                if (this.this$0.getSchemeManager().isEmpty()) {
                    this.this$0.getSchemeManager().addScheme(new InspectionProfileImpl("Default", (InspectionToolsSupplier)InspectionToolRegistrar.getInstance(), this.this$0));
                }
            }
            {
                this.this$0 = applicationInspectionProfileManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(atomicNotNullLazyValue, (String)"AtomicNotNullLazyValue.c\u2026tance(), this))\n    }\n  }");
        this.profilesAreInitialized = atomicNotNullLazyValue;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
        this.LOAD_PROFILES = !application2.isUnitTestMode();
        Companion.registerProvidedSeverities();
    }

    public ApplicationInspectionProfileManager() {
        this(SchemeManagerFactory.Companion.getInstance());
    }

    static {
        Companion = new Companion(null);
        BUNDLED_EP_NAME = new ExtensionPointName("com.intellij.bundledInspectionProfile");
    }

    public static final /* synthetic */ ExtensionPointName access$getBUNDLED_EP_NAME$cp() {
        return BUNDLED_EP_NAME;
    }

    @JvmStatic
    @NotNull
    public static final ApplicationInspectionProfileManager getInstanceImpl() {
        return Companion.getInstanceImpl();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInspection/ex/ApplicationInspectionProfileManager$Companion;", "", "()V", "BUNDLED_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/configurationStore/BundledSchemeEP;", "getInstanceImpl", "Lcom/intellij/codeInspection/ex/ApplicationInspectionProfileManager;", "registerProvidedSeverities", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ApplicationInspectionProfileManager getInstanceImpl() {
            boolean $i$f$service = false;
            InspectionProfileManager inspectionProfileManager = ApplicationManager.getApplication().getService(InspectionProfileManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)inspectionProfileManager, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            if (inspectionProfileManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInspection.ex.ApplicationInspectionProfileManager");
            }
            return (ApplicationInspectionProfileManager)inspectionProfileManager;
        }

        public final void registerProvidedSeverities() {
            ExtensionPointName<SeveritiesProvider> extensionPointName = SeveritiesProvider.EP_NAME;
            Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"SeveritiesProvider.EP_NAME");
            Iterator<SeveritiesProvider> iterator2 = extensionPointName.getIterable().iterator();
            while (iterator2.hasNext()) {
                SeveritiesProvider provider;
                SeveritiesProvider severitiesProvider = provider = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)severitiesProvider, (String)"provider");
                for (HighlightInfoType t : severitiesProvider.getSeveritiesHighlightInfoTypes()) {
                    HighlightSeverity highlightSeverity;
                    Intrinsics.checkExpressionValueIsNotNull((Object)t.getSeverity(null), (String)"t.getSeverity(null)");
                    SeverityRegistrar.registerStandard(t, highlightSeverity);
                    HighlightInfoType highlightInfoType = t;
                    Icon icon2 = highlightInfoType instanceof HighlightInfoType.Iconable ? IconLoader.createLazy(new Supplier<Icon>(t){
                        final /* synthetic */ HighlightInfoType $t;

                        @NotNull
                        public final Icon get() {
                            HighlightInfoType highlightInfoType = this.$t;
                            if (highlightInfoType == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.HighlightInfoType.Iconable");
                            }
                            return ((HighlightInfoType.Iconable)((Object)highlightInfoType)).getIcon();
                        }
                        {
                            this.$t = highlightInfoType;
                        }
                    }) : null;
                    HighlightInfoType highlightInfoType2 = t;
                    Intrinsics.checkExpressionValueIsNotNull((Object)highlightInfoType2, (String)"t");
                    HighlightDisplayLevel.registerSeverity(highlightSeverity, highlightInfoType2.getAttributesKey(), icon2);
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

