/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.actions.CleanupInspectionUtil;
import com.intellij.codeInspection.ex.BatchModeDescriptorsUtil;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProviderImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.GlobalReportedProblemFilter;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.ReportedProblemFilter;
import com.intellij.codeInspection.ui.actions.ExportHTMLAction;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.JobLauncherImpl;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionContextImpl
extends GlobalInspectionContextBase {
    private static final int MAX_OPEN_GLOBAL_INSPECTION_XML_RESULT_FILES = SystemProperties.getIntProperty("max.open.global.inspection.xml.files", 50);
    private static final boolean INSPECT_INJECTED_PSI = SystemProperties.getBooleanProperty("idea.batch.inspections.inspect.injected.psi", true);
    private static final Logger LOG = Logger.getInstance(GlobalInspectionContextImpl.class);
    public static volatile boolean TESTING_VIEW;
    public static final NotificationGroup NOTIFICATION_GROUP;
    private final NotNullLazyValue<? extends ContentManager> myContentManager;
    private volatile InspectionResultsView myView;
    private volatile Path myOutputDir;
    private Content myContent;
    private volatile boolean myViewClosed;
    private long myInspectionStartedTimestamp;
    private GlobalReportedProblemFilter myGlobalReportedProblemFilter;
    private ReportedProblemFilter myReportedProblemFilter;
    private final List<ProgressIndicator> dependentIndicators;
    private static final PsiFile TOMBSTONE;
    private static final TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement> CONVERT;
    private final ConcurrentMap<InspectionToolWrapper, InspectionToolPresentation> myPresentationMap;

    public GlobalInspectionContextImpl(@NotNull Project project2, @NotNull NotNullLazyValue<? extends ContentManager> contentManager2) {
        if (project2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(0);
        }
        if (contentManager2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(1);
        }
        super(project2);
        this.myViewClosed = true;
        this.dependentIndicators = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPresentationMap = ContainerUtil.newConcurrentMap();
        this.myContentManager = contentManager2;
    }

    @NotNull
    private ContentManager getContentManager() {
        ContentManager contentManager2 = this.myContentManager.getValue();
        if (contentManager2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(2);
        }
        return contentManager2;
    }

    public ReportedProblemFilter getReportedProblemFilter() {
        return this.myReportedProblemFilter;
    }

    public void setReportedProblemFilter(ReportedProblemFilter reportedProblemFilter) {
        this.myReportedProblemFilter = reportedProblemFilter;
    }

    public GlobalReportedProblemFilter getGlobalReportedProblemFilter() {
        return this.myGlobalReportedProblemFilter;
    }

    public void setGlobalReportedProblemFilter(GlobalReportedProblemFilter reportedProblemFilter) {
        this.myGlobalReportedProblemFilter = reportedProblemFilter;
    }

    public void addView(@NotNull InspectionResultsView view, @NotNull String title, boolean isOffline) {
        if (view == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(3);
        }
        if (title == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(this.myContent == null, "GlobalInspectionContext is busy under other view now");
        this.myView = view;
        if (!isOffline) {
            this.myView.setUpdating(true);
        }
        this.myContent = ContentFactory.SERVICE.getInstance().createContent(view, title, false);
        this.myContent.setHelpId("reference.toolWindows.inspections");
        this.myContent.setDisposer(this.myView);
        Disposer.register(this.myContent, () -> {
            if (this.myView != null) {
                this.close(false);
            }
            this.myContent = null;
        });
        ContentManager contentManager2 = this.getContentManager();
        contentManager2.addContent(this.myContent);
        contentManager2.setSelectedContent(this.myContent);
        ToolWindowManager.getInstance(this.getProject()).getToolWindow("Inspection Results").activate(null);
    }

    public void addView(@NotNull InspectionResultsView view) {
        if (view == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(5);
        }
        this.addView(view, InspectionsBundle.message(view.isSingleInspectionRun() ? "inspection.results.for.inspection.toolwindow.title" : "inspection.results.for.profile.toolwindow.title", view.getCurrentProfileName(), this.getCurrentScope().getShortenName()), false);
    }

    @Override
    public void doInspections(@NotNull AnalysisScope scope) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(6);
        }
        if (this.myContent != null) {
            this.getContentManager().removeContent(this.myContent, true);
        }
        super.doInspections(scope);
    }

    public void launchInspectionsOffline(@NotNull AnalysisScope scope, @NotNull Path outputPath, boolean runGlobalToolsOnly, @NotNull List<? super Path> inspectionsResults) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(7);
        }
        if (outputPath == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(8);
        }
        if (inspectionsResults == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(9);
        }
        this.performInspectionsWithProgressAndExportResults(scope, runGlobalToolsOnly, true, outputPath, inspectionsResults);
    }

    public void performInspectionsWithProgressAndExportResults(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections, @NotNull Path outputDir, @NotNull List<? super Path> inspectionsResults) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(10);
        }
        if (outputDir == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(11);
        }
        if (inspectionsResults == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(12);
        }
        this.cleanupTools();
        this.setCurrentScope(scope);
        Runnable action2 = () -> {
            this.myOutputDir = outputDir;
            try {
                this.performInspectionsWithProgress(scope, runGlobalToolsOnly, isOfflineInspections);
                this.exportResultsSmart(inspectionsResults, outputDir);
            }
            finally {
                this.myOutputDir = null;
            }
        };
        if (isOfflineInspections) {
            ApplicationManager.getApplication().runReadAction(action2);
        } else {
            action2.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void exportResults(@NotNull List<? super Path> inspectionsResults, final @NotNull List<? extends Tools> inspections, @NotNull Path outputDir, @Nullable XMLOutputFactory xmlOutputFactory) {
        void var9_14;
        BufferedWriter[] bufferedWriterArray;
        if (inspectionsResults == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(13);
        }
        if (inspections == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(14);
        }
        if (outputDir == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(15);
        }
        if (xmlOutputFactory == null) {
            xmlOutputFactory = XMLOutputFactory.newInstance();
        }
        final BufferedWriter[] writers = new BufferedWriter[inspections.size()];
        XMLStreamWriter[] xmlWriters = new XMLStreamWriter[inspections.size()];
        try {
            int i = 0;
            for (Tools tools : inspections) {
                inspectionsResults.add(ExportHTMLAction.getInspectionResultPath(outputDir, tools.getShortName()));
                try {
                    BufferedWriter writer;
                    writers[i] = writer = ExportHTMLAction.getWriter(outputDir, tools.getShortName());
                    XMLStreamWriter xmlWriter = xmlOutputFactory.createXMLStreamWriter(writer);
                    xmlWriters[i++] = xmlWriter;
                    xmlWriter.writeStartElement("problems");
                    xmlWriter.writeCharacters("\n");
                    xmlWriter.flush();
                }
                catch (IOException | XMLStreamException e) {
                    LOG.error(e);
                }
            }
            this.getRefManager().iterate(new RefVisitor(){

                @Override
                public void visitElement(@NotNull RefEntity refEntity) {
                    if (refEntity == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    int i = 0;
                    for (Tools tools : inspections) {
                        for (ScopeToolState state : tools.getTools()) {
                            try {
                                InspectionToolWrapper<?, ?> toolWrapper = state.getTool();
                                InspectionToolPresentation presentation = GlobalInspectionContextImpl.this.getPresentation(toolWrapper);
                                BufferedWriter writer = writers[i];
                                if (writer == null || GlobalInspectionContextImpl.this.myGlobalReportedProblemFilter != null && !GlobalInspectionContextImpl.this.myGlobalReportedProblemFilter.shouldReportProblem(refEntity, toolWrapper.getShortName())) continue;
                                presentation.exportResults(e -> {
                                    try {
                                        JbXmlOutputter.collapseMacrosAndWrite(e, GlobalInspectionContextImpl.this.getProject(), writer);
                                        writer.flush();
                                    }
                                    catch (IOException e1) {
                                        throw new RuntimeException(e1);
                                    }
                                }, refEntity, d -> false);
                            }
                            catch (Throwable e2) {
                                LOG.error("Problem when exporting: " + refEntity.getExternalName(), e2);
                            }
                        }
                        ++i;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$1", "visitElement"));
                }
            });
            for (XMLStreamWriter xmlWriter : xmlWriters) {
                if (xmlWriter == null) continue;
                try {
                    xmlWriter.writeEndElement();
                    xmlWriter.flush();
                }
                catch (XMLStreamException e) {
                    LOG.error(e);
                }
            }
            bufferedWriterArray = writers;
        }
        catch (Throwable throwable) {
            for (BufferedWriter writer : writers) {
                if (writer == null) continue;
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
            throw throwable;
        }
        int n = bufferedWriterArray.length;
        boolean bl = false;
        while (var9_14 < n) {
            BufferedWriter writer = bufferedWriterArray[var9_14];
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
            ++var9_14;
        }
    }

    private void exportResultsSmart(@NotNull List<? super Path> inspectionsResults, @NotNull Path outputDir) {
        if (inspectionsResults == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(16);
        }
        if (outputDir == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(17);
        }
        ArrayList<Tools> globalToolsWithProblems = new ArrayList<Tools>();
        for (Map.Entry<String, Tools> entry : this.getTools().entrySet()) {
            Tools sameTools = entry.getValue();
            boolean hasProblems = false;
            String toolName = entry.getKey();
            if (sameTools != null) {
                for (ScopeToolState toolDescr : sameTools.getTools()) {
                    InspectionToolWrapper<?, ?> toolWrapper = toolDescr.getTool();
                    if (toolWrapper instanceof LocalInspectionToolWrapper) {
                        hasProblems = Files.exists(ExportHTMLAction.getInspectionResultFile(outputDir, toolWrapper.getShortName()), new LinkOption[0]);
                        continue;
                    }
                    InspectionToolPresentation presentation = this.getPresentation(toolWrapper);
                    presentation.updateContent();
                    if (!presentation.hasReportedProblems()) continue;
                    globalToolsWithProblems.add(sameTools);
                    LOG.assertTrue(!hasProblems, toolName);
                    break;
                }
            }
            if (!hasProblems) continue;
            try {
                Path file2 = ExportHTMLAction.getInspectionResultPath(outputDir, sameTools.getShortName());
                inspectionsResults.add(file2);
                Files.write(file2, "</problems>".getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
        if (!globalToolsWithProblems.isEmpty()) {
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            StreamEx.ofSubLists(globalToolsWithProblems, (int)MAX_OPEN_GLOBAL_INSPECTION_XML_RESULT_FILES).forEach(inspections -> this.exportResults(inspectionsResults, (List<? extends Tools>)inspections, outputDir, xmlOutputFactory));
        }
    }

    public void resolveElement(@NotNull InspectionProfileEntry tool, @NotNull PsiElement element2) {
        RefElement refElement;
        if (tool == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(18);
        }
        if (element2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(19);
        }
        if ((refElement = this.getRefManager().getReference(element2)) == null) {
            return;
        }
        Tools tools = this.getTools().get(tool.getShortName());
        if (tools != null) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper<?, ?> toolWrapper = state.getTool();
                InspectionToolPresentation presentation = this.getPresentationOrNull(toolWrapper);
                if (presentation == null) continue;
                GlobalInspectionContextImpl.resolveElementRecursively(presentation, refElement);
            }
        }
    }

    public InspectionResultsView getView() {
        return this.myView;
    }

    @Nullable
    public Path getOutputPath() {
        return this.myOutputDir;
    }

    private static void resolveElementRecursively(@NotNull InspectionToolPresentation presentation, @NotNull RefEntity refElement) {
        if (presentation == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(20);
        }
        if (refElement == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(21);
        }
        presentation.suppressProblem(refElement);
        List<RefEntity> children2 = refElement.getChildren();
        for (RefEntity child2 : children2) {
            GlobalInspectionContextImpl.resolveElementRecursively(presentation, child2);
        }
    }

    @NotNull
    public AnalysisUIOptions getUIOptions() {
        AnalysisUIOptions analysisUIOptions = AnalysisUIOptions.getInstance(this.getProject());
        if (analysisUIOptions == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(22);
        }
        return analysisUIOptions;
    }

    public void setSplitterProportion(float proportion) {
        this.getUIOptions().SPLITTER_PROPORTION = proportion;
    }

    @NotNull
    public ToggleAction createToggleAutoscrollAction() {
        ToggleAction toggleAction = this.getUIOptions().getAutoScrollToSourceHandler().createToggleAction();
        if (toggleAction == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(23);
        }
        return toggleAction;
    }

    @Override
    protected void launchInspections(@NotNull AnalysisScope scope) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(24);
        }
        this.myViewClosed = false;
        super.launchInspections(scope);
    }

    @Override
    @NotNull
    protected PerformInBackgroundOption createOption() {
        return new PerformAnalysisInBackgroundOption(this.getProject());
    }

    @Override
    protected void notifyInspectionsFinished(@NotNull AnalysisScope scope) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(25);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !TESTING_VIEW) {
            return;
        }
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        long elapsed = System.currentTimeMillis() - this.myInspectionStartedTimestamp;
        LOG.info("Code inspection finished. Took " + elapsed + "ms");
        if (this.getProject().isDisposed()) {
            return;
        }
        InspectionResultsView newView = this.myView == null ? new InspectionResultsView(this, new InspectionRVContentProviderImpl()) : null;
        if (!(this.myView == null ? newView : this.myView).hasProblems()) {
            int totalFiles = this.getStdJobDescriptors().BUILD_GRAPH.getTotalAmount();
            NOTIFICATION_GROUP.createNotification(InspectionsBundle.message("inspection.no.problems.message", totalFiles, scope.getShortenName()), MessageType.INFO).notify(this.getProject());
            this.close(true);
            if (newView != null) {
                Disposer.dispose(newView);
            }
        } else if (newView != null && !newView.isDisposed() && this.getCurrentScope() != null) {
            this.addView(newView);
            newView.update();
        }
        if (this.myView != null) {
            this.myView.setUpdating(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runTools(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly, boolean isOfflineInspections) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(26);
        }
        this.myInspectionStartedTimestamp = System.currentTimeMillis();
        ProgressIndicator progressIndicator2 = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator2 == null) {
            throw new IncorrectOperationException("Must be run under progress");
        }
        if (!isOfflineInspections && ApplicationManager.getApplication().isDispatchThread()) {
            throw new IncorrectOperationException("Must not start inspections from within EDT");
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IncorrectOperationException("Must not start inspections from within write action");
        }
        if (!isOfflineInspections && ApplicationManager.getApplication().isReadAccessAllowed()) {
            throw new IncorrectOperationException("Must not start inspections from within global read action");
        }
        InspectionManager inspectionManager = InspectionManager.getInstance(this.getProject());
        ((RefManagerImpl)this.getRefManager()).initializeAnnotators();
        ArrayList<Tools> globalTools = new ArrayList<Tools>();
        ArrayList<Tools> localTools = new ArrayList<Tools>();
        ArrayList globalSimpleTools = new ArrayList();
        this.initializeTools(globalTools, localTools, globalSimpleTools);
        this.appendPairedInspectionsForUnfairTools(globalTools, globalSimpleTools, localTools);
        this.runGlobalTools(scope, inspectionManager, globalTools, isOfflineInspections);
        if (runGlobalToolsOnly || localTools.isEmpty() && globalSimpleTools.isEmpty()) {
            return;
        }
        SearchScope searchScope = ReadAction.compute(scope::toSearchScope);
        THashSet localScopeFiles = searchScope instanceof LocalSearchScope ? new THashSet() : null;
        for (Tools tools : globalSimpleTools) {
            GlobalInspectionToolWrapper toolWrapper = (GlobalInspectionToolWrapper)tools.getTool();
            GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
            tool.inspectionStarted(inspectionManager, this, this.getPresentation(toolWrapper));
        }
        boolean headlessEnvironment = ApplicationManager.getApplication().isHeadlessEnvironment();
        Map<String, InspectionToolWrapper> map2 = GlobalInspectionContextImpl.getInspectionWrappersMap(localTools);
        ArrayBlockingQueue filesToInspect = new ArrayBlockingQueue(1000);
        SensitiveProgressWrapper iteratingIndicator = new SensitiveProgressWrapper(progressIndicator2);
        Future<?> future2 = this.startIterateScopeInBackground(scope, localScopeFiles, headlessEnvironment, filesToInspect, iteratingIndicator);
        Processor<PsiFile> processor2 = file2 -> {
            ProgressManager.checkCanceled();
            Boolean readActionSuccess = DumbService.getInstance(this.getProject()).tryRunReadActionInSmartMode(() -> {
                if (!file2.isValid()) {
                    return true;
                }
                VirtualFile virtualFile2 = file2.getVirtualFile();
                if (!scope.contains(virtualFile2)) {
                    LOG.info(file2.getName() + "; scope: " + scope + "; " + virtualFile2);
                    return true;
                }
                boolean includeDoNotShow = this.includeDoNotShow(this.getCurrentProfile());
                this.inspectFile((PsiFile)file2, GlobalInspectionContextImpl.getEffectiveRange(searchScope, file2), inspectionManager, map2, (List<? extends GlobalInspectionToolWrapper>)GlobalInspectionContextImpl.getWrappersFromTools(globalSimpleTools, file2, includeDoNotShow, wrapper2 -> !(wrapper2.getTool() instanceof ExternalAnnotatorBatchInspection)), (List<? extends LocalInspectionToolWrapper>)GlobalInspectionContextImpl.getWrappersFromTools(localTools, file2, includeDoNotShow, wrapper2 -> !(wrapper2.getTool() instanceof ExternalAnnotatorBatchInspection)));
                return true;
            }, "Inspect code is not available until indices are ready");
            if (readActionSuccess == null || !readActionSuccess.booleanValue()) {
                throw new ProcessCanceledException();
            }
            boolean includeDoNotShow = this.includeDoNotShow(this.getCurrentProfile());
            List<InspectionToolWrapper> externalAnnotatable = ContainerUtil.concat(GlobalInspectionContextImpl.getWrappersFromTools(localTools, file2, includeDoNotShow, wrapper2 -> wrapper2.getTool() instanceof ExternalAnnotatorBatchInspection), GlobalInspectionContextImpl.getWrappersFromTools(globalSimpleTools, file2, includeDoNotShow, wrapper2 -> wrapper2.getTool() instanceof ExternalAnnotatorBatchInspection));
            externalAnnotatable.forEach(wrapper2 -> {
                ProblemDescriptor[] descriptors = ((ExternalAnnotatorBatchInspection)wrapper2.getTool()).checkFile((PsiFile)file2, this, inspectionManager);
                InspectionToolPresentation toolPresentation = this.getPresentation((InspectionToolWrapper)wrapper2);
                ReadAction.run(() -> BatchModeDescriptorsUtil.addProblemDescriptors(Arrays.asList(descriptors), false, this, null, CONVERT, toolPresentation));
            });
            return true;
        };
        try {
            LinkedBlockingQueue filesFailedToInspect = new LinkedBlockingQueue();
            while (true) {
                Disposable disposable2 = Disposer.newDisposable();
                DaemonProgressIndicator wrapper2 = new DaemonProgressIndicator();
                this.dependentIndicators.add(wrapper2);
                try {
                    ReadAction.run(() -> {
                        wrapper2.start();
                        ProgressIndicatorUtils.forceWriteActionPriority(wrapper2, disposable2);
                        if (ApplicationManagerEx.getApplicationEx().isWriteActionPending()) {
                            throw new ProcessCanceledException();
                        }
                    });
                    ((JobLauncherImpl)JobLauncher.getInstance()).processQueue(filesToInspect, filesFailedToInspect, wrapper2, TOMBSTONE, processor2);
                }
                catch (ProcessCanceledException e) {
                    progressIndicator2.checkCanceled();
                    assert (isOfflineInspections || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Must be outside read action. PCE=\n" + ExceptionUtil.getThrowableText(e);
                    assert (isOfflineInspections || !ApplicationManager.getApplication().isDispatchThread()) : "Must be outside EDT. PCE=\n" + ExceptionUtil.getThrowableText(e);
                    ApplicationManager.getApplication().runReadAction(EmptyRunnable.getInstance());
                    continue;
                }
                finally {
                    this.dependentIndicators.remove(wrapper2);
                    Disposer.dispose(disposable2);
                    continue;
                }
                break;
            }
        }
        finally {
            iteratingIndicator.cancel();
            filesToInspect.clear();
            try {
                future2.get(30L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.error("Thread dump: \n" + ThreadDumper.dumpThreadsToString(), e);
            }
        }
        ProgressManager.checkCanceled();
        for (Tools tools : globalSimpleTools) {
            GlobalInspectionToolWrapper toolWrapper = (GlobalInspectionToolWrapper)tools.getTool();
            GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
            ProblemDescriptionsProcessor problemDescriptionProcessor = this.getProblemDescriptionProcessor(toolWrapper, map2);
            tool.inspectionFinished(inspectionManager, this, problemDescriptionProcessor);
        }
        this.addProblemsToView(globalSimpleTools);
    }

    private static TextRange getEffectiveRange(SearchScope searchScope, PsiFile file2) {
        List<PsiElement> scopeFileElements;
        if (searchScope instanceof LocalSearchScope && !(scopeFileElements = ContainerUtil.filter(((LocalSearchScope)searchScope).getScope(), e -> e.getContainingFile() == file2)).isEmpty()) {
            int start2 = -1;
            int end = -1;
            for (PsiElement scopeElement : scopeFileElements) {
                TextRange elementRange = scopeElement.getTextRange();
                start2 = start2 == -1 ? elementRange.getStartOffset() : Math.min(elementRange.getStartOffset(), start2);
                end = end == -1 ? elementRange.getEndOffset() : Math.max(elementRange.getEndOffset(), end);
            }
            return new TextRange(start2, end);
        }
        return new TextRange(0, file2.getTextLength());
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.dependentIndicators.forEach(ProgressIndicator::cancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inspectFile(@NotNull PsiFile file2, @NotNull TextRange range2, @NotNull InspectionManager inspectionManager, @NotNull Map<String, InspectionToolWrapper> wrappersMap, @NotNull List<? extends GlobalInspectionToolWrapper> globalSimpleTools, @NotNull List<? extends LocalInspectionToolWrapper> localTools) {
        Document document;
        if (file2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(27);
        }
        if (range2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(28);
        }
        if (inspectionManager == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(29);
        }
        if (wrappersMap == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(30);
        }
        if (globalSimpleTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(31);
        }
        if (localTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(32);
        }
        if ((document = PsiDocumentManager.getInstance(this.getProject()).getDocument(file2)) == null) {
            return;
        }
        LocalInspectionsPass pass = new LocalInspectionsPass(file2, document, range2.getStartOffset(), range2.getEndOffset(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, HighlightInfoProcessor.getEmpty(), INSPECT_INJECTED_PSI);
        try {
            pass.doInspectInBatch(this, inspectionManager, localTools);
            GlobalInspectionContextImpl.assertUnderDaemonProgress();
            JobLauncher.getInstance().invokeConcurrentlyUnderProgress(globalSimpleTools, ProgressManager.getGlobalProgressIndicator(), toolWrapper -> {
                GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
                ProblemsHolder holder = new ProblemsHolder(inspectionManager, file2, false);
                ProblemDescriptionsProcessor problemDescriptionProcessor = this.getProblemDescriptionProcessor((GlobalInspectionToolWrapper)toolWrapper, wrappersMap);
                tool.checkFile(file2, inspectionManager, holder, this, problemDescriptionProcessor);
                InspectionToolPresentation toolPresentation = this.getPresentation((InspectionToolWrapper)toolWrapper);
                BatchModeDescriptorsUtil.addProblemDescriptors(holder.getResults(), false, this, null, CONVERT, toolPresentation);
                return true;
            });
            VirtualFile virtualFile2 = file2.getVirtualFile();
            String displayUrl = ProjectUtilCore.displayUrlRelativeToProject(virtualFile2, virtualFile2.getPresentableUrl(), this.getProject(), true, false);
            this.incrementJobDoneAmount(this.getStdJobDescriptors().LOCAL_ANALYSIS, displayUrl);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error("In file: " + file2.getViewProvider().getVirtualFile().getPath(), e);
        }
        finally {
            InjectedLanguageManager.getInstance(this.getProject()).dropFileCaches(file2);
        }
    }

    protected boolean includeDoNotShow(InspectionProfile profile) {
        return profile.getSingleTool() != null;
    }

    @NotNull
    private Future<?> startIterateScopeInBackground(final @NotNull AnalysisScope scope, final @Nullable Collection<? super VirtualFile> localScopeFiles, final boolean headlessEnvironment, final @NotNull BlockingQueue<? super PsiFile> outFilesToInspect, @NotNull ProgressIndicator progressIndicator2) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(33);
        }
        if (outFilesToInspect == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(34);
        }
        if (progressIndicator2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(35);
        }
        Task.Backgroundable task2 = new Task.Backgroundable(this.getProject(), InspectionsBundle.message("scanning.files.to.inspect.progress.text", new Object[0])){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance(this.getProject()).getFileIndex();
                    scope.accept(file2 -> {
                        ProgressManager.checkCanceled();
                        if (ProjectUtil.isProjectOrWorkspaceFile(file2) || !fileIndex.isInContent((VirtualFile)file2)) {
                            return true;
                        }
                        PsiFile psiFile = ReadAction.compute(() -> {
                            Document document;
                            if (this.getProject().isDisposed()) {
                                throw new ProcessCanceledException();
                            }
                            PsiFile psi = PsiManager.getInstance(this.getProject()).findFile((VirtualFile)file2);
                            Document document2 = document = psi == null ? null : GlobalInspectionContextImpl.this.shouldProcess(psi, headlessEnvironment, localScopeFiles);
                            if (document != null) {
                                return psi;
                            }
                            return null;
                        });
                        if (psiFile != null) {
                            try {
                                if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                                    throw new IllegalStateException("Must not have read action");
                                }
                                outFilesToInspect.put(psiFile);
                            }
                            catch (InterruptedException e) {
                                LOG.error(e);
                            }
                        }
                        ProgressManager.checkCanceled();
                        return true;
                    });
                }
                catch (ProcessCanceledException e) {
                }
                finally {
                    try {
                        outFilesToInspect.put(TOMBSTONE);
                    }
                    catch (InterruptedException e) {
                        LOG.error(e);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$2", "run"));
            }
        };
        Future<?> future2 = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task2, progressIndicator2, null);
        if (future2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(36);
        }
        return future2;
    }

    private Document shouldProcess(@NotNull PsiFile file2, boolean headlessEnvironment, @Nullable Collection<? super VirtualFile> localScopeFiles) {
        VirtualFile virtualFile2;
        if (file2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(37);
        }
        if ((virtualFile2 = file2.getVirtualFile()) == null) {
            return null;
        }
        if (GlobalInspectionContextImpl.isBinary(file2)) {
            return null;
        }
        if (this.myViewClosed && !headlessEnvironment) {
            throw new ProcessCanceledException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running local inspections on " + virtualFile2.getPath());
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile2)) {
            return null;
        }
        if (localScopeFiles != null && !localScopeFiles.add(virtualFile2)) {
            return null;
        }
        if (!ProblemHighlightFilter.shouldProcessFileInBatch(file2)) {
            return null;
        }
        return PsiDocumentManager.getInstance(this.getProject()).getDocument(file2);
    }

    private void runGlobalTools(@NotNull AnalysisScope scope, @NotNull InspectionManager inspectionManager, @NotNull List<? extends Tools> globalTools, boolean isOfflineInspections) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(38);
        }
        if (inspectionManager == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(39);
        }
        if (globalTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(40);
        }
        LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed() || isOfflineInspections, "Must not run under read action, too unresponsive");
        ArrayList<InspectionToolWrapper> needRepeatSearchRequest = new ArrayList<InspectionToolWrapper>();
        SearchScope initialSearchScope = ReadAction.compute(() -> scope.toSearchScope());
        boolean canBeExternalUsages = scope.getScopeType() != 1 || !scope.isIncludeTestSource();
        for (Tools tools : globalTools) {
            for (ScopeToolState state : tools.getTools()) {
                NamedScope stateScope;
                if (!state.isEnabled() || (stateScope = state.getScope(this.getProject())) == null) continue;
                AnalysisScope scopeForState = new AnalysisScope(GlobalSearchScopesCore.filterScope(this.getProject(), stateScope).intersectWith(initialSearchScope), this.getProject());
                InspectionToolWrapper<?, ?> toolWrapper = state.getTool();
                GlobalInspectionTool tool = (GlobalInspectionTool)toolWrapper.getTool();
                InspectionToolPresentation toolPresentation = this.getPresentation(toolWrapper);
                try {
                    if (tool.isGraphNeeded()) {
                        try {
                            ((RefManagerImpl)this.getRefManager()).findAllDeclarations();
                        }
                        catch (Throwable e) {
                            this.getStdJobDescriptors().BUILD_GRAPH.setDoneAmount(0);
                            throw e;
                        }
                    }
                    ThrowableRunnable runnable2 = () -> {
                        tool.runInspection(scopeForState, inspectionManager, this, toolPresentation);
                        if ((canBeExternalUsages || tool.getAdditionalJobs(this) != null) && tool.queryExternalUsagesRequests(inspectionManager, this, toolPresentation)) {
                            needRepeatSearchRequest.add(toolWrapper);
                        }
                    };
                    if (tool.isReadActionNeeded()) {
                        ReadAction.run(runnable2);
                        continue;
                    }
                    runnable2.run();
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        for (GlobalInspectionContextExtension globalInspectionContextExtension : this.myExtensions.values()) {
            try {
                globalInspectionContextExtension.performPostRunActivities(needRepeatSearchRequest, this);
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.addProblemsToView(globalTools);
    }

    public ActionCallback initializeViewIfNeeded() {
        if (this.myView != null) {
            return ActionCallback.DONE;
        }
        return ApplicationManager.getApplication().getInvokator().invokeLater(() -> {
            if (this.getCurrentScope() == null) {
                return;
            }
            InspectionResultsView view = this.getView();
            if (view == null) {
                view = new InspectionResultsView(this, new InspectionRVContentProviderImpl());
                this.addView(view);
            }
        }, x -> this.getCurrentScope() == null);
    }

    private void appendPairedInspectionsForUnfairTools(@NotNull List<? super Tools> globalTools, @NotNull List<? super Tools> globalSimpleTools, @NotNull List<Tools> localTools) {
        Tools[] larray;
        if (globalTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(41);
        }
        if (globalSimpleTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(42);
        }
        if (localTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(43);
        }
        for (Tools tool : larray = localTools.toArray(new Tools[0])) {
            InspectionToolWrapper batchInspection;
            LocalInspectionToolWrapper toolWrapper = (LocalInspectionToolWrapper)tool.getTool();
            LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
            if (!(localTool instanceof PairedUnfairLocalInspectionTool)) continue;
            String batchShortName = ((PairedUnfairLocalInspectionTool)((Object)localTool)).getInspectionForBatchShortName();
            InspectionProfileImpl currentProfile = this.getCurrentProfile();
            InspectionToolWrapper pairedWrapper = currentProfile.getInspectionTool(batchShortName, this.getProject());
            InspectionToolWrapper inspectionToolWrapper = batchInspection = pairedWrapper != null ? pairedWrapper.createCopy() : null;
            if (batchInspection == null || this.getTools().containsKey(batchShortName)) continue;
            Object batchTool = batchInspection.getTool();
            ScopeToolState defaultState = tool.getDefaultState();
            ToolsImpl newTool = new ToolsImpl(batchInspection, defaultState.getLevel(), true, defaultState.isEnabled());
            for (ScopeToolState state : tool.getTools()) {
                NamedScope scope = state.getScope(this.getProject());
                if (scope == null) continue;
                newTool.addTool(scope, batchInspection, state.isEnabled(), state.getLevel());
            }
            if (batchTool instanceof LocalInspectionTool) {
                localTools.add(newTool);
            } else if (batchTool instanceof GlobalSimpleInspectionTool) {
                globalSimpleTools.add(newTool);
            } else if (batchTool instanceof GlobalInspectionTool) {
                globalTools.add(newTool);
            } else {
                throw new AssertionError(batchTool);
            }
            this.myTools.put(batchShortName, newTool);
            batchInspection.initialize(this);
        }
    }

    @NotNull
    private static <T extends InspectionToolWrapper> List<T> getWrappersFromTools(@NotNull List<? extends Tools> localTools, @NotNull PsiFile file2, boolean includeDoNotShow, @NotNull Predicate<? super T> filter2) {
        if (localTools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(44);
        }
        if (file2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(45);
        }
        if (filter2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(46);
        }
        List<InspectionToolWrapper> list2 = ContainerUtil.mapNotNull(localTools, tool -> {
            InspectionToolWrapper<?, ?> unwrapped = tool.getEnabledTool(file2, includeDoNotShow);
            if (unwrapped == null) {
                return null;
            }
            return filter2.test(unwrapped) ? unwrapped : null;
        });
        if (list2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(47);
        }
        return list2;
    }

    @NotNull
    private ProblemDescriptionsProcessor getProblemDescriptionProcessor(final @NotNull GlobalInspectionToolWrapper toolWrapper, final @NotNull Map<String, InspectionToolWrapper> wrappersMap) {
        if (toolWrapper == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(48);
        }
        if (wrappersMap == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(49);
        }
        return new ProblemDescriptionsProcessor(){

            @Override
            public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                if (commonProblemDescriptors == null) {
                    3.$$$reportNull$$$0(0);
                }
                for (CommonProblemDescriptor problemDescriptor : commonProblemDescriptors) {
                    GlobalInspectionToolWrapper targetWrapper;
                    if (!(problemDescriptor instanceof ProblemDescriptor) || SuppressionUtil.inspectionResultSuppressed(((ProblemDescriptor)problemDescriptor).getPsiElement(), toolWrapper.getTool())) continue;
                    ProblemGroup problemGroup = ((ProblemDescriptor)problemDescriptor).getProblemGroup();
                    InspectionToolWrapper inspectionToolWrapper = targetWrapper = problemGroup == null ? toolWrapper : (InspectionToolWrapper)wrappersMap.get(problemGroup.getProblemName());
                    if (targetWrapper == null) continue;
                    InspectionToolPresentation toolPresentation = GlobalInspectionContextImpl.this.getPresentation(targetWrapper);
                    toolPresentation.addProblemElement(refEntity, problemDescriptor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonProblemDescriptors", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$3", "addProblemElement"));
            }
        };
    }

    @NotNull
    private static Map<String, InspectionToolWrapper> getInspectionWrappersMap(@NotNull List<? extends Tools> tools) {
        if (tools == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(50);
        }
        HashMap<String, InspectionToolWrapper> name2Inspection = new HashMap<String, InspectionToolWrapper>(tools.size());
        for (Tools tools2 : tools) {
            InspectionToolWrapper<?, ?> toolWrapper = tools2.getTool();
            name2Inspection.put(toolWrapper.getShortName(), toolWrapper);
        }
        HashMap<String, InspectionToolWrapper> hashMap = name2Inspection;
        if (hashMap == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(51);
        }
        return hashMap;
    }

    @Override
    public void close(boolean noSuspiciousCodeFound) {
        if (!noSuspiciousCodeFound) {
            if (this.myView.isRerun()) {
                this.myViewClosed = true;
                this.myView = null;
            }
            if (this.myView == null) {
                return;
            }
        }
        if (this.myContent != null) {
            ContentManager contentManager2 = this.getContentManager();
            contentManager2.removeContent(this.myContent, true);
        }
        this.myViewClosed = true;
        this.myView = null;
        ((InspectionManagerEx)InspectionManager.getInstance(this.getProject())).closeRunningContext(this);
        this.myPresentationMap.clear();
        super.close(noSuspiciousCodeFound);
    }

    @Override
    public void cleanup() {
        if (this.myView != null) {
            this.myView.setUpdating(false);
        } else {
            this.myPresentationMap.clear();
            super.cleanup();
        }
    }

    public void refreshViews() {
        if (this.myView != null) {
            this.myView.getTree().getInspectionTreeModel().reload();
        }
    }

    @Nullable
    private InspectionToolPresentation getPresentationOrNull(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(52);
        }
        return (InspectionToolPresentation)this.myPresentationMap.get(toolWrapper);
    }

    @NotNull
    public InspectionToolPresentation getPresentation(@NotNull InspectionToolWrapper toolWrapper) {
        InspectionToolPresentation presentation;
        if (toolWrapper == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(53);
        }
        if ((presentation = (InspectionToolPresentation)this.myPresentationMap.get(toolWrapper)) == null) {
            String presentationClass = StringUtil.notNullize(toolWrapper.myEP == null ? null : ((InspectionEP)toolWrapper.myEP).presentation, DefaultInspectionToolPresentation.class.getName());
            try {
                Object extension = toolWrapper.getExtension();
                ClassLoader classLoader = extension == null ? this.getClass().getClassLoader() : ((BaseKeyedLazyInstance)extension).getLoaderForClass();
                Constructor<?> constructor2 = Class.forName(presentationClass, true, classLoader).getConstructor(InspectionToolWrapper.class, GlobalInspectionContextImpl.class);
                presentation = (InspectionToolPresentation)constructor2.newInstance(toolWrapper, this);
            }
            catch (Exception e) {
                LOG.error(e);
                throw new RuntimeException(e);
            }
            presentation = ConcurrencyUtil.cacheOrGet(this.myPresentationMap, toolWrapper, presentation);
        }
        InspectionToolPresentation inspectionToolPresentation = presentation;
        if (inspectionToolPresentation == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(54);
        }
        return inspectionToolPresentation;
    }

    @Override
    public void codeCleanup(final @NotNull AnalysisScope scope, final @NotNull InspectionProfile profile, final @Nullable String commandName, final @Nullable Runnable postRunnable, boolean modal, final @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix) {
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(55);
        }
        if (profile == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(56);
        }
        if (shouldApplyFix == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(57);
        }
        String title = "Inspect Code...";
        Task task2 = modal ? new Task.Modal(this.getProject(), title, true){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                GlobalInspectionContextImpl.this.cleanup(scope, profile, postRunnable, commandName, shouldApplyFix, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$4", "run"));
            }
        } : new Task.Backgroundable(this.getProject(), title, true){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                GlobalInspectionContextImpl.this.cleanup(scope, profile, postRunnable, commandName, shouldApplyFix, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$5", "run"));
            }
        };
        ProgressManager.getInstance().run(task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(@NotNull AnalysisScope scope, @NotNull InspectionProfile profile, @Nullable Runnable postRunnable, @Nullable String commandName, final @NotNull Predicate<? super ProblemDescriptor> shouldApplyFix, final @NotNull ProgressIndicator progressIndicator2) {
        PsiElement[] elements2;
        if (scope == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(58);
        }
        if (profile == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(59);
        }
        if (shouldApplyFix == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(60);
        }
        if (progressIndicator2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(61);
        }
        this.setCurrentScope(scope);
        final int fileCount = scope.getFileCount();
        progressIndicator2.setIndeterminate(false);
        final SearchScope searchScope = ReadAction.compute(scope::toSearchScope);
        final TextRange range2 = searchScope instanceof LocalSearchScope ? ((elements2 = ((LocalSearchScope)searchScope).getScope()).length == 1 ? ReadAction.compute(elements2[0]::getTextRange) : null) : null;
        final List<Tools> inspectionTools = ContainerUtil.filter(profile.getAllEnabledInspectionTools(this.getProject()), tools -> {
            assert (tools != null);
            return tools.getTool().isCleanupTool();
        });
        final boolean includeDoNotShow = this.includeDoNotShow(profile);
        RefManagerImpl refManager = (RefManagerImpl)this.getRefManager();
        refManager.inspectionReadActionStarted();
        final ArrayList descriptors = new ArrayList();
        final HashSet files2 = new HashSet();
        try {
            scope.accept(new PsiElementVisitor(){
                private int myCount;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void visitFile(@NotNull PsiFile file2) {
                    if (file2 == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    progressIndicator2.setFraction((double)(++this.myCount) / (double)fileCount);
                    if (GlobalInspectionContextImpl.isBinary(file2)) {
                        return;
                    }
                    ArrayList<LocalInspectionToolWrapper> lTools = new ArrayList<LocalInspectionToolWrapper>();
                    for (Tools tools : inspectionTools) {
                        LocalInspectionToolWrapper tool = tools.getEnabledTool(file2, includeDoNotShow);
                        if (tool instanceof GlobalInspectionToolWrapper) {
                            tool = ((GlobalInspectionToolWrapper)((Object)tool)).getSharedLocalInspectionToolWrapper();
                        }
                        if (tool == null) continue;
                        lTools.add(tool);
                        tool.initialize(GlobalInspectionContextImpl.this);
                    }
                    if (!lTools.isEmpty()) {
                        try {
                            LocalInspectionsPass pass = new LocalInspectionsPass(file2, PsiDocumentManager.getInstance(GlobalInspectionContextImpl.this.getProject()).getDocument(file2), range2 != null ? range2.getStartOffset() : 0, range2 != null ? range2.getEndOffset() : file2.getTextLength(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, HighlightInfoProcessor.getEmpty(), true);
                            Runnable runnable2 = () -> pass.doInspectInBatch(GlobalInspectionContextImpl.this, InspectionManager.getInstance(GlobalInspectionContextImpl.this.getProject()), lTools);
                            ApplicationManager.getApplication().runReadAction(runnable2);
                            TreeSet<CommonProblemDescriptor> localDescriptors = new TreeSet<CommonProblemDescriptor>(CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
                            for (LocalInspectionToolWrapper localInspectionToolWrapper : lTools) {
                                InspectionToolPresentation toolPresentation = GlobalInspectionContextImpl.this.getPresentation(localInspectionToolWrapper);
                                for (CommonProblemDescriptor descriptor2 : toolPresentation.getProblemDescriptors()) {
                                    if (!(descriptor2 instanceof ProblemDescriptor)) continue;
                                    localDescriptors.add((ProblemDescriptor)descriptor2);
                                }
                            }
                            if (searchScope instanceof LocalSearchScope) {
                                Iterator iterator2 = localDescriptors.iterator();
                                while (iterator2.hasNext()) {
                                    ProblemDescriptor problemDescriptor = (ProblemDescriptor)iterator2.next();
                                    TextRange infoRange = problemDescriptor instanceof ProblemDescriptorBase ? ((ProblemDescriptorBase)problemDescriptor).getTextRange() : null;
                                    if (infoRange == null || ((LocalSearchScope)searchScope).containsRange(file2, infoRange)) continue;
                                    iterator2.remove();
                                }
                            }
                            if (!localDescriptors.isEmpty()) {
                                for (ProblemDescriptor problemDescriptor : localDescriptors) {
                                    if (!shouldApplyFix.test(problemDescriptor)) continue;
                                    descriptors.add(problemDescriptor);
                                }
                                files2.add(file2);
                            }
                        }
                        finally {
                            GlobalInspectionContextImpl.this.myPresentationMap.clear();
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$6", "visitFile"));
                }
            });
        }
        finally {
            refManager.inspectionReadActionFinished();
        }
        if (files2.isEmpty()) {
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (commandName != null) {
                    NOTIFICATION_GROUP.createNotification(InspectionsBundle.message("inspection.no.problems.message", scope.getFileCount(), scope.getDisplayName()), MessageType.INFO).notify(this.getProject());
                }
                if (postRunnable != null) {
                    postRunnable.run();
                }
            }, ModalityState.defaultModalityState());
            return;
        }
        Runnable runnable2 = () -> {
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(files2)) {
                return;
            }
            CleanupInspectionUtil.getInstance().applyFixesNoSort(this.getProject(), "Code Cleanup", descriptors, null, false, searchScope instanceof GlobalSearchScope);
            if (postRunnable != null) {
                postRunnable.run();
            }
        };
        TransactionGuard.submitTransaction(this.getProject(), runnable2);
    }

    private static boolean isBinary(@NotNull PsiFile file2) {
        if (file2 == null) {
            GlobalInspectionContextImpl.$$$reportNull$$$0(62);
        }
        return file2 instanceof PsiBinaryFile || file2.getFileType().isBinary();
    }

    public boolean isViewClosed() {
        return this.myViewClosed;
    }

    private void addProblemsToView(List<? extends Tools> tools) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !TESTING_VIEW) {
            return;
        }
        if (this.myView == null && !ReadAction.compute(() -> InspectionResultsView.hasProblems(tools, this, new InspectionRVContentProviderImpl())).booleanValue()) {
            return;
        }
        this.initializeViewIfNeeded().doWhenDone(() -> this.myView.addTools(tools));
    }

    static {
        NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup("Inspection Results", "Inspection Results");
        TOMBSTONE = PsiUtilCore.NULL_PSI_FILE;
        CONVERT = (tool, elt, context) -> {
            PsiNamedElement problemElement = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType(elt, PsiFile.class);
            RefElement refElement = context.getRefManager().getReference(problemElement);
            if (refElement == null && problemElement != null) {
                refElement = GlobalInspectionContextUtil.retrieveRefElement(elt, context);
            }
            return refElement;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 22: 
            case 23: 
            case 36: 
            case 47: 
            case 51: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 22: 
            case 23: 
            case 36: 
            case 47: 
            case 51: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 2: 
            case 22: 
            case 23: 
            case 36: 
            case 47: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/GlobalInspectionContextImpl";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 38: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsResults";
                break;
            }
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspections";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 27: 
            case 37: 
            case 45: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 30: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappersMap";
                break;
            }
            case 31: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalSimpleTools";
                break;
            }
            case 32: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTools";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outFilesToInspect";
                break;
            }
            case 35: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalTools";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 48: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldApplyFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/GlobalInspectionContextImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManager";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getUIOptions";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createToggleAutoscrollAction";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "startIterateScopeInBackground";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrappersFromTools";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionWrappersMap";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 22: 
            case 23: 
            case 36: 
            case 47: 
            case 51: 
            case 54: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addView";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doInspections";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "launchInspectionsOffline";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performInspectionsWithProgressAndExportResults";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "exportResults";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "exportResultsSmart";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveElement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementRecursively";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "launchInspections";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "notifyInspectionsFinished";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "runTools";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "inspectFile";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "startIterateScopeInBackground";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcess";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "runGlobalTools";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "appendPairedInspectionsForUnfairTools";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getWrappersFromTools";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getProblemDescriptionProcessor";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionWrappersMap";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationOrNull";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "codeCleanup";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isBinary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 22: 
            case 23: 
            case 36: 
            case 47: 
            case 51: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

