/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolsRegistrarCore;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InspectionToolRegistrar
extends InspectionToolsSupplier {
    private static final Logger LOG = Logger.getInstance(InspectionToolRegistrar.class);
    @NotNull
    private final NotNullLazyValue<Collection<? extends Supplier<InspectionToolWrapper>>> myInspectionToolFactories = NotNullLazyValue.createValue(() -> {
        Application application = ApplicationManager.getApplication();
        MultiMap<Object, Supplier<InspectionToolWrapper>> factories = MultiMap.create();
        THashMap<String, InspectionEP> shortNames = new THashMap<String, InspectionEP>();
        this.registerToolProviders(application, factories);
        this.registerInspections(factories, application, shortNames, LocalInspectionEP.LOCAL_INSPECTION);
        this.registerInspections(factories, application, shortNames, InspectionEP.GLOBAL_INSPECTION);
        return factories.values();
    });

    private void unregisterInspectionOrProvider(@NotNull Object inspectionOrProvider, @NotNull MultiMap<Object, Supplier<InspectionToolWrapper>> factories) {
        Collection<Supplier<InspectionToolWrapper>> removedTools;
        if (inspectionOrProvider == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(0);
        }
        if (factories == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(1);
        }
        if ((removedTools = factories.remove(inspectionOrProvider)) != null) {
            for (Supplier<InspectionToolWrapper> removedTool : removedTools) {
                this.fireToolRemoved(removedTool);
            }
        }
    }

    private <T extends InspectionEP> void registerInspections(final @NotNull MultiMap<Object, Supplier<InspectionToolWrapper>> factories, @NotNull Application application, final @NotNull Map<String, InspectionEP> shortNames, @NotNull ExtensionPointName<T> extensionPointName) {
        if (factories == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(2);
        }
        if (application == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(3);
        }
        if (shortNames == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(4);
        }
        if (extensionPointName == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(5);
        }
        final boolean isInternal = application.isInternal();
        for (InspectionEP extension : extensionPointName.getExtensionList()) {
            InspectionToolRegistrar.registerInspection(extension, shortNames, isInternal, factories);
        }
        extensionPointName.getPoint(application).addExtensionPointListener(new ExtensionPointListener<T>(){

            @Override
            public void extensionAdded(@NotNull T inspection, @NotNull PluginDescriptor pluginDescriptor) {
                if (inspection == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                InspectionToolRegistrar.this.fireToolAdded(InspectionToolRegistrar.registerInspection(inspection, shortNames, isInternal, factories));
            }

            @Override
            public void extensionRemoved(@NotNull T inspection, @NotNull PluginDescriptor pluginDescriptor) {
                if (inspection == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                InspectionToolRegistrar.this.unregisterInspectionOrProvider(inspection, factories);
                shortNames.remove(((InspectionEP)inspection).getShortName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inspection";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionToolRegistrar$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, (Disposable)application);
    }

    private static <T extends InspectionEP> Supplier<InspectionToolWrapper> registerInspection(@NotNull T inspection, @NotNull Map<String, InspectionEP> shortNames, boolean isInternal, @NotNull MultiMap<Object, Supplier<InspectionToolWrapper>> factories) {
        if (inspection == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(6);
        }
        if (shortNames == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(7);
        }
        if (factories == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(8);
        }
        InspectionToolRegistrar.checkForDuplicateShortName(inspection, shortNames);
        if (!isInternal && inspection.isInternal) {
            return null;
        }
        Supplier<InspectionToolWrapper> inspectionFactory = () -> inspection instanceof LocalInspectionEP ? new LocalInspectionToolWrapper((LocalInspectionEP)inspection) : new GlobalInspectionToolWrapper(inspection);
        factories.putValue(inspection, inspectionFactory);
        return inspectionFactory;
    }

    private void registerToolProviders(@NotNull Application application, final @NotNull MultiMap<Object, Supplier<InspectionToolWrapper>> factories) {
        if (application == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(9);
        }
        if (factories == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(10);
        }
        for (InspectionToolProvider provider : application.getComponentInstancesOfType(InspectionToolProvider.class)) {
            InspectionToolRegistrar.registerToolProvider(provider, factories);
        }
        for (InspectionToolProvider provider : InspectionToolProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            InspectionToolRegistrar.registerToolProvider(provider, factories);
        }
        InspectionToolProvider.EXTENSION_POINT_NAME.getPoint(application).addExtensionPointListener(new ExtensionPointListener<InspectionToolProvider>(){

            @Override
            public void extensionAdded(@NotNull InspectionToolProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
                if (provider == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                for (Supplier supplier : InspectionToolRegistrar.registerToolProvider(provider, factories)) {
                    InspectionToolRegistrar.this.fireToolAdded(supplier);
                }
            }

            @Override
            public void extensionRemoved(@NotNull InspectionToolProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
                if (provider == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                InspectionToolRegistrar.this.unregisterInspectionOrProvider(provider, factories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionToolRegistrar$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, (Disposable)application);
    }

    private static Collection<Supplier<InspectionToolWrapper>> registerToolProvider(@NotNull InspectionToolProvider provider, @NotNull MultiMap<Object, Supplier<InspectionToolWrapper>> factories) {
        if (provider == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(11);
        }
        if (factories == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(12);
        }
        SmartList<Supplier<InspectionToolWrapper>> suppliers = new SmartList<Supplier<InspectionToolWrapper>>();
        for (Class<? extends LocalInspectionTool> aClass : provider.getInspectionClasses()) {
            suppliers.add(() -> ObjectUtils.doIfNotNull(InspectionToolsRegistrarCore.instantiateTool(aClass), e -> InspectionToolRegistrar.wrapTool(e)));
        }
        factories.putValues(provider, suppliers);
        return suppliers;
    }

    private static void checkForDuplicateShortName(InspectionEP ep, Map<String, InspectionEP> shortNames) {
        String shortName = ep.getShortName();
        InspectionEP duplicate = shortNames.put(shortName, ep);
        if (duplicate != null) {
            PluginDescriptor descriptor2 = ep.getPluginDescriptor();
            LOG.error(new PluginException("Short name '" + shortName + "' is not unique\nclass '" + ep.instantiateTool().getClass().getCanonicalName() + "' in " + descriptor2 + "\nand\nclass'" + duplicate.instantiateTool().getClass().getCanonicalName() + "' in " + duplicate.getPluginDescriptor() + "\nconflict", descriptor2.getPluginId()));
        }
    }

    @NotNull
    public static InspectionToolWrapper wrapTool(@NotNull InspectionProfileEntry profileEntry) {
        if (profileEntry == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(13);
        }
        if (profileEntry instanceof LocalInspectionTool) {
            return new LocalInspectionToolWrapper((LocalInspectionTool)profileEntry);
        }
        if (profileEntry instanceof GlobalInspectionTool) {
            return new GlobalInspectionToolWrapper((GlobalInspectionTool)profileEntry);
        }
        throw new RuntimeException("unknown inspection class: " + profileEntry + "; " + profileEntry.getClass());
    }

    public static InspectionToolRegistrar getInstance() {
        return ServiceManager.getService(InspectionToolRegistrar.class);
    }

    private void fireToolAdded(@Nullable Supplier<InspectionToolWrapper> supplier) {
        InspectionToolWrapper inspectionToolWrapper;
        InspectionToolWrapper inspectionToolWrapper2 = inspectionToolWrapper = supplier != null ? supplier.get() : null;
        if (inspectionToolWrapper != null) {
            for (InspectionToolsSupplier.Listener listener2 : this.myListeners) {
                listener2.toolAdded(inspectionToolWrapper);
            }
        }
    }

    private void fireToolRemoved(@Nullable Supplier<InspectionToolWrapper> supplier) {
        InspectionToolWrapper inspectionToolWrapper;
        InspectionToolWrapper inspectionToolWrapper2 = inspectionToolWrapper = supplier != null ? supplier.get() : null;
        if (inspectionToolWrapper != null) {
            for (InspectionToolsSupplier.Listener listener2 : this.myListeners) {
                listener2.toolRemoved(inspectionToolWrapper);
            }
        }
    }

    @Override
    @NotNull
    public List<InspectionToolWrapper> createTools() {
        Collection<? extends Supplier<InspectionToolWrapper>> inspectionToolFactories = this.myInspectionToolFactories.getValue();
        ArrayList<InspectionToolWrapper> tools = new ArrayList<InspectionToolWrapper>(inspectionToolFactories.size());
        for (Supplier<InspectionToolWrapper> supplier : inspectionToolFactories) {
            ProgressManager.checkCanceled();
            InspectionToolWrapper toolWrapper = supplier.get();
            if (toolWrapper == null || InspectionToolRegistrar.checkTool(toolWrapper) != null) continue;
            tools.add(toolWrapper);
        }
        ArrayList<InspectionToolWrapper> arrayList = tools;
        if (arrayList == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    @NotNull
    public List<InspectionToolWrapper> get() {
        List<InspectionToolWrapper> list2 = this.createTools();
        if (list2 == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(15);
        }
        return list2;
    }

    private static String checkTool(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            InspectionToolRegistrar.$$$reportNull$$$0(16);
        }
        if (!(toolWrapper instanceof LocalInspectionToolWrapper)) {
            return null;
        }
        String message = null;
        try {
            String id2 = toolWrapper.getID();
            if (id2 == null || !LocalInspectionTool.isValidID(id2)) {
                message = AnalysisBundle.message("inspection.disabled.wrong.id", toolWrapper.getShortName(), id2, "[a-zA-Z_0-9.-]+");
            }
        }
        catch (Throwable t) {
            message = AnalysisBundle.message("inspection.disabled.error", toolWrapper.getShortName(), t.getMessage());
        }
        if (message != null) {
            LOG.error(message);
        }
        return message;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionOrProvider";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factories";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileEntry";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionToolRegistrar";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionToolRegistrar";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTools";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unregisterInspectionOrProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerInspections";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerInspection";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerToolProviders";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerToolProvider";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "wrapTool";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkTool";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

