/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.PerformFixesModalTask;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashSet;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class QuickFixAction
extends AnAction
implements CustomComponentAction {
    private static final Logger LOG = Logger.getInstance(QuickFixAction.class);
    public static final QuickFixAction[] EMPTY = new QuickFixAction[0];
    protected final InspectionToolWrapper myToolWrapper;

    protected static InspectionResultsView getInvoker(@NotNull AnActionEvent e) {
        if (e == null) {
            QuickFixAction.$$$reportNull$$$0(0);
        }
        return e.getData(InspectionResultsView.DATA_KEY);
    }

    protected QuickFixAction(String text2, @NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(1);
        }
        this(text2, AllIcons.Actions.IntentionBulb, null, toolWrapper);
    }

    protected QuickFixAction(String text2, Icon icon2, KeyStroke keyStroke, @NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(2);
        }
        super(text2, null, icon2);
        this.myToolWrapper = toolWrapper;
        if (keyStroke != null) {
            this.registerCustomShortcutSet(new CustomShortcutSet(keyStroke), null);
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        InspectionResultsView view;
        if (e == null) {
            QuickFixAction.$$$reportNull$$$0(3);
        }
        if ((view = QuickFixAction.getInvoker(e)) == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(false);
        InspectionTree tree = view.getTree();
        InspectionToolWrapper toolWrapper = tree.getSelectedToolWrapper(true);
        if (!view.isSingleToolInSelection() || toolWrapper != this.myToolWrapper) {
            return;
        }
        if (!this.isProblemDescriptorsAcceptable() && tree.getSelectedElements().length > 0 || this.isProblemDescriptorsAcceptable() && tree.getSelectedDescriptors().length > 0) {
            e.getPresentation().setEnabledAndVisible(true);
        }
    }

    protected boolean isProblemDescriptorsAcceptable() {
        return false;
    }

    public String getText() {
        return this.getTemplatePresentation().getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            QuickFixAction.$$$reportNull$$$0(4);
        }
        InspectionResultsView view = QuickFixAction.getInvoker(e);
        InspectionTree tree = view.getTree();
        try {
            Ref descriptors = Ref.create();
            THashSet readOnlyFiles = new THashSet();
            TreePath[] paths = tree.getSelectionPaths();
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                indicator.setText(InspectionsBundle.message("quick.fix.action.checking.problem.progress", new Object[0]));
                descriptors.set(tree.getSelectedDescriptorPacks(true, readOnlyFiles, false, paths));
            }), InspectionsBundle.message("preparing.for.apply.fix", new Object[0]), true, e.getProject())) {
                return;
            }
            if (this.isProblemDescriptorsAcceptable() && ((List)descriptors.get()).size() > 0) {
                this.doApplyFix(view.getProject(), (List)descriptors.get(), readOnlyFiles, tree.getContext());
            } else {
                this.doApplyFix(QuickFixAction.getSelectedElements(view), view);
            }
            view.getTree().removeSelectedProblems();
        }
        finally {
            view.setApplyingFix(false);
        }
    }

    protected void applyFix(@NotNull Project project2, @NotNull GlobalInspectionContextImpl context, CommonProblemDescriptor @NotNull [] descriptors, @NotNull Set<? super PsiElement> ignoredElements) {
        if (project2 == null) {
            QuickFixAction.$$$reportNull$$$0(5);
        }
        if (context == null) {
            QuickFixAction.$$$reportNull$$$0(6);
        }
        if (ignoredElements == null) {
            QuickFixAction.$$$reportNull$$$0(7);
        }
        if (descriptors == null) {
            QuickFixAction.$$$reportNull$$$0(8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplyFix(@NotNull Project project2, @NotNull List<CommonProblemDescriptor[]> descriptors, @NotNull Set<? extends VirtualFile> readOnlyFiles, @NotNull GlobalInspectionContextImpl context) {
        if (project2 == null) {
            QuickFixAction.$$$reportNull$$$0(9);
        }
        if (descriptors == null) {
            QuickFixAction.$$$reportNull$$$0(10);
        }
        if (readOnlyFiles == null) {
            QuickFixAction.$$$reportNull$$$0(11);
        }
        if (context == null) {
            QuickFixAction.$$$reportNull$$$0(12);
        }
        if (!FileModificationService.getInstance().prepareVirtualFilesForWrite(project2, readOnlyFiles)) {
            return;
        }
        RefManagerImpl refManager = (RefManagerImpl)context.getRefManager();
        boolean initial = refManager.isInProcess();
        refManager.inspectionReadActionFinished();
        try {
            HashSet resolvedElements = new HashSet();
            this.performFixesInBatch(project2, descriptors, context, resolvedElements);
            QuickFixAction.refreshViews(project2, resolvedElements, this.myToolWrapper);
        }
        finally {
            if (initial) {
                refManager.inspectionReadActionStarted();
            }
        }
    }

    protected boolean startInWriteAction() {
        return false;
    }

    protected void performFixesInBatch(@NotNull Project project2, @NotNull List<CommonProblemDescriptor[]> descriptors, @NotNull GlobalInspectionContextImpl context, Set<? super PsiElement> ignoredElements) {
        if (project2 == null) {
            QuickFixAction.$$$reportNull$$$0(13);
        }
        if (descriptors == null) {
            QuickFixAction.$$$reportNull$$$0(14);
        }
        if (context == null) {
            QuickFixAction.$$$reportNull$$$0(15);
        }
        String templatePresentationText = this.getTemplatePresentation().getText();
        assert (templatePresentationText != null);
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
            boolean startInWriteAction = this.startInWriteAction();
            PerformFixesTask performFixesTask = new PerformFixesTask(project2, descriptors, ignoredElements, context);
            if (startInWriteAction) {
                ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread(templatePresentationText, project2, null, performFixesTask::doRun);
            } else {
                SequentialModalProgressTask progressTask2 = new SequentialModalProgressTask(project2, templatePresentationText, true);
                progressTask2.setMinIterationTime(200L);
                progressTask2.setTask(performFixesTask);
                ProgressManager.getInstance().run(progressTask2);
            }
        }, templatePresentationText, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApplyFix(RefEntity @NotNull [] refElements, @NotNull InspectionResultsView view) {
        if (view == null) {
            QuickFixAction.$$$reportNull$$$0(16);
        }
        if (refElements == null) {
            QuickFixAction.$$$reportNull$$$0(17);
        }
        RefManagerImpl refManager = (RefManagerImpl)view.getGlobalInspectionContext().getRefManager();
        boolean initial = refManager.isInProcess();
        refManager.inspectionReadActionFinished();
        try {
            boolean[] refreshNeeded = new boolean[]{false};
            if (refElements.length > 0) {
                Project project2 = refElements[0].getRefManager().getProject();
                CommandProcessor.getInstance().executeCommand(project2, () -> {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        refreshNeeded[0] = this.applyFix(refElements);
                    });
                }, this.getTemplatePresentation().getText(), null);
            }
            if (refreshNeeded[0]) {
                QuickFixAction.refreshViews(view.getProject(), refElements, this.myToolWrapper);
            }
        }
        finally {
            if (initial) {
                refManager.inspectionReadActionStarted();
            }
        }
    }

    public static void removeElements(RefEntity @NotNull [] refElements, @NotNull Project project2, @NotNull InspectionToolWrapper toolWrapper) {
        if (project2 == null) {
            QuickFixAction.$$$reportNull$$$0(18);
        }
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(19);
        }
        if (refElements == null) {
            QuickFixAction.$$$reportNull$$$0(20);
        }
        QuickFixAction.refreshViews(project2, refElements, toolWrapper);
        ArrayList<RefElement> deletedRefs = new ArrayList<RefElement>(1);
        for (RefEntity refElement : refElements) {
            if (!(refElement instanceof RefElement)) continue;
            refElement.getRefManager().removeRefElement((RefElement)refElement, deletedRefs);
        }
    }

    private static Set<VirtualFile> getReadOnlyFiles(RefEntity @NotNull [] refElements) {
        if (refElements == null) {
            QuickFixAction.$$$reportNull$$$0(21);
        }
        THashSet<VirtualFile> readOnlyFiles = new THashSet<VirtualFile>();
        for (RefEntity refElement : refElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null;
            if (psiElement == null || psiElement.getContainingFile() == null) continue;
            readOnlyFiles.add(psiElement.getContainingFile().getVirtualFile());
        }
        return readOnlyFiles;
    }

    private static RefEntity @NotNull [] getSelectedElements(InspectionResultsView view) {
        if (view == null) {
            if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
                QuickFixAction.$$$reportNull$$$0(22);
            }
            return RefEntity.EMPTY_ELEMENTS_ARRAY;
        }
        RefEntity[] selection = view.getTree().getSelectedElements();
        PsiDocumentManager.getInstance(view.getProject()).commitAllDocuments();
        Arrays.sort(selection, InspectionResultsViewComparator::compareEntities);
        if (selection == null) {
            QuickFixAction.$$$reportNull$$$0(23);
        }
        return selection;
    }

    private static void refreshViews(@NotNull Project project2, @NotNull Set<? extends PsiElement> resolvedElements, @NotNull InspectionToolWrapper toolWrapper) {
        if (project2 == null) {
            QuickFixAction.$$$reportNull$$$0(24);
        }
        if (resolvedElements == null) {
            QuickFixAction.$$$reportNull$$$0(25);
        }
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(26);
        }
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance(project2);
        Set<GlobalInspectionContextImpl> runningContexts = managerEx.getRunningContexts();
        for (GlobalInspectionContextImpl context : runningContexts) {
            for (PsiElement psiElement : resolvedElements) {
                context.resolveElement((InspectionProfileEntry)toolWrapper.getTool(), psiElement);
            }
            context.refreshViews();
        }
    }

    protected static void refreshViews(@NotNull Project project2, RefEntity @NotNull [] resolvedElements, @NotNull InspectionToolWrapper toolWrapper) {
        if (project2 == null) {
            QuickFixAction.$$$reportNull$$$0(27);
        }
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(28);
        }
        if (resolvedElements == null) {
            QuickFixAction.$$$reportNull$$$0(29);
        }
        HashSet<PsiElement> ignoredElements = new HashSet<PsiElement>();
        for (RefEntity element2 : resolvedElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = element2 instanceof RefElement ? ((RefElement)element2).getPsiElement() : null;
            if (psiElement == null || !psiElement.isValid()) continue;
            ignoredElements.add(psiElement);
        }
        QuickFixAction.refreshViews(project2, ignoredElements, toolWrapper);
    }

    protected boolean applyFix(RefEntity @NotNull [] refElements) {
        Project project2;
        ReadonlyStatusHandler.OperationStatus operationStatus;
        Set<VirtualFile> readOnlyFiles;
        if (refElements == null) {
            QuickFixAction.$$$reportNull$$$0(30);
        }
        return (readOnlyFiles = QuickFixAction.getReadOnlyFiles(refElements)).isEmpty() || !(operationStatus = ReadonlyStatusHandler.getInstance(project2 = refElements[0].getRefManager().getProject()).ensureFilesWritable(readOnlyFiles)).hasReadonlyFiles();
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, final @NotNull String place) {
        if (presentation == null) {
            QuickFixAction.$$$reportNull$$$0(31);
        }
        if (place == null) {
            QuickFixAction.$$$reportNull$$$0(32);
        }
        final JButton button2 = new JButton(presentation.getText());
        Icon icon2 = presentation.getIcon();
        if (icon2 == null) {
            icon2 = AllIcons.Actions.IntentionBulb;
        }
        button2.setEnabled(presentation.isEnabled());
        button2.setIcon(IconLoader.getTransparentIcon(icon2, 0.75f));
        new ClickListener(){

            @Override
            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                ActionToolbar toolbar;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                QuickFixAction.this.actionPerformed(AnActionEvent.createFromAnAction(QuickFixAction.this, event, place, (toolbar = ComponentUtil.getParentOfType(ActionToolbar.class, button2)) == null ? DataManager.getInstance().getDataContext(button2) : toolbar.getToolbarDataContext()));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ex/QuickFixAction$1", "onClick"));
            }
        }.installOn(button2);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 2));
        panel2.setBorder(JBUI.Borders.empty(7, 0, 8, 0));
        panel2.add(button2);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            QuickFixAction.$$$reportNull$$$0(33);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 23: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 23: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 19: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 18: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredElements";
                break;
            }
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readOnlyFiles";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 17: 
            case 20: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElements";
                break;
            }
            case 22: 
            case 23: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/QuickFixAction";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElements";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/QuickFixAction";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInvoker";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doApplyFix";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "performFixesInBatch";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeElements";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getReadOnlyFiles";
                break;
            }
            case 22: 
            case 23: 
            case 33: {
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "refreshViews";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 23: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PerformFixesTask
    extends PerformFixesModalTask {
        @NotNull
        private final GlobalInspectionContextImpl myContext;
        @NotNull
        private final Set<? super PsiElement> myIgnoredElements;

        PerformFixesTask(@NotNull Project project2, @NotNull List<CommonProblemDescriptor[]> descriptors, @NotNull Set<? super PsiElement> ignoredElements, GlobalInspectionContextImpl context) {
            if (project2 == null) {
                PerformFixesTask.$$$reportNull$$$0(0);
            }
            if (descriptors == null) {
                PerformFixesTask.$$$reportNull$$$0(1);
            }
            if (ignoredElements == null) {
                PerformFixesTask.$$$reportNull$$$0(2);
            }
            if (context == null) {
                PerformFixesTask.$$$reportNull$$$0(3);
            }
            super(project2, descriptors);
            this.myContext = context;
            this.myIgnoredElements = ignoredElements;
        }

        @Override
        protected void applyFix(Project project2, CommonProblemDescriptor descriptor2) {
            if (descriptor2 instanceof ProblemDescriptor && ((ProblemDescriptor)descriptor2).getStartElement() == null && ((ProblemDescriptor)descriptor2).getEndElement() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalidated psi for " + descriptor2);
                }
                return;
            }
            try {
                QuickFixAction.this.applyFix(this.myProject, this.myContext, new CommonProblemDescriptor[]{descriptor2}, this.myIgnoredElements);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptors";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ignoredElements";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/ex/QuickFixAction$PerformFixesTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

