/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.naming;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.naming.NamingConvention;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.codeInspection.naming.NamingConventionWithFallbackBean;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.SyntheticElement;
import com.intellij.serialization.SerializationException;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNamingConventionInspection<T extends PsiNameIdentifierOwner>
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(AbstractNamingConventionInspection.class);
    private final Map<String, NamingConvention<T>> myNamingConventions = new LinkedHashMap<String, NamingConvention<T>>();
    private final Map<String, NamingConventionBean> myNamingConventionBeans = new LinkedHashMap<String, NamingConventionBean>();
    private final Map<String, Element> myUnloadedElements = new LinkedHashMap<String, Element>();
    private final Set<String> myDisabledShortNames = new HashSet<String>();
    @Nullable
    private final String myDefaultConventionShortName;

    protected AbstractNamingConventionInspection(Iterable<NamingConvention<T>> extensions2, @Nullable String defaultConventionShortName) {
        for (NamingConvention<T> convention : extensions2) {
            this.registerConvention(convention);
        }
        this.myDefaultConventionShortName = defaultConventionShortName;
    }

    protected void registerConvention(NamingConvention<T> convention) {
        String shortName = convention.getShortName();
        NamingConvention<T> oldConvention = this.myNamingConventions.put(shortName, convention);
        if (oldConvention != null) {
            LOG.error("Duplicated short names: " + shortName + " first: " + oldConvention + "; second: " + convention);
        }
        this.myNamingConventionBeans.put(shortName, convention.createDefaultBean());
        if (!convention.isEnabledByDefault()) {
            this.myDisabledShortNames.add(shortName);
        }
    }

    protected void unregisterConvention(@NotNull NamingConvention<T> extension) {
        String shortName;
        Element element2;
        if (extension == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(0);
        }
        if ((element2 = this.writeConvention(shortName = extension.getShortName(), extension)) != null) {
            this.myUnloadedElements.put(shortName, element2);
        }
        this.myNamingConventionBeans.remove(shortName);
        this.myNamingConventions.remove(shortName);
        this.myDisabledShortNames.remove(shortName);
    }

    protected void registerConventionsListener(ExtensionPointName<NamingConvention<T>> epName) {
        Application application = ApplicationManager.getApplication();
        epName.getPoint(application).addExtensionPointListener(new ExtensionPointListener<NamingConvention<T>>(){

            @Override
            public void extensionAdded(@NotNull NamingConvention<T> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                AbstractNamingConventionInspection.this.registerConvention(extension);
            }

            @Override
            public void extensionRemoved(@NotNull NamingConvention<T> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                AbstractNamingConventionInspection.this.unregisterConvention(extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/naming/AbstractNamingConventionInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, (Disposable)application);
    }

    @Nullable
    protected abstract LocalQuickFix createRenameFix();

    private void initDisabledState() {
        this.myDisabledShortNames.clear();
        for (NamingConvention<T> convention : this.myNamingConventions.values()) {
            if (convention.isEnabledByDefault()) continue;
            this.myDisabledShortNames.add(convention.getShortName());
        }
    }

    public NamingConventionBean getNamingConventionBean(String shortName) {
        return this.myNamingConventionBeans.get(shortName);
    }

    public Set<String> getOldToolNames() {
        return this.myNamingConventions.keySet();
    }

    @NotNull
    protected String createErrorMessage(String name, String shortName) {
        String string = this.myNamingConventions.get(shortName).createErrorMessage(name, this.myNamingConventionBeans.get(shortName));
        if (string == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void readSettings(@NotNull Element node) {
        if (node == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(2);
        }
        this.initDisabledState();
        for (Element extension : node.getChildren("extension")) {
            String shortName = extension.getAttributeValue("name");
            if (shortName == null) continue;
            NamingConventionBean conventionBean = this.myNamingConventionBeans.get(shortName);
            if (conventionBean == null) {
                this.myUnloadedElements.put(shortName, extension);
                continue;
            }
            try {
                XmlSerializer.deserializeInto(conventionBean, extension);
                conventionBean.initPattern();
            }
            catch (SerializationException e) {
                throw new InvalidDataException(e);
            }
            String enabled = extension.getAttributeValue("enabled");
            if (!Boolean.parseBoolean(enabled)) continue;
            this.myDisabledShortNames.remove(shortName);
        }
    }

    @Override
    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(3);
        }
        TreeSet<String> shortNames = new TreeSet<String>(this.myNamingConventions.keySet());
        shortNames.addAll(this.myUnloadedElements.keySet());
        for (String shortName : shortNames) {
            Element element2;
            NamingConvention<T> convention = this.myNamingConventions.get(shortName);
            if (convention == null) {
                element2 = this.myUnloadedElements.get(shortName);
                if (element2 == null) continue;
                node.addContent(element2.clone());
                continue;
            }
            element2 = this.writeConvention(shortName, convention);
            if (element2 == null) continue;
            node.addContent(element2);
        }
    }

    private Element writeConvention(String shortName, NamingConvention<T> convention) {
        boolean disabled = this.myDisabledShortNames.contains(shortName);
        Element element2 = new Element("extension").setAttribute("name", shortName).setAttribute("enabled", disabled ? "false" : "true");
        NamingConventionBean conventionBean = this.myNamingConventionBeans.get(shortName);
        if (!convention.createDefaultBean().equals(conventionBean)) {
            XmlSerializer.serializeInto(conventionBean, element2);
        } else if (disabled) {
            return null;
        }
        return element2;
    }

    public boolean isConventionEnabled(String shortName) {
        return !this.myDisabledShortNames.contains(shortName);
    }

    protected void checkName(@NotNull T member, @NotNull String name, @NotNull ProblemsHolder holder) {
        if (member == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(4);
        }
        if (name == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(6);
        }
        if (member instanceof SyntheticElement) {
            return;
        }
        this.checkName(member, shortName -> {
            LocalQuickFix[] fixes;
            if (holder.isOnTheFly()) {
                LocalQuickFix[] localQuickFixArray;
                LocalQuickFix fix2 = this.createRenameFix();
                if (fix2 != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = fix2;
                } else {
                    localQuickFixArray = null;
                }
                fixes = localQuickFixArray;
            } else {
                fixes = null;
            }
            PsiElement element2 = ObjectUtils.notNull(member.getNameIdentifier(), member);
            if (!element2.isPhysical()) {
                element2 = element2.getNavigationElement();
            }
            holder.registerProblem(element2, this.createErrorMessage(name, (String)shortName), fixes);
        });
    }

    protected void checkName(@NotNull T member, @NotNull Consumer<? super String> errorRegister) {
        if (member == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(7);
        }
        if (errorRegister == null) {
            AbstractNamingConventionInspection.$$$reportNull$$$0(8);
        }
        for (NamingConvention<T> namingConvention : this.myNamingConventions.values()) {
            if (!namingConvention.isApplicable(member)) continue;
            String shortName = namingConvention.getShortName();
            if (this.myDisabledShortNames.contains(shortName)) break;
            NamingConventionBean activeBean = this.myNamingConventionBeans.get(shortName);
            if (activeBean instanceof NamingConventionWithFallbackBean && ((NamingConventionWithFallbackBean)activeBean).isInheritDefaultSettings()) {
                LOG.assertTrue(this.myDefaultConventionShortName != null, activeBean + " expects that default conversion is configured");
                shortName = this.myDefaultConventionShortName;
                if (this.myDisabledShortNames.contains(shortName)) break;
                activeBean = this.myNamingConventionBeans.get(shortName);
                namingConvention = this.myNamingConventions.get(shortName);
            }
            if (namingConvention.isValid(member, activeBean)) break;
            errorRegister.accept(shortName);
            break;
        }
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(JBUIScale.scale(2), JBUIScale.scale(2)));
        CardLayout layout = new CardLayout();
        final JPanel descriptionPanel = new JPanel(layout);
        descriptionPanel.setBorder(JBUI.Borders.empty(2));
        panel2.add((Component)descriptionPanel, "Center");
        CheckBoxList<NamingConvention> list2 = new CheckBoxList<NamingConvention>();
        list2.setBorder(JBUI.Borders.empty(2));
        final ArrayList<NamingConvention<T>> values2 = new ArrayList<NamingConvention<T>>(this.myNamingConventions.values());
        Collections.reverse(values2);
        for (NamingConvention namingConvention : values2) {
            String shortName = namingConvention.getShortName();
            list2.addItem(namingConvention, namingConvention.getElementDescription(), !this.myDisabledShortNames.contains(shortName));
            descriptionPanel.add((Component)this.myNamingConventionBeans.get(shortName).createOptionsPanel(), shortName);
        }
        list2.addListSelectionListener(e -> {
            int selectedIndex = list2.getSelectedIndex();
            NamingConvention item = (NamingConvention)list2.getItemAt(selectedIndex);
            if (item != null) {
                String shortName = item.getShortName();
                layout.show(descriptionPanel, shortName);
                UIUtil.setEnabled(descriptionPanel, list2.isItemSelected(selectedIndex), true);
            }
        });
        list2.setCheckBoxListListener(new CheckBoxListListener(){

            @Override
            public void checkBoxSelectionChanged(int index, boolean value2) {
                NamingConvention convention = (NamingConvention)values2.get(index);
                AbstractNamingConventionInspection.this.setEnabled(value2, convention.getShortName());
                UIUtil.setEnabled(descriptionPanel, value2, true);
            }
        });
        list2.setSelectedIndex(0);
        panel2.add((Component)new JBScrollPane(list2), "West");
        return panel2;
    }

    public void setEnabled(boolean value2, String conventionShortName) {
        if (value2) {
            this.myDisabledShortNames.remove(conventionShortName);
        } else {
            this.myDisabledShortNames.add(conventionShortName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/naming/AbstractNamingConventionInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorRegister";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/naming/AbstractNamingConventionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unregisterConvention";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

