/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.naming;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.naming.NamingConventionBean;
import com.intellij.psi.PsiNameIdentifierOwner;

public abstract class NamingConvention<T extends PsiNameIdentifierOwner> {
    public abstract boolean isApplicable(T var1);

    public abstract String getElementDescription();

    public abstract String getShortName();

    public abstract NamingConventionBean createDefaultBean();

    public boolean isEnabledByDefault() {
        return false;
    }

    public String createErrorMessage(String name, NamingConventionBean bean) {
        int length = name.length();
        if (length < bean.m_minLength) {
            return InspectionsBundle.message("naming.convention.problem.descriptor.short", this.getElementDescription(), length, bean.m_minLength);
        }
        if (bean.m_maxLength > 0 && length > bean.m_maxLength) {
            return InspectionsBundle.message("naming.convention.problem.descriptor.long", this.getElementDescription(), length, bean.m_maxLength);
        }
        return InspectionsBundle.message("naming.convention.problem.descriptor.regex.mismatch", this.getElementDescription(), bean.m_regex);
    }

    public boolean isValid(T member, NamingConventionBean bean) {
        String name = member.getName();
        return name != null && bean.isValid(name);
    }
}

