/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offline;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OfflineProblemDescriptor {
    public String myType;
    public String myFQName;
    public String myDescription;
    public List<String> myHints;
    public int myProblemIndex;
    public int myLine;
    public String myModuleName;

    public String getType() {
        return this.myType;
    }

    public void setType(String type) {
        this.myType = type;
    }

    public String getFQName() {
        return this.myFQName;
    }

    public void setFQName(String FQName) {
        this.myFQName = FQName;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public List<String> getHints() {
        return this.myHints;
    }

    public void setHints(List<String> hints) {
        this.myHints = hints;
    }

    public int getProblemIndex() {
        return this.myProblemIndex;
    }

    public void setProblemIndex(int problemIndex) {
        this.myProblemIndex = problemIndex;
    }

    public int getLine() {
        return this.myLine;
    }

    public void setLine(int line) {
        this.myLine = line;
    }

    @Nullable
    public RefEntity getRefElement(RefManager refManager) {
        return ReadAction.compute(() -> refManager.getProject().isDisposed() ? null : refManager.getReference(this.myType, this.myFQName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfflineProblemDescriptor that = (OfflineProblemDescriptor)o;
        if (this.myLine != that.myLine) {
            return false;
        }
        if (this.myProblemIndex != that.myProblemIndex) {
            return false;
        }
        if (!Objects.equals(this.myDescription, that.myDescription)) {
            return false;
        }
        if (!Objects.equals(this.myFQName, that.myFQName)) {
            return false;
        }
        if (!Objects.equals(this.myHints, that.myHints)) {
            return false;
        }
        if (!Objects.equals(this.myModuleName, that.myModuleName)) {
            return false;
        }
        return Objects.equals(this.myType, that.myType);
    }

    public int hashCode() {
        int result2 = this.myType != null ? this.myType.hashCode() : 0;
        result2 = 31 * result2 + (this.myFQName != null ? this.myFQName.hashCode() : 0);
        result2 = 31 * result2 + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        result2 = 31 * result2 + (this.myHints != null ? this.myHints.hashCode() : 0);
        result2 = 31 * result2 + this.myProblemIndex;
        result2 = 31 * result2 + this.myLine;
        result2 = 31 * result2 + (this.myModuleName != null ? this.myModuleName.hashCode() : 0);
        return result2;
    }

    public void setModule(String moduleName) {
        this.myModuleName = moduleName;
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    public String toString() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myFQName;
        }
        return this.myDescription;
    }
}

