/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntityImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefElementImpl
extends RefEntityImpl
implements RefElement,
WritableRefElement {
    protected static final Logger LOG = Logger.getInstance(RefElement.class);
    private static final int IS_ENTRY_MASK = 128;
    private static final int IS_PERMANENT_ENTRY_MASK = 256;
    private final SmartPsiElementPointer myID;
    private List<RefElement> myOutReferences;
    private List<RefElement> myInReferences;
    private String[] mySuppressions;
    private volatile boolean myIsDeleted;
    protected static final int IS_REACHABLE_MASK = 64;

    protected RefElementImpl(@NotNull String name, @NotNull RefElement owner) {
        if (name == null) {
            RefElementImpl.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            RefElementImpl.$$$reportNull$$$0(1);
        }
        super(name, owner.getRefManager());
        this.myID = null;
        this.myFlags = 0L;
    }

    protected RefElementImpl(PsiFile file2, RefManager manager) {
        this(file2.getName(), file2, manager);
    }

    protected RefElementImpl(@NotNull String name, @NotNull PsiElement element2, @NotNull RefManager manager) {
        if (name == null) {
            RefElementImpl.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            RefElementImpl.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            RefElementImpl.$$$reportNull$$$0(4);
        }
        super(name, manager);
        this.myID = SmartPointerManager.getInstance(manager.getProject()).createSmartPsiElementPointer(element2);
        this.myFlags = 0L;
    }

    protected boolean isDeleted() {
        return this.myIsDeleted;
    }

    @Override
    public boolean isValid() {
        if (this.myIsDeleted) {
            return false;
        }
        return ReadAction.compute(() -> {
            if (this.getRefManager().getProject().isDisposed()) {
                return false;
            }
            PsiFile file2 = this.myID.getContainingFile();
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return file2 != null && file2.isPhysical();
            }
            PsiElement element2 = this.getPsiElement();
            return element2 != null && element2.isPhysical();
        });
    }

    @Override
    @Nullable
    public Icon getIcon(boolean expanded) {
        PsiElement element2 = this.getPsiElement();
        if (element2 != null && element2.isValid()) {
            return element2.getIcon(3);
        }
        return null;
    }

    @Override
    public RefModule getModule() {
        WritableRefEntity owner = this.getOwner();
        return owner instanceof RefElement ? ((RefElement)((Object)owner)).getModule() : null;
    }

    @Override
    public String getExternalName() {
        return this.getName();
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myID.getElement();
    }

    @Nullable
    public PsiFile getContainingFile() {
        return this.myID.getContainingFile();
    }

    public VirtualFile getVirtualFile() {
        return this.myID.getVirtualFile();
    }

    @Override
    public SmartPsiElementPointer getPointer() {
        return this.myID;
    }

    public void buildReferences() {
    }

    @Override
    public boolean isReachable() {
        return this.checkFlag(64L);
    }

    public void setReachable(boolean reachable) {
        this.setFlag(reachable, 64L);
    }

    @Override
    public boolean isReferenced() {
        return !this.getInReferences().isEmpty();
    }

    public boolean hasSuspiciousCallers() {
        for (RefElement refCaller : this.getInReferences()) {
            if (!((RefElementImpl)refCaller).isSuspicious()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public synchronized Collection<RefElement> getOutReferences() {
        Collection collection = ObjectUtils.notNull(this.myOutReferences, ContainerUtil.emptyList());
        if (collection == null) {
            RefElementImpl.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Override
    @NotNull
    public synchronized Collection<RefElement> getInReferences() {
        Collection collection = ObjectUtils.notNull(this.myInReferences, ContainerUtil.emptyList());
        if (collection == null) {
            RefElementImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    public synchronized void addInReference(RefElement refElement) {
        List<RefElement> inReferences = this.myInReferences;
        if (inReferences == null) {
            this.myInReferences = inReferences = new ArrayList<RefElement>(1);
        }
        if (!inReferences.contains(refElement)) {
            inReferences.add(refElement);
        }
    }

    @Override
    public synchronized void addOutReference(RefElement refElement) {
        List<RefElement> outReferences = this.myOutReferences;
        if (outReferences == null) {
            this.myOutReferences = outReferences = new ArrayList<RefElement>(1);
        }
        if (!outReferences.contains(refElement)) {
            outReferences.add(refElement);
        }
    }

    public void setEntry(boolean entry) {
        this.setFlag(entry, 128L);
    }

    @Override
    public boolean isEntry() {
        return this.checkFlag(128L);
    }

    @Override
    public boolean isPermanentEntry() {
        return this.checkFlag(256L);
    }

    @Override
    @NotNull
    public RefElement getContainingEntry() {
        RefElementImpl refElementImpl = this;
        if (refElementImpl == null) {
            RefElementImpl.$$$reportNull$$$0(7);
        }
        return refElementImpl;
    }

    public void setPermanentEntry(boolean permanentEntry) {
        this.setFlag(permanentEntry, 256L);
    }

    public boolean isSuspicious() {
        return !this.isReachable();
    }

    public void referenceRemoved() {
        this.myIsDeleted = true;
        if (this.getOwner() != null) {
            this.getOwner().removeChild(this);
        }
        for (RefElement refCallee : this.getOutReferences()) {
            refCallee.getInReferences().remove(this);
        }
        for (RefElement refCaller : this.getInReferences()) {
            refCaller.getOutReferences().remove(this);
        }
    }

    @Nullable
    public String getURL() {
        PsiElement element2 = this.getPsiElement();
        if (element2 == null || !element2.isPhysical()) {
            return null;
        }
        PsiFile containingFile = element2.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = containingFile.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        return virtualFile2.getUrl() + "#" + element2.getTextOffset();
    }

    protected abstract void initialize();

    @Override
    public void addSuppression(String text2) {
        this.mySuppressions = text2.split("[, ]");
    }

    public boolean isSuppressed(String ... toolId) {
        WritableRefEntity entity;
        if (toolId == null) {
            RefElementImpl.$$$reportNull$$$0(8);
        }
        if (this.mySuppressions != null) {
            for (String suppression : this.mySuppressions) {
                for (String id2 : toolId) {
                    if (!suppression.equals(id2)) continue;
                    return true;
                }
                if (!suppression.equalsIgnoreCase("ALL")) continue;
                return true;
            }
        }
        return (entity = this.getOwner()) instanceof RefElementImpl && ((RefElementImpl)entity).isSuppressed(toolId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefElementImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefElementImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutReferences";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInReferences";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

