/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RefEntityImpl
extends UserDataHolderBase
implements RefEntity,
WritableRefEntity {
    private volatile WritableRefEntity myOwner;
    protected List<RefEntity> myChildren;
    private final String myName;
    protected long myFlags;
    protected final RefManagerImpl myManager;

    protected RefEntityImpl(@NotNull String name, @NotNull RefManager manager) {
        if (name == null) {
            RefEntityImpl.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            RefEntityImpl.$$$reportNull$$$0(1);
        }
        this.myManager = (RefManagerImpl)manager;
        this.myName = this.myManager.internName(name);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            RefEntityImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = this.myName;
        if (string == null) {
            RefEntityImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public synchronized List<RefEntity> getChildren() {
        List<RefEntity> list2 = ObjectUtils.notNull(this.myChildren, ContainerUtil.emptyList());
        if (list2 == null) {
            RefEntityImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    public WritableRefEntity getOwner() {
        return this.myOwner;
    }

    @Override
    public void setOwner(@Nullable WritableRefEntity owner) {
        this.myOwner = owner;
    }

    @Override
    public synchronized void add(@NotNull RefEntity child2) {
        List<RefEntity> children2;
        if (child2 == null) {
            RefEntityImpl.$$$reportNull$$$0(5);
        }
        if ((children2 = this.myChildren) == null) {
            this.myChildren = children2 = new ArrayList<RefEntity>(1);
        }
        children2.add(child2);
        ((RefEntityImpl)child2).setOwner(this);
    }

    @Override
    public synchronized void removeChild(@NotNull RefEntity child2) {
        if (child2 == null) {
            RefEntityImpl.$$$reportNull$$$0(6);
        }
        if (this.myChildren != null) {
            this.myChildren.remove(child2);
            ((WritableRefEntity)child2).setOwner(null);
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void accept(@NotNull RefVisitor refVisitor) {
        if (refVisitor == null) {
            RefEntityImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().runReadAction(() -> refVisitor.visitElement(this));
    }

    public synchronized boolean checkFlag(long mask) {
        return BitUtil.isSet(this.myFlags, mask);
    }

    public synchronized void setFlag(boolean value2, long mask) {
        this.myFlags = BitUtil.set(this.myFlags, mask, value2);
    }

    @Override
    public String getExternalName() {
        return this.myName;
    }

    @Override
    @NotNull
    public RefManagerImpl getRefManager() {
        RefManagerImpl refManagerImpl = this.myManager;
        if (refManagerImpl == null) {
            RefEntityImpl.$$$reportNull$$$0(8);
        }
        return refManagerImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefEntityImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefEntityImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

