/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefFileImpl
extends RefElementImpl
implements RefFile {
    public RefFileImpl(PsiFile elem, RefManager manager) {
        super(elem, manager);
    }

    @Override
    public PsiFile getPsiElement() {
        return (PsiFile)super.getPsiElement();
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            RefFileImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().runReadAction(() -> visitor.visitFile(this));
    }

    @Override
    public String getExternalName() {
        PsiFile psiFile = this.getPsiElement();
        VirtualFile virtualFile2 = psiFile != null ? psiFile.getVirtualFile() : null;
        return virtualFile2 != null ? virtualFile2.getUrl() : this.getName();
    }

    @Override
    protected void initialize() {
        RefElement element2;
        VirtualFile vFile = this.getVirtualFile();
        if (vFile == null) {
            return;
        }
        VirtualFile parentDirectory = vFile.getParent();
        if (parentDirectory == null) {
            return;
        }
        PsiDirectory psiDirectory = this.getRefManager().getPsiManager().findDirectory(parentDirectory);
        if (psiDirectory != null && (element2 = this.getRefManager().getReference(psiDirectory)) != null) {
            ((RefElementImpl)element2).add(this);
        }
    }

    @Nullable
    static RefElement fileFromExternalName(RefManager manager, String fqName) {
        PsiFile psiFile;
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(PathMacroManager.getInstance(manager.getProject()).expandPath(fqName));
        if (virtualFile2 != null && (psiFile = PsiManager.getInstance(manager.getProject()).findFile(virtualFile2)) != null) {
            return manager.getReference(psiFile);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefFileImpl", "accept"));
    }
}

