/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefUtil {
    private RefUtil() {
    }

    public static boolean isImplicitUsage(@Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (!provider.isImplicitUsage(element2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isImplicitRead(@Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (!provider.isImplicitRead(element2)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(RefEntity element2, @NotNull Collection<? extends RefEntity> entities2) {
        if (entities2 == null) {
            RefUtil.$$$reportNull$$$0(0);
        }
        for (RefEntity refEntity : entities2) {
            if (!Comparing.equal(refEntity, element2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isImplicitWrite(@Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        for (ImplicitUsageProvider provider : ImplicitUsageProvider.EP_NAME.getExtensionList()) {
            if (!provider.isImplicitWrite(element2)) continue;
            return true;
        }
        return EntryPointsManager.getInstance(element2.getProject()).isImplicitWrite(element2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entities", "com/intellij/codeInspection/reference/RefUtil", "contains"));
    }
}

