/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionTreeTailRenderer;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

class InspectionTreeCellRenderer
extends ColoredTreeCellRenderer {
    private final InspectionTreeTailRenderer<RuntimeException> myTailRenderer;

    InspectionTreeCellRenderer(InspectionResultsView view) {
        this.myTailRenderer = new InspectionTreeTailRenderer<RuntimeException>(view.getGlobalInspectionContext()){

            @Override
            protected void appendText(String text2, SimpleTextAttributes attributes) {
                InspectionTreeCellRenderer.this.append(text2, attributes);
            }

            @Override
            protected void appendText(String text2) {
                InspectionTreeCellRenderer.this.append(text2);
            }
        };
    }

    @Override
    public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            InspectionTreeCellRenderer.$$$reportNull$$$0(0);
        }
        if (value2 instanceof InspectionRootNode) {
            return;
        }
        if (value2 instanceof LoadingNode) {
            this.append(LoadingNode.getText());
            return;
        }
        InspectionTreeNode node = (InspectionTreeNode)value2;
        this.append(node.getPresentableText(), InspectionTreeCellRenderer.patchMainTextAttrs(node, node.appearsBold() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : InspectionTreeCellRenderer.getMainForegroundAttributes(node)));
        this.myTailRenderer.appendTailText(node);
        this.setIcon(node.getIcon(expanded));
    }

    private static SimpleTextAttributes patchMainTextAttrs(InspectionTreeNode node, SimpleTextAttributes attributes) {
        if (node.isExcluded()) {
            return attributes.derive(attributes.getStyle() | 4, null, null, null);
        }
        if (node instanceof SuppressableInspectionTreeNode && ((SuppressableInspectionTreeNode)node).isQuickFixAppliedFromView()) {
            return attributes.derive(-1, SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor(), null, null);
        }
        if (!node.isValid()) {
            return attributes.derive(-1, FileStatus.IGNORED.getColor(), null, null);
        }
        return attributes;
    }

    private static SimpleTextAttributes getMainForegroundAttributes(InspectionTreeNode node) {
        RefEntity refElement;
        SimpleTextAttributes foreground = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (node instanceof RefElementNode && (refElement = ((RefElementNode)node).getElement()) instanceof RefElement && ((RefElement)(refElement = ((RefElement)refElement).getContainingEntry())).isEntry() && ((RefElement)refElement).isPermanentEntry()) {
            foreground = new SimpleTextAttributes(0, (Color)JBColor.blue);
        }
        return foreground;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/codeInspection/ui/InspectionTreeCellRenderer", "customizeCellRenderer"));
    }
}

