/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.OptionAccessor;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;

public class MultipleCheckboxOptionsPanel
extends JPanel {
    private final OptionAccessor myOptionAccessor;

    public MultipleCheckboxOptionsPanel(InspectionProfileEntry owner) {
        this(new OptionAccessor.Default(owner));
    }

    public MultipleCheckboxOptionsPanel(OptionAccessor optionAccessor) {
        super(new GridBagLayout());
        this.myOptionAccessor = optionAccessor;
    }

    public void addCheckbox(@Nls String label2, @NonNls String property) {
        this.addCheckboxEx(label2, property);
    }

    public JCheckBox addCheckboxEx(@Nls String label2, @NonNls String property) {
        boolean selected2 = this.myOptionAccessor.getOption(property);
        JCheckBox checkBox2 = new JCheckBox(label2, selected2);
        checkBox2.addItemListener(e -> this.myOptionAccessor.setOption(property, e.getStateChange() == 1));
        this.addComponent(checkBox2);
        return checkBox2;
    }

    public JCheckBox addDependentCheckBox(@Nls String label2, @NonNls String property, JCheckBox controller) {
        JCheckBox checkBox2 = this.addCheckboxEx(label2, property);
        checkBox2.setBorder(new EmptyBorder(new JBInsets(0, 30, 0, 0)));
        controller.addItemListener(e -> checkBox2.setEnabled(((JCheckBox)e.getSource()).isEnabled() && e.getStateChange() == 1));
        checkBox2.setEnabled(controller.isEnabled() && controller.isSelected());
        return checkBox2;
    }

    public void addComponent(JComponent component2) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        Component[] components = this.getComponents();
        this.removeAll();
        for (Component component1 : components) {
            this.add(component1, constraints);
            ++constraints.gridy;
        }
        constraints.weighty = 1.0;
        this.add((Component)component2, constraints);
    }
}

