/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.PreviewEditorFoldingRegion;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ProblemPreviewEditorPresentation {
    private static final int VIEW_ADDITIONAL_OFFSET = 4;
    private static final int SHOWN_LINES_COUNT = 2;

    static void setupFoldingsAndHighlightProblems(@NotNull EditorEx editor, @NotNull InspectionResultsView view) {
        if (editor == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(0);
        }
        if (view == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(1);
        }
        List usages = Arrays.stream(view.getTree().getAllValidSelectedDescriptors()).filter(ProblemDescriptorBase.class::isInstance).map(ProblemDescriptorBase.class::cast).map(d -> {
            PsiElement psi = d.getPsiElement();
            if (psi == null) {
                return null;
            }
            TextRange range2 = d.getTextRangeInElement();
            return range2 == null ? new UsageInfo(psi) : new UsageInfo(psi, range2.getStartOffset(), range2.getEndOffset());
        }).collect(Collectors.toList());
        ProblemPreviewEditorPresentation.setupFoldingsAndHighlightProblems(editor, view, usages, view.getProject());
    }

    public static void setupFoldingsAndHighlightProblems(@NotNull EditorEx editor, @NotNull Container editorContainer, @NotNull List<? extends UsageInfo> usages, @NotNull Project project2) {
        if (editor == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(2);
        }
        if (editorContainer == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(5);
        }
        DocumentEx doc = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(project2);
        if (documentManager.isUncommited(doc)) {
            WriteAction.run(() -> documentManager.commitDocument(doc));
        }
        if (usages.size() > 1) {
            TreeSet<PreviewEditorFoldingRegion> foldingRegions = new TreeSet<PreviewEditorFoldingRegion>();
            foldingRegions.add(new PreviewEditorFoldingRegion(0, doc.getLineCount()));
            boolean isUpdated = false;
            for (UsageInfo usageInfo : usages) {
                if (usageInfo == null) {
                    return;
                }
                PsiElement element2 = usageInfo.getElement();
                Segment segment = usageInfo.getSegment();
                assert (element2 != null);
                isUpdated |= ProblemPreviewEditorPresentation.makeVisible(foldingRegions, injectedLanguageManager.injectedToHost(element2, segment != null ? TextRange.create(segment) : element2.getTextRange()), doc);
            }
            if (isUpdated) {
                ProblemPreviewEditorPresentation.setupFoldings(editor, foldingRegions);
            }
        }
        ProblemPreviewEditorPresentation.highlightProblems(editor, editorContainer, usages, project2);
    }

    private static void highlightProblems(EditorEx editor, Container editorContainer, List<? extends UsageInfo> usages, @NotNull Project project2) {
        if (project2 == null) {
            ProblemPreviewEditorPresentation.$$$reportNull$$$0(6);
        }
        List<UsageInfo> validUsages = ContainerUtil.filter(usages, Objects::nonNull);
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(project2);
        PsiDocumentManager.getInstance(project2).performLaterWhenAllCommitted(() -> {
            if (!editor.isDisposed()) {
                editorContainer.invalidate();
                editorContainer.validate();
                UsagePreviewPanel.highlight(validUsages, editor, project2, false, 6000);
                if (validUsages.size() == 1) {
                    UsageInfo usage = (UsageInfo)validUsages.get(0);
                    PsiElement element2 = usage.getElement();
                    Segment range2 = usage.getNavigationRange();
                    if (element2 != null && range2 != null) {
                        if (injectedLanguageManager.getInjectionHost(element2) != null) {
                            range2 = injectedLanguageManager.injectedToHost(element2, new TextRange(range2.getStartOffset(), range2.getEndOffset()));
                        }
                        DocumentEx document = editor.getDocument();
                        int offset = Math.min(range2.getEndOffset() + 4, document.getLineEndOffset(document.getLineNumber(range2.getEndOffset())));
                        editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(offset), ScrollType.CENTER);
                        return;
                    }
                }
                editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(0), ScrollType.CENTER_UP);
            }
        });
    }

    public static void setupFoldings(EditorEx editor, SortedSet<? extends PreviewEditorFoldingRegion> foldingRegions) {
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            editor.getFoldingModel().clearFoldRegions();
            editor.getMarkupModel().removeAllHighlighters();
            for (PreviewEditorFoldingRegion region : foldingRegions) {
                FoldRegion currentRegion;
                if (region.getEndLine() - region.getStartLine() <= 1 || (currentRegion = FoldingModelSupport.addFolding(editor, region.getStartLine(), region.getEndLine(), false)) == null) continue;
                DiffDrawUtil.createLineSeparatorHighlighter(editor, editor.getDocument().getLineStartOffset(region.getStartLine()), editor.getDocument().getLineEndOffset(region.getEndLine() - 1), () -> currentRegion.isValid() && !currentRegion.isExpanded());
            }
        });
    }

    private static boolean makeVisible(SortedSet<PreviewEditorFoldingRegion> foldingRegions, Segment toShowRange, Document document) {
        if (toShowRange == null) {
            return false;
        }
        boolean isUpdated = false;
        int startLine = Math.max(0, document.getLineNumber(toShowRange.getStartOffset()) - 2);
        int endLine = Math.min(document.getLineCount(), document.getLineNumber(toShowRange.getEndOffset()) + 2 + 1);
        for (PreviewEditorFoldingRegion range2 : new ArrayList<PreviewEditorFoldingRegion>(foldingRegions)) {
            boolean startInRegion = range2.contain(startLine);
            boolean endInRegion = range2.contain(endLine);
            if (startInRegion && endInRegion) {
                foldingRegions.remove(range2);
                if (range2.getStartLine() != startLine) {
                    foldingRegions.add(new PreviewEditorFoldingRegion(range2.getStartLine(), startLine));
                }
                if (endLine != range2.getEndLine()) {
                    foldingRegions.add(new PreviewEditorFoldingRegion(endLine, range2.getEndLine()));
                }
                return true;
            }
            if (startInRegion) {
                foldingRegions.remove(range2);
                if (range2.getStartLine() != startLine) {
                    foldingRegions.add(new PreviewEditorFoldingRegion(range2.getStartLine(), startLine));
                }
                isUpdated = true;
            }
            if (!endInRegion) continue;
            foldingRegions.remove(range2);
            if (endLine != range2.getEndLine()) {
                foldingRegions.add(new PreviewEditorFoldingRegion(endLine, range2.getEndLine()));
            }
            return true;
        }
        return isUpdated;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorContainer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ui/ProblemPreviewEditorPresentation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupFoldingsAndHighlightProblems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightProblems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

