/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.ui.DocumentAdapter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.NumberFormatter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SingleIntegerFieldOptionsPanel
extends JPanel {
    public SingleIntegerFieldOptionsPanel(String labelString, InspectionProfileEntry owner, @NonNls String property) {
        this(labelString, owner, property, 4);
    }

    public SingleIntegerFieldOptionsPanel(String labelString, InspectionProfileEntry owner, @NonNls String property, int integerFieldColumns) {
        super(new GridBagLayout());
        JLabel label2 = new JLabel(labelString);
        JFormattedTextField valueField = SingleIntegerFieldOptionsPanel.createIntegerFieldTrackingValue(owner, property, integerFieldColumns);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.right = 10;
        constraints.weightx = 0.0;
        constraints.anchor = 512;
        constraints.fill = 0;
        this.add((Component)label2, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets.right = 0;
        constraints.anchor = 512;
        constraints.fill = 0;
        this.add((Component)valueField, constraints);
    }

    public static JFormattedTextField createIntegerFieldTrackingValue(@NotNull InspectionProfileEntry owner, @NotNull String property, int integerFieldColumns) {
        if (owner == null) {
            SingleIntegerFieldOptionsPanel.$$$reportNull$$$0(0);
        }
        if (property == null) {
            SingleIntegerFieldOptionsPanel.$$$reportNull$$$0(1);
        }
        JFormattedTextField valueField = new JFormattedTextField();
        valueField.setColumns(integerFieldColumns);
        SingleIntegerFieldOptionsPanel.setupIntegerFieldTrackingValue(valueField, owner, property);
        return valueField;
    }

    public static void setupIntegerFieldTrackingValue(final JFormattedTextField textField2, final InspectionProfileEntry owner, final String property) {
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        formatter.setParseIntegerOnly(true);
        textField2.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(formatter)));
        textField2.setValue(SingleIntegerFieldOptionsPanel.getPropertyValue(owner, property));
        Document document = textField2.getDocument();
        document.addDocumentListener(new DocumentAdapter(){

            @Override
            public void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    textField2.commitEdit();
                    SingleIntegerFieldOptionsPanel.setPropertyValue(owner, property, ((Number)textField2.getValue()).intValue());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/ui/SingleIntegerFieldOptionsPanel$1", "textChanged"));
            }
        });
    }

    private static void setPropertyValue(InspectionProfileEntry owner, String property, int value2) {
        try {
            owner.getClass().getField(property).setInt(owner, value2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int getPropertyValue(InspectionProfileEntry owner, String property) {
        try {
            return owner.getClass().getField(property).getInt(owner);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "owner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "property";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/ui/SingleIntegerFieldOptionsPanel";
        objectArray[2] = "createIntegerFieldTrackingValue";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

