/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import org.jetbrains.annotations.NotNull;

public class InvokeQuickFixAction
extends AnAction {
    private final InspectionResultsView myView;

    public InvokeQuickFixAction(InspectionResultsView view) {
        super(InspectionsBundle.message("inspection.action.apply.quickfix", new Object[0]), InspectionsBundle.message("inspection.action.apply.quickfix.description", new Object[0]), AllIcons.Actions.IntentionBulb);
        this.myView = view;
        this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ShowIntentionActions").getShortcutSet(), this.myView.getTree());
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InvokeQuickFixAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        InspectionToolWrapper toolWrapper = this.myView.getTree().getSelectedToolWrapper(true);
        InspectionRVContentProvider provider = this.myView.getProvider();
        if (toolWrapper == null || InvokeQuickFixAction.cantApplyFixes(this.myView)) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(provider.hasQuickFixes(this.myView.getTree()));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        ActionGroup fixes;
        if (e == null) {
            InvokeQuickFixAction.$$$reportNull$$$0(1);
        }
        if ((fixes = (ActionGroup)ActionManager.getInstance().getAction("QuickFixes")).getChildren(e).length == 0) {
            Messages.showInfoMessage(this.myView, InspectionsBundle.message("there.are.no.applicable.quick.fixes.message", new Object[0]), InspectionsBundle.message("nothing.found.to.fix.title", new Object[0]));
            return;
        }
        DataContext dataContext = e.getDataContext();
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(InspectionsBundle.message("inspection.tree.popup.title", new Object[0]), fixes, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        InspectionResultsView.showPopup(e, popup2);
    }

    static boolean cantApplyFixes(InspectionResultsView view) {
        return !view.getTree().areDescriptorNodesSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/codeInspection/ui/actions/InvokeQuickFixAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

