/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion;

import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class ProjectConversionTestUtil {
    private ProjectConversionTestUtil() {
    }

    public static void assertNoConversionNeeded(@NotNull Path projectPath) {
        if (projectPath == null) {
            ProjectConversionTestUtil.$$$reportNull$$$0(0);
        }
        MyConversionListener listener2 = new MyConversionListener();
        ConversionResult result2 = ConversionService.getInstance().convertSilently(projectPath, listener2);
        Assert.assertTrue((boolean)result2.conversionNotNeeded());
        Assert.assertFalse((boolean)listener2.isConversionNeeded());
        Assert.assertFalse((boolean)listener2.isConverted());
    }

    public static void convert(@NotNull Path projectPath) {
        if (projectPath == null) {
            ProjectConversionTestUtil.$$$reportNull$$$0(1);
        }
        MyConversionListener listener2 = new MyConversionListener();
        ConversionResult result2 = ConversionService.getInstance().convertSilently(projectPath, listener2);
        Assert.assertFalse((boolean)result2.conversionNotNeeded());
        Assert.assertFalse((boolean)result2.openingIsCanceled());
        Assert.assertTrue((boolean)listener2.isConversionNeeded());
        Assert.assertTrue((boolean)listener2.isConverted());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "projectPath";
        objectArray2[1] = "com/intellij/conversion/ProjectConversionTestUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "assertNoConversionNeeded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "convert";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyConversionListener
    implements ConversionListener {
        private boolean myConversionNeeded;
        private boolean myConverted;

        @Override
        public void conversionNeeded() {
            this.myConversionNeeded = true;
        }

        @Override
        public void successfullyConverted(@NotNull File backupDir) {
            if (backupDir == null) {
                MyConversionListener.$$$reportNull$$$0(0);
            }
            this.myConverted = true;
        }

        @Override
        public void error(@NotNull String message) {
            if (message == null) {
                MyConversionListener.$$$reportNull$$$0(1);
            }
            Assert.fail((String)message);
        }

        @Override
        public void cannotWriteToFiles(@NotNull List<? extends File> readonlyFiles) {
            if (readonlyFiles == null) {
                MyConversionListener.$$$reportNull$$$0(2);
            }
        }

        public boolean isConversionNeeded() {
            return this.myConversionNeeded;
        }

        public boolean isConverted() {
            return this.myConverted;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "backupDir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readonlyFiles";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/conversion/ProjectConversionTestUtil$MyConversionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "successfullyConverted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cannotWriteToFiles";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

